/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.ReportSetMutator;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.CompletedUpgrade;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import com.scythebill.birdlist.model.user.UserSet;
import com.scythebill.birdlist.model.util.AndDirty;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;

public class ReportSet {
    private static final ImmutableSet<String> DELETEABLE_BUILT_IN_LOCATIONS = ImmutableSet.of("CU-02", "FI-AL", "FI-ES", "FI-IS", "FI-LL", "FI-LS", new String[]{"FI-OL", "LV-AI", "LV-AL", "LV-BL", "LV-BU", "LV-CE", "LV-DA", "LV-DGV", "LV-DO", "LV-GU", "LV-JEL", "LV-JK", "LV-JL", "LV-JUR", "LV-KR", "LV-KU", "LV-LE", "LV-LM", "LV-LPX", "LV-LU", "LV-MA", "LV-OG", "LV-PR", "LV-RE", "LV-REZ", "LV-RI", "LV-RIX", "LV-SA", "LV-TA", "LV-TU", "LV-VE", "LV-VEN", "LV-VK", "LV-VM", "PA-0", "AX", "RS-KM", "PM", "LK-1", "LK-2", "LK-3", "LK-4", "LK-5", "LK-6", "LK-7", "LK-8", "LK-9", "OM-BA", "OM-JA", "OM-SH", "MD-LA", "MD-TI", "NP-1", "NP-2", "NP-3", "NP-4", "NP-5"});
    private final DirtyImpl dirty = new DirtyImpl(false);
    private final LocationSet locations;
    private final Trips trips;
    private final List<Sighting> sightings;
    private final Dirty externalDirty;
    private final Taxonomy taxonomy;
    private final ReentrantReadWriteLock readWriteLock;
    private final Map<String, Checklist> checklists;
    private final Map<VisitInfoKey, VisitInfo> visitInfos;
    private UserSet userSet;
    private volatile CompletedUpgrade completedUpgrade;
    private ImmutableSet<SightingTaxon> spsToResolve;
    private final Map<String, TaxonomyWithChecklists> extendedTaxonomies;
    private String loadedVersion;
    private String preferencesJson;
    private Taxonomy resolveTaxonomy;
    private ImmutableSet<String> oneTimeUpgrades = ImmutableSet.of();

    public ReportSet(LocationSet locations, Trips trips, List<Sighting> sightings, Taxonomy taxonomy) {
        this.locations = locations;
        this.trips = trips;
        this.sightings = sightings;
        this.taxonomy = Preconditions.checkNotNull(taxonomy);
        this.checklists = Maps.newLinkedHashMap();
        this.visitInfos = Maps.newLinkedHashMap();
        this.extendedTaxonomies = Maps.newLinkedHashMap();
        this.externalDirty = new AndDirty(this.dirty, locations.getDirty());
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public ReadWriteLock sightingsLock() {
        return this.readWriteLock;
    }

    public Dirty getDirty() {
        return this.externalDirty;
    }

    public void markDirty() {
        this.dirty.setDirty(true);
    }

    public void clearDirty() {
        this.dirty.setDirty(false);
        this.locations.clearDirty();
        if (this.userSet != null) {
            this.userSet.clearDirty();
        }
    }

    public LocationSet getLocations() {
        return this.locations;
    }

    public List<Sighting> getSightings() {
        return Collections.unmodifiableList(this.sightings);
    }

    public Iterable<Sighting> getSightings(Taxonomy compatibleTaxonomy) {
        return FluentIterable.from(this.getSightings()).filter(SightingPredicates.compatibleWith(compatibleTaxonomy));
    }

    public void setCompletedUpgrade(CompletedUpgrade completedUpgrade) {
        this.completedUpgrade = completedUpgrade;
        if (completedUpgrade != null) {
            this.markDirty();
        }
    }

    public CompletedUpgrade getCompletedUpgrade() {
        return this.completedUpgrade;
    }

    public ReportSetMutator mutator() {
        return new ReportSetMutator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSightings(Collection<Sighting> newSightings) {
        for (Sighting sighting : newSightings) {
            for (String id : sighting.getTaxon().getIds()) {
                Taxon taxon = sighting.getTaxonomy().getTaxon(id);
                if (taxon != null) continue;
                throw new IllegalArgumentException(String.format("Sighting %s is not valid for %s", sighting.getTaxon(), sighting.getTaxonomy().getName()));
            }
        }
        this.sightingsLock().writeLock().lock();
        try {
            this.dirty.setDirty(true);
            this.sightings.addAll(newSightings);
        }
        finally {
            this.sightingsLock().writeLock().unlock();
        }
    }

    void removeSightings(Collection<Sighting> newSightings) {
        this.sightingsLock().writeLock().lock();
        try {
            this.dirty.setDirty(true);
            this.sightings.removeAll(newSightings);
        }
        finally {
            this.sightingsLock().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLocation(Location location) {
        Preconditions.checkArgument(this.locations.getLocation(location.getId()) == location, "Location is not in the ReportSet");
        Preconditions.checkArgument(location.getParent() != null, "Root locations may not be removed");
        Preconditions.checkArgument(!location.isBuiltInLocation() || location.getEbirdCode() == null || DELETEABLE_BUILT_IN_LOCATIONS.contains(location.getEbirdCode()), "Built-in location %s may not be removed", (Object)location.getEbirdCode());
        Preconditions.checkArgument(location.contents().isEmpty(), "Location with children may not be removed");
        Location parentLocation = location.getParent();
        ArrayList<Sighting> sightingsToRemove = Lists.newArrayList();
        ArrayList<Sighting> sightingsToAdd = Lists.newArrayList();
        this.sightingsLock().writeLock().lock();
        try {
            this.dirty.setDirty(true);
            for (Sighting sighting : this.sightings) {
                if (!location.getId().equals(sighting.getLocationId())) continue;
                Sighting updatedSighting = sighting.asBuilder().setLocation(parentLocation).build();
                sightingsToRemove.add(sighting);
                sightingsToAdd.add(updatedSighting);
            }
            this.sightings.removeAll(sightingsToRemove);
            this.sightings.addAll(sightingsToAdd);
            HashSet<VisitInfoKey> infoKeysAffected = Sets.newHashSet();
            for (VisitInfoKey visitInfoKey : this.visitInfos.keySet()) {
                if (!visitInfoKey.locationId().equals(location.getId())) continue;
                infoKeysAffected.add(visitInfoKey);
            }
            for (VisitInfoKey affectedKey : infoKeysAffected) {
                VisitInfoKey replacementKey = affectedKey.withLocationId(parentLocation.getId());
                if (!this.visitInfos.containsKey(replacementKey)) {
                    VisitInfo affectedValue = this.visitInfos.get(affectedKey);
                    this.visitInfos.put(replacementKey, affectedValue);
                }
                this.visitInfos.remove(affectedKey);
            }
            for (Trip trip : this.trips.allTrips()) {
                if (!location.getId().equals(trip.locationId())) continue;
                trip.setLocation(parentLocation);
            }
        }
        finally {
            this.sightingsLock().writeLock().unlock();
        }
        this.checklists.remove(location.getId());
        this.locations.remove(location);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTrips(Collection<Trip> trips, @Nullable Trip replacementTrip) {
        Set tripIds = trips.stream().map(Trip::id).collect(ImmutableSet.toImmutableSet());
        ArrayList<Sighting> sightingsToRemove = Lists.newArrayList();
        ArrayList<Sighting> sightingsToAdd = Lists.newArrayList();
        this.sightingsLock().writeLock().lock();
        try {
            this.dirty.setDirty(true);
            for (Sighting sighting : this.sightings) {
                if (sighting.getTrip() == null || !tripIds.contains(sighting.getTrip().id())) continue;
                Sighting.Builder toAdd = sighting.asBuilder().setTrip(replacementTrip);
                if (replacementTrip == null && sighting.getStoredDateAsPartial() == null) {
                    ReadablePartial commonDate = Trips.getCommonDate(sighting.getTrip().startDate(), sighting.getTrip().endDate());
                    if (commonDate != null) {
                        toAdd.setDate(commonDate);
                    } else if (sighting.getTrip().startDate().isSupported(DateTimeFieldType.year())) {
                        Partial startYear = new Partial(GJChronology.getInstance()).with(DateTimeFieldType.year(), sighting.getTrip().startDate().get(DateTimeFieldType.year()));
                        toAdd.setDate(startYear);
                    }
                }
                sightingsToAdd.add(toAdd.build());
                sightingsToRemove.add(sighting);
            }
            this.sightings.removeAll(sightingsToRemove);
            this.sightings.addAll(sightingsToAdd);
        }
        finally {
            this.sightingsLock().writeLock().unlock();
        }
        for (Trip trip : trips) {
            this.getTrips().remove(trip);
        }
    }

    public void setSpsToResolve(ImmutableSet<SightingTaxon> spsToResolve, @Nullable Taxonomy resolveTaxonomy) {
        this.spsToResolve = spsToResolve;
        this.resolveTaxonomy = resolveTaxonomy;
    }

    public ImmutableSet<SightingTaxon> getSpsToResolve() {
        return this.spsToResolve;
    }

    @Nullable
    public Taxonomy getResolveTaxonomy() {
        return this.resolveTaxonomy;
    }

    public void setLoadedVersion(String loadedVersion) {
        this.loadedVersion = loadedVersion;
    }

    public String getLoadedVersion() {
        return this.loadedVersion;
    }

    public void setChecklist(Location location, Checklist checklist) {
        Preconditions.checkNotNull(location);
        Preconditions.checkNotNull(checklist);
        this.locations.ensureAdded(location);
        this.checklists.put(location.getId(), checklist);
    }

    public Checklist getChecklist(Location location) {
        return this.checklists.get(location.getId());
    }

    public Map<String, Checklist> checklists() {
        return Collections.unmodifiableMap(this.checklists);
    }

    public void removeChecklist(Location location) {
        this.checklists.remove(location.getId());
    }

    public String getPreferencesJson() {
        return this.preferencesJson;
    }

    public void setPreferencesJson(String preferencesJson, boolean markDirty) {
        this.preferencesJson = preferencesJson;
        if (markDirty) {
            this.dirty.setDirty(true);
        }
    }

    public void setOneTimeUpgrades(Collection<String> oneTimeUpgrades) {
        this.oneTimeUpgrades = ImmutableSet.copyOf(oneTimeUpgrades);
    }

    public ImmutableSet<String> oneTimeUpgrades() {
        return this.oneTimeUpgrades;
    }

    public void addOneTimeUpgrader(String name) {
        this.oneTimeUpgrades = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.oneTimeUpgrades)).add(name)).build();
    }

    public VisitInfo putVisitInfo(VisitInfoKey visitInfoKey, VisitInfo visitInfo) {
        Preconditions.checkNotNull(visitInfoKey);
        Preconditions.checkNotNull(visitInfo);
        return this.visitInfos.put(visitInfoKey, visitInfo);
    }

    public VisitInfo getVisitInfo(VisitInfoKey visitInfoKey) {
        return this.visitInfos.get(Preconditions.checkNotNull(visitInfoKey));
    }

    public VisitInfo removeVisitInfo(VisitInfoKey visitInfoKey) {
        return this.visitInfos.remove(Preconditions.checkNotNull(visitInfoKey));
    }

    public Map<VisitInfoKey, VisitInfo> visitInfos() {
        return Collections.unmodifiableMap(this.visitInfos);
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public Taxonomy getExtendedTaxonomy(String id) {
        TaxonomyWithChecklists taxonomyWithChecklists = this.extendedTaxonomies.get(id);
        return taxonomyWithChecklists == null ? null : taxonomyWithChecklists.taxonomy;
    }

    public ExtendedTaxonomyChecklists getExtendedTaxonomyChecklist(String taxonomyId) {
        TaxonomyWithChecklists taxonomyWithChecklists = this.extendedTaxonomies.get(taxonomyId);
        return taxonomyWithChecklists == null ? null : taxonomyWithChecklists.checklists;
    }

    public boolean hasExtendedTaxonomyChecklists(String taxonomyId) {
        TaxonomyWithChecklists taxonomyWithChecklists = this.extendedTaxonomies.get(taxonomyId);
        if (taxonomyWithChecklists == null) {
            return false;
        }
        if (taxonomyWithChecklists.checklists == null) {
            return false;
        }
        return !taxonomyWithChecklists.checklists.getChecklists().isEmpty();
    }

    public void addExtendedTaxonomy(Taxonomy extendedTaxonomy, ExtendedTaxonomyChecklists checklists) {
        if (this.extendedTaxonomies.containsKey(extendedTaxonomy.getId())) {
            throw new IllegalStateException("Cannot add " + extendedTaxonomy.getName());
        }
        this.extendedTaxonomies.put(extendedTaxonomy.getId(), new TaxonomyWithChecklists(extendedTaxonomy, checklists));
    }

    public Collection<Taxonomy> extendedTaxonomies() {
        return this.extendedTaxonomies.values().stream().map(twc -> twc.taxonomy).collect(ImmutableList.toImmutableList());
    }

    public void removeExtendedTaxonomy(Taxonomy extendedTaxonomy) {
        for (Sighting sighting : this.sightings) {
            if (sighting.getTaxonomy() != extendedTaxonomy) continue;
            throw new IllegalStateException("Sightings still present, can't remove this taxonomy");
        }
        if (!this.extendedTaxonomies.containsKey(extendedTaxonomy.getId())) {
            throw new IllegalStateException("Extended taxonomy " + extendedTaxonomy.getId() + " not found");
        }
        this.extendedTaxonomies.remove(extendedTaxonomy.getId());
        this.markDirty();
    }

    public UserSet getUserSet() {
        return this.userSet;
    }

    public void setUserSet(UserSet userSet) {
        Preconditions.checkState(this.userSet == null, "Cannot reassign already present userSet");
        Preconditions.checkNotNull(userSet);
        this.userSet = userSet;
        userSet.getDirty().addDirtyListener(e -> {
            if (userSet.getDirty().isDirty()) {
                this.markDirty();
            }
        });
        this.markDirty();
    }

    public void clearUserSet() {
        this.userSet = null;
        ImmutableSet<User> users = ImmutableSet.of();
        for (Sighting sighting : this.getSightings()) {
            sighting.getSightingInfo().setUsers(users);
        }
        this.markDirty();
    }

    public void replaceLocation(Location oldLocation, Location newLocation) {
        String oldId = oldLocation.getId();
        Checklist checklist = this.checklists.get(oldId);
        this.locations.replace(oldLocation, newLocation);
        if (checklist != null) {
            this.checklists.remove(oldLocation.getId());
            this.checklists.put(newLocation.getId(), checklist);
        }
    }

    public Trips getTrips() {
        return this.trips;
    }

    static class TaxonomyWithChecklists {
        final Taxonomy taxonomy;
        final ExtendedTaxonomyChecklists checklists;

        TaxonomyWithChecklists(Taxonomy taxonomy, ExtendedTaxonomyChecklists checklists) {
            this.taxonomy = taxonomy;
            this.checklists = checklists;
        }
    }
}

