/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.io.CsvImportLines;
import com.scythebill.birdlist.model.io.ImportLines;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class PredefinedLocations {
    private static final String PREDEFINED_LOCATION_PREFIX = "scyco";
    private final ImmutableMultimap<String, PredefinedLocationImpl> locations;
    private final ImmutableMultimap<String, UsCounty> usCounties;
    private static final Ordering<PredefinedLocation> PREDEFINED_ORDERING = new Ordering<PredefinedLocation>(){

        @Override
        public int compare(PredefinedLocation first, PredefinedLocation second) {
            return first.toString().compareToIgnoreCase(second.toString());
        }
    };
    private static final ImmutableMap<String, Location.Type> TYPE_NAMES = ImmutableMap.of("State", Location.Type.state, "County", Location.Type.county, "City", Location.Type.city, "Country in Country", Location.Type.country);

    public ImmutableCollection<PredefinedLocation> getPredefinedLocations(Location location) {
        if (location.getEbirdCode() == null) {
            return ImmutableList.of();
        }
        if (location.getType() != Location.Type.country) {
            if (location.getType() == Location.Type.state) {
                if (!location.isBuiltInLocation() || !location.getParent().isBuiltInLocation()) {
                    return ImmutableList.of();
                }
                if (location.getModelName().equals(location.getParent().getModelName())) {
                    return ImmutableList.of();
                }
            } else {
                return ImmutableList.of();
            }
        }
        if (location.isBuiltInLocation() && "United States".equals(location.getParent().getModelName()) && location.getType() == Location.Type.state) {
            Collection collection = this.usCounties.get((Object)location.getEbirdCode());
            return ImmutableSortedSet.copyOf(PREDEFINED_ORDERING, collection);
        }
        ImmutableSortedSet<PredefinedLocationImpl> collection = ImmutableSortedSet.copyOf(PREDEFINED_ORDERING, this.getNamesAndIdsOfStates(location.getModelName()));
        if (collection.size() < 2) {
            return ImmutableList.of();
        }
        ImmutableList.Builder locations = ImmutableList.builder();
        for (PredefinedLocationImpl predefined : collection) {
            if (predefined.getRequiredGrandParent() != null && !this.hasPredefinedAncestorWithName(location.getParent(), predefined.getRequiredGrandParent())) continue;
            locations.add(predefined);
        }
        return locations.build();
    }

    private boolean hasPredefinedAncestorWithName(Location location, String name) {
        while (location != null) {
            if (location.isBuiltInLocation()) {
                return name.equals(location.getModelName());
            }
            location = location.getParent();
        }
        return false;
    }

    @Deprecated
    public PredefinedLocation getPredefinedLocationChild(Location country, String childName) {
        ImmutableCollection<PredefinedLocation> predefinedLocations = this.getPredefinedLocations(country);
        for (PredefinedLocation location : predefinedLocations) {
            if (!this.namesAreEqualIgnoringCaseAndAccents(childName, location.getName())) continue;
            return location;
        }
        return null;
    }

    public PredefinedLocation getPredefinedLocationChildThatHasNotBeenCreatedYet(LocationSet locationSet, Location country, String childName) {
        ImmutableCollection<PredefinedLocation> predefinedLocations = this.getPredefinedLocations(country);
        for (PredefinedLocation location : predefinedLocations) {
            if (!this.namesAreEqualIgnoringCaseAndAccents(childName, location.getName())) continue;
            if (locationSet.getLocationByCode(location.getCode()) != null) {
                return null;
            }
            return location;
        }
        return null;
    }

    public Location createPredefinedLocationChildRecursively(LocationSet locations, Location country, String childName) {
        ImmutableCollection<PredefinedLocation> predefinedLocations = this.getPredefinedLocations(country);
        for (PredefinedLocation location : predefinedLocations) {
            if (!this.namesAreEqualIgnoringCaseAndAccents(childName, location.getName())) continue;
            return location.create(locations, country);
        }
        for (PredefinedLocation location : predefinedLocations) {
            Location found = this.createPredefinedLocationChildRecursively(locations, location.create(locations, country), childName);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public PredefinedLocation getPredefinedLocationChildByCode(Location country, String code) {
        ImmutableCollection<PredefinedLocation> predefinedLocations = this.getPredefinedLocations(country);
        for (PredefinedLocation location : predefinedLocations) {
            if (!code.equals(location.getCode())) continue;
            return location;
        }
        return null;
    }

    private boolean namesAreEqualIgnoringCaseAndAccents(String first, String second) {
        return StringUtils.stripAccents(first).equalsIgnoreCase(StringUtils.stripAccents(second));
    }

    ImmutableCollection<PredefinedLocationImpl> getNamesAndIdsOfStates(String country) {
        return this.locations.get((Object)country);
    }

    ImmutableSet<String> countries() {
        return this.locations.keySet();
    }

    private PredefinedLocations(ImmutableMultimap<String, PredefinedLocationImpl> locations, ImmutableMultimap<String, UsCounty> usCounties) {
        this.locations = locations;
        this.usCounties = usCounties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PredefinedLocations loadAndParse() {
        try {
            ImmutableMultimap.Builder<String, PredefinedLocationImpl> builder = ImmutableMultimap.builder();
            URL url = Resources.getResource(PredefinedLocations.class, "all-states.csv");
            try (ImportLines importLines = CsvImportLines.fromUrl(url, StandardCharsets.UTF_8);){
                String[] nextLine;
                importLines.nextLine();
                while ((nextLine = importLines.nextLine()) != null) {
                    String type = nextLine[3];
                    if ("Country".equals(type)) continue;
                    Location.Type locationType = TYPE_NAMES.get(type);
                    Preconditions.checkState(locationType != null, "Unexpected type %s", (Object)type);
                    String requiredParent = null;
                    if (nextLine.length > 4) {
                        requiredParent = nextLine[4];
                    }
                    builder.put(nextLine[2], new PredefinedLocationImpl(nextLine[1], nextLine[0], locationType, requiredParent));
                }
            }
            ImmutableMultimap.Builder<String, UsCounty> usCounties = ImmutableMultimap.builder();
            URL countyUrl = Resources.getResource(PredefinedLocations.class, "us-counties.csv");
            try (ImportLines countyImport = CsvImportLines.fromUrl(countyUrl, StandardCharsets.UTF_8);){
                String[] nextLine;
                countyImport.nextLine();
                while ((nextLine = countyImport.nextLine()) != null) {
                    boolean isCity = nextLine.length >= 4 && "City".equals(nextLine[3]);
                    String code = String.format("US-%s-%s", nextLine[1], nextLine[2]);
                    usCounties.put(nextLine[1], new UsCounty(nextLine[0], isCity, code));
                }
            }
            return new PredefinedLocations(builder.build(), usCounties.build());
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException", e);
        }
    }

    public void mergeInto(LocationSet locations, Location location) {
        ImmutableCollection<PredefinedLocationImpl> namesAndIdsOfStates = this.getNamesAndIdsOfStates(location.getModelName());
        for (PredefinedLocationImpl nameAndId : namesAndIdsOfStates) {
            Location existingChild = location.getContent(nameAndId.getName());
            if (existingChild != null) continue;
            Location.Builder builder = Location.builder().setName(nameAndId.getName()).setType(nameAndId.getType()).setParent(location).setBuiltInPrefix(PREDEFINED_LOCATION_PREFIX).setEbirdCode(nameAndId.getCode());
            locations.addLocation(builder.build());
        }
    }

    static class PredefinedLocationImpl
    implements PredefinedLocation {
        private final String name;
        private final String id;
        private final Location.Type type;
        private final String requiredGrandParent;

        PredefinedLocationImpl(String name, String id, Location.Type type, String requiredGrandParent) {
            Preconditions.checkArgument(!name.isEmpty());
            Preconditions.checkArgument(!"".equals(requiredGrandParent));
            this.name = name;
            this.id = Preconditions.checkNotNull(Strings.emptyToNull(id));
            this.type = type;
            this.requiredGrandParent = requiredGrandParent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getCode() {
            return this.id;
        }

        @Override
        public Location.Type getType() {
            return this.type;
        }

        public String getRequiredGrandParent() {
            return this.requiredGrandParent;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public Location create(LocationSet locations, Location parent) {
            Location preexisting;
            if (this.id != null && (preexisting = locations.getLocationByCode(this.id)) != null) {
                return preexisting;
            }
            Location.Builder newLocation = Location.builder().setBuiltInPrefix(PredefinedLocations.PREDEFINED_LOCATION_PREFIX).setName(this.name).setType(this.type).setParent(parent);
            if (this.id != null) {
                newLocation.setEbirdCode(this.id);
            }
            return newLocation.build();
        }
    }

    public static interface PredefinedLocation {
        public Location.Type getType();

        public String getName();

        public String getCode();

        public Location create(LocationSet var1, Location var2);
    }

    static class UsCounty
    implements PredefinedLocation {
        private final String name;
        private final boolean isCity;
        private final String code;

        UsCounty(String name, boolean isCity, String code) {
            this.name = name;
            this.isCity = isCity;
            this.code = code;
        }

        @Override
        public Location.Type getType() {
            return this.isCity ? Location.Type.city : Location.Type.county;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getCode() {
            return this.code;
        }

        @Override
        public Location create(LocationSet locations, Location parent) {
            Location preexisting = locations.getLocationByCode(this.code);
            if (preexisting != null) {
                return preexisting;
            }
            Location.Builder newLocation = Location.builder().setBuiltInPrefix(PredefinedLocations.PREDEFINED_LOCATION_PREFIX).setName(this.name).setType(this.getType()).setParent(parent).setEbirdCode(this.code);
            return newLocation.build();
        }

        public String toString() {
            if (this.isCity) {
                return this.getName() + " (City)";
            }
            return this.getName();
        }
    }
}

