/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class Locations {
    private static final ImmutableMap<String, String> UNUSUAL_PARENT_CODES = ImmutableMap.of("CW", "BQ", "SX", "BQ");
    private static final ImmutableSet<Location.Type> GROUPED_LOCATION_TERMINI = ImmutableSet.of(Location.Type.town, Location.Type.city, Location.Type.county, Location.Type.state, Location.Type.country, Location.Type.region, new Location.Type[0]);

    private Locations() {
    }

    public static Location getAncestorOfType(Location location, Location.Type type) {
        while (location.getType() != type && (location = location.getParent()) != null) {
        }
        return location;
    }

    public static String getLocationCode(Location location) {
        Object code = location.getEbirdCode();
        if (code == null) {
            return null;
        }
        if (location.getType() == Location.Type.state && Locations.isUsChild(location.getParent())) {
            code = "US-" + (String)code;
        }
        return code;
    }

    private static boolean isUsChild(Location location) {
        while (location != null) {
            if ("US".equals(location.getEbirdCode())) {
                return true;
            }
            location = location.getParent();
        }
        return false;
    }

    private static String getParentCode(String code) {
        int lastHyphen = code.lastIndexOf(45);
        if (lastHyphen < 0) {
            return UNUSUAL_PARENT_CODES.get(code);
        }
        return code.substring(0, lastHyphen);
    }

    public static String getGroupedLocationDisplayName(Location location) {
        String locationName = location.getDisplayName();
        Location parent = location.getParent();
        if (parent == null || GROUPED_LOCATION_TERMINI.contains((Object)parent.getType())) {
            return locationName;
        }
        String parentName = Locations.getGroupedLocationDisplayName(parent);
        if (locationName.contains(parentName)) {
            return locationName;
        }
        return parentName + "--" + locationName;
    }

    public static String getGroupedLocationModelName(Location location) {
        String locationName = location.getModelName();
        Location parent = location.getParent();
        if (parent == null || GROUPED_LOCATION_TERMINI.contains((Object)parent.getType())) {
            return locationName;
        }
        String parentName = Locations.getGroupedLocationModelName(parent);
        if (locationName.contains(parentName)) {
            return locationName;
        }
        return parentName + "--" + locationName;
    }

    public static String getGroupedLocationPrefix(String locationName) {
        int locationGroupIndex = locationName.indexOf("--");
        if (locationGroupIndex < 0) {
            return null;
        }
        return locationName.substring(0, locationGroupIndex);
    }

    public static String getGroupedLocationGroupSuffix(String locationName) {
        int locationGroupIndex = locationName.indexOf("--");
        if (locationGroupIndex < 0) {
            return null;
        }
        return locationName.substring(locationGroupIndex + 2);
    }

    public static Location getLocationByCodePossiblyCreating(LocationSet locations, PredefinedLocations predefinedLocations, String code) {
        Location parentLocation;
        Location locationByCode = locations.getLocationByCode(code);
        if (locationByCode != null) {
            return locationByCode;
        }
        String parentCode = Locations.getParentCode(code);
        if (parentCode == null) {
            return null;
        }
        Collection<Location> multiplePossibleParents = locations.getLocationsByCode(parentCode);
        if (!multiplePossibleParents.isEmpty()) {
            for (Location parentLocation2 : multiplePossibleParents) {
                PredefinedLocations.PredefinedLocation predefinedLocation = predefinedLocations.getPredefinedLocationChildByCode(parentLocation2, code);
                if (predefinedLocation == null) continue;
                return predefinedLocation.create(locations, parentLocation2);
            }
        }
        if ((parentLocation = Locations.getLocationByCodePossiblyCreating(locations, predefinedLocations, parentCode)) == null) {
            return null;
        }
        PredefinedLocations.PredefinedLocation predefinedLocation = predefinedLocations.getPredefinedLocationChildByCode(parentLocation, code);
        if (predefinedLocation == null) {
            return null;
        }
        return predefinedLocation.create(locations, parentLocation);
    }

    public static boolean isDescendentOfLocation(Location location, Location descendent) {
        while (descendent != null) {
            if (descendent == location) {
                return true;
            }
            descendent = descendent.getParent();
        }
        return false;
    }

    public static void reparentReplacingIfNeeded(Location child, Location newParent, ReportSet reportSet) {
        Location existingChild = newParent.getContent(child.getModelName());
        if (existingChild != null) {
            Locations.replaceLocation(child, existingChild, reportSet);
        }
        child.reparent(newParent);
    }

    public static void replaceLocation(Location newLocation, Location oldLocation, ReportSet reportSet) {
        Location locationWithNewName = oldLocation.asBuilder().setName("~~~~~" + oldLocation.getModelName()).setParent(oldLocation.getParent()).setType(oldLocation.getType()).build();
        reportSet.getLocations().replace(oldLocation, locationWithNewName);
        reportSet.getLocations().ensureAdded(newLocation);
        for (Location child : ImmutableList.copyOf(locationWithNewName.contents())) {
            Location possiblyPreExistingChild = newLocation.getContent(child.getModelName());
            if (possiblyPreExistingChild != null) {
                Locations.replaceLocation(possiblyPreExistingChild, child, reportSet);
                continue;
            }
            child.reparent(newLocation);
        }
        locationWithNewName.reparent(newLocation);
        reportSet.deleteLocation(locationWithNewName);
    }

    public static Location getCommonAncestor(Location first, Location second) {
        Location secondEntry;
        Location firstEntry;
        if (first == null || second == null) {
            return null;
        }
        if (Locations.sameLocation(first, second)) {
            return first;
        }
        List<Location> firstPath = Locations.getLocationPath(first);
        List<Location> secondPath = Locations.getLocationPath(second);
        Location common = null;
        Iterator<Location> firstPathIterator = firstPath.iterator();
        Iterator<Location> secondPathIterator = secondPath.iterator();
        while (firstPathIterator.hasNext() && secondPathIterator.hasNext() && Locations.sameLocation(firstEntry = firstPathIterator.next(), secondEntry = secondPathIterator.next())) {
            common = firstEntry;
        }
        return common;
    }

    private static boolean sameLocation(Location firstEntry, Location secondEntry) {
        if (firstEntry == secondEntry) {
            return true;
        }
        String firstCode = Locations.getLocationCode(firstEntry);
        String secondCode = Locations.getLocationCode(secondEntry);
        return firstCode != null && secondCode != null && firstCode.equals(secondCode);
    }

    private static List<Location> getLocationPath(Location location) {
        LinkedList<Location> list = Lists.newLinkedList();
        while (location != null) {
            list.addFirst(location);
            location = location.getParent();
        }
        return list;
    }

    public static Location normalizeLocation(Location location, LocationSet locations) {
        if (location.getId() != null) {
            return location;
        }
        Location parent = location.getParent();
        if (parent == null) {
            return location;
        }
        Location normalizedParent = Locations.normalizeLocation(parent, locations);
        Location preexisting = normalizedParent.getContent(location.getModelName());
        if (preexisting != null) {
            location = preexisting;
        } else if (normalizedParent != parent) {
            location = location.asBuilder().setParent(normalizedParent).build();
        }
        return location;
    }

    public static Location getBuiltInAncestor(Location location) {
        while (location != null) {
            if (location.isBuiltInLocation()) {
                return location;
            }
            location = location.getParent();
        }
        return null;
    }

    public static void visitLocations(LocationSet locationSet, Consumer<Location> visitor) {
        for (Location location : locationSet.rootLocations()) {
            Locations.visitLocations(location, visitor);
        }
    }

    public static Location getBuiltInLocationByModelName(LocationSet locationSet, String modelName) {
        for (Location location : locationSet.getLocationsByModelName(modelName)) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }

    public static void visitLocations(Location location, Consumer<Location> visitor) {
        visitor.accept(location);
        for (Location child : location.contents()) {
            Locations.visitLocations(child, visitor);
        }
    }
}

