/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationImpl;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.util.Dirty;
import com.scythebill.birdlist.model.util.DirtyImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;

public class LocationSet {
    private final Map<String, Location> idToLocationMap = Maps.newHashMap();
    private final Multimap<String, Location> nameToLocationMap = ArrayListMultimap.create();
    private final Map<String, Location> locationCodeToLocationMap = Maps.newHashMap();
    private final Multimap<String, Location> locationCodeToLocationMultimap = ArrayListMultimap.create();
    private final DirtyImpl dirty = new DirtyImpl(false);
    private static final Logger logger = Logger.getLogger(LocationSet.class.getName());
    private final Map<String, Location> restoredLocations = Maps.newHashMap();
    private Supplier<Multimap<String, Location>> displayNameToLocationMapSupplier;
    private static final ImmutableSet<String> REPEATED_LOCATION_CODES = ImmutableSet.of("US", "ID", "RU", "TR", "XX", "BQ", new String[]{"EG"});

    private LocationSet() {
        this.resetDisplayNameToLocationMapSupplier();
    }

    private void resetDisplayNameToLocationMapSupplier() {
        this.displayNameToLocationMapSupplier = Suppliers.memoize(() -> {
            ArrayListMultimap<String, Location> multimap = ArrayListMultimap.create();
            for (Location location : this.rootLocations()) {
                LocationSet.populateDisplayNameToLocationMap(location, multimap);
            }
            return multimap;
        });
    }

    private static void populateDisplayNameToLocationMap(Location location, Multimap<String, Location> multimap) {
        multimap.put(location.getDisplayName(), location);
        for (Location child : location.contents()) {
            LocationSet.populateDisplayNameToLocationMap(child, multimap);
        }
    }

    public Dirty getDirty() {
        return this.dirty;
    }

    public void clearDirty() {
        this.dirty.setDirty(false);
    }

    public void markDirty() {
        this.dirty.setDirty(true);
    }

    public Collection<Location> getLocationsByModelName(String modelName) {
        return this.nameToLocationMap.get(modelName);
    }

    public Collection<Location> getLocationsByDisplayName(String displayName) {
        return this.displayNameToLocationMapSupplier.get().get(displayName);
    }

    public String addLocation(Location loc) {
        if (loc.getParent() != null && loc.getParent().getId() == null) {
            this.addLocation(loc.getParent());
        }
        this.dirty.setDirty(true);
        LocationImpl impl = (LocationImpl)loc;
        String id = this.createId(impl);
        this.addLocation(impl, id);
        return id;
    }

    public Location getLocation(String id) {
        return this.idToLocationMap.get(id);
    }

    public Location getLocationByCode(String code) {
        return this.locationCodeToLocationMap.get(code);
    }

    public Collection<Location> getLocationsByCode(String code) {
        return Collections.unmodifiableCollection(this.locationCodeToLocationMultimap.get(code));
    }

    public Collection<Location> rootLocations() {
        HashSet<Location> rootLocations = new HashSet<Location>();
        for (Location location : this.idToLocationMap.values()) {
            if (location.getParent() != null) continue;
            rootLocations.add(location);
        }
        return Collections.unmodifiableSet(rootLocations);
    }

    private String addLocation(LocationImpl loc, String id) {
        if (this.idToLocationMap.containsKey(id)) {
            throw new IllegalArgumentException("ID " + id + " has already been used for a location.");
        }
        loc.locationAdded(id);
        this.idToLocationMap.put(id, loc);
        this.nameToLocationMap.put(loc.getModelName(), loc);
        String locationCode = Locations.getLocationCode(loc);
        if (locationCode != null) {
            Location preexisting = this.locationCodeToLocationMap.put(locationCode, loc);
            if (preexisting != null && !REPEATED_LOCATION_CODES.contains(locationCode)) {
                logger.warning("Multiple locations with code " + locationCode);
            }
            this.locationCodeToLocationMultimap.put(locationCode, loc);
        }
        this.resetDisplayNameToLocationMapSupplier();
        return id;
    }

    private String createId(LocationImpl loc) {
        String baseId = loc.getDefaultId();
        Object id = null;
        int i = 0;
        while (this.idToLocationMap.containsKey(id = i == 0 ? baseId : baseId + Integer.toString(i))) {
            ++i;
        }
        return id;
    }

    void replace(Location oldLocation, Location newLocation) {
        String newLocationCode;
        Preconditions.checkArgument(newLocation.getId() == null, "New location already has an ID");
        Preconditions.checkArgument(oldLocation.getId() != null, "Old location does not have an ID");
        Preconditions.checkArgument(newLocation instanceof LocationImpl, "New location is of wrong type");
        Preconditions.checkArgument(oldLocation instanceof LocationImpl, "Old location is of wrong type");
        ((LocationImpl)newLocation).locationAddedAsReplacement((LocationImpl)oldLocation);
        Preconditions.checkState(oldLocation.getId().equals(newLocation.getId()));
        this.idToLocationMap.put(newLocation.getId(), newLocation);
        this.nameToLocationMap.remove(oldLocation.getModelName(), oldLocation);
        this.nameToLocationMap.put(newLocation.getModelName(), newLocation);
        String oldLocationCode = Locations.getLocationCode(oldLocation);
        if (oldLocationCode != null) {
            this.locationCodeToLocationMap.remove(oldLocationCode);
            this.locationCodeToLocationMultimap.remove(oldLocationCode, oldLocation);
        }
        if ((newLocationCode = Locations.getLocationCode(newLocation)) != null) {
            this.locationCodeToLocationMap.put(newLocationCode, newLocation);
            this.locationCodeToLocationMultimap.put(newLocationCode, newLocation);
        }
        this.resetDisplayNameToLocationMapSupplier();
        this.dirty.setDirty(true);
        ((LocationImpl)oldLocation).setIdInternal(null);
    }

    void remove(Location location) {
        Preconditions.checkArgument(this.getLocation(location.getId()) == location, "Location is not in the ReportSet");
        Preconditions.checkArgument(location.getParent() != null, "Root locations may not be removed");
        Preconditions.checkArgument(location.contents().isEmpty(), "Location with children may not be removed");
        this.idToLocationMap.remove(location.getId());
        this.nameToLocationMap.remove(location.getModelName(), location);
        String locationCode = Locations.getLocationCode(location);
        if (locationCode != null) {
            this.locationCodeToLocationMap.remove(locationCode);
            this.locationCodeToLocationMultimap.remove(locationCode, location);
        }
        this.resetDisplayNameToLocationMapSupplier();
        ((LocationImpl)location).setParent(null);
        ((LocationImpl)location).setIdInternal(null);
    }

    public void ensureAdded(Location location) {
        if (location.getParent() != null) {
            this.ensureAdded(location.getParent());
        }
        if (location.getId() != null) {
            return;
        }
        this.addLocation(location);
    }

    public void addRestoredLocation(String locationId, Location location) {
        Preconditions.checkArgument(location.getId() == null);
        Preconditions.checkArgument(this.getLocation(locationId) == null);
        Preconditions.checkArgument(location.getParent() == null);
        this.addLocation((LocationImpl)location, locationId);
        this.dirty.setDirty(true);
        this.restoredLocations.put(locationId, location);
    }

    public Map<String, Location> restoredLocations() {
        return Collections.unmodifiableMap(this.restoredLocations);
    }

    public static class Builder {
        private final LocationSet locations = new LocationSet();

        public void addLocation(Location loc, String id) {
            this.locations.addLocation((LocationImpl)loc, id);
        }

        public void replace(Location oldLocation, Location newLocation) {
            this.locations.replace(oldLocation, newLocation);
        }

        public LocationSet build() {
            return this.locations;
        }
    }
}

