/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.util.LocalePreferences;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

class LocationImpl
extends Location {
    private static final int DEFAULT_ID_LENGTH = 6;
    private static final String BUILT_IN_PREFIX = "_";
    private Map<String, Location> contents;
    private Location parent;
    private String id;
    private final String ebirdCode;
    private final String builtInPrefix;
    private final Optional<LatLongCoordinates> latLong;
    private final String description;
    private final boolean privateLocation;
    private static LoadingCache<Locale, TranslatedLocations> translatedLocationsCache = CacheBuilder.newBuilder().build(new CacheLoader<Locale, TranslatedLocations>(){

        @Override
        public TranslatedLocations load(Locale locale) {
            return new TranslatedLocations(locale);
        }
    });
    private static final ImmutableMap<String, String> REGIONS_TO_KEYS = ImmutableMap.builder().put("North America", "NORTH_AMERICA").put("Central America", "CENTRAL_AMERICA").put("West Indies", "WEST_INDIES").put("South America", "SOUTH_AMERICA").put("Eurasia", "EURASIA").put("Europe", "EUROPE").put("Asia", "ASIA").put("Africa", "AFRICA").put("Australasia", "AUSTRALASIA").put("Pacific Ocean", "PACIFIC_OCEAN").put("Indian Ocean", "INDIAN_OCEAN").put("Atlantic Ocean", "ATLANTIC_OCEAN").put("Arctic Ocean", "ARCTIC_OCEAN").put("South Polar Region", "SOUTH_POLAR_REGION").build();
    private static final ImmutableSet<String> TRANSLATED_STATE_CODES = ImmutableSet.of("EC-W", "PM", "CO-SAP");
    private static final Splitter WHITESPACE_SPLITTER = Splitter.on(CharMatcher.whitespace()).omitEmptyStrings();

    LocationImpl(Location.Builder builder) {
        super(builder.type, Preconditions.checkNotNull(builder.name));
        this.ebirdCode = builder.ebirdCode;
        this.parent = builder.parent;
        this.builtInPrefix = builder.builtInPrefix != null ? BUILT_IN_PREFIX + builder.builtInPrefix + BUILT_IN_PREFIX : null;
        this.latLong = Optional.fromNullable(builder.latLong);
        this.description = Strings.emptyToNull(builder.description);
        this.privateLocation = builder.privateLocation;
    }

    @Override
    public void reparent(Location newIn) {
        this.setParent(Preconditions.checkNotNull(newIn));
    }

    void setParent(Location newParent) {
        if (newParent == this.parent) {
            return;
        }
        if (this.id == null) {
            throw new IllegalStateException("Reparenting a Location without an ID is unnecessary");
        }
        if (newParent != null && newParent.getId() == null) {
            throw new IllegalStateException("Adding a ID'd child to an ID-less parent is broken");
        }
        if (newParent != null && newParent.getContent(this.getModelName()) != null) {
            throw new IllegalStateException(String.format("Parent %s already has a child named %s", newParent.getModelName(), this.getModelName()));
        }
        if (this.parent != null) {
            ((LocationImpl)this.parent).removeChild(this);
        }
        this.parent = newParent;
        if (newParent != null) {
            ((LocationImpl)newParent).addChild(this);
        }
    }

    @Override
    public Location getContent(String name) {
        if (this.contents == null) {
            return null;
        }
        return this.contents.get(name);
    }

    @Override
    public Collection<Location> contents() {
        if (this.contents == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableCollection(this.contents.values());
    }

    @Override
    public boolean isIn(Location ancestor) {
        if (ancestor == null) {
            throw new NullPointerException();
        }
        Location loc = this;
        do {
            if (loc != ancestor) continue;
            return true;
        } while ((loc = ((Location)loc).getParent()) != null);
        return false;
    }

    @Override
    public String getEbirdCode() {
        return this.ebirdCode;
    }

    @Override
    public String getDisplayName() {
        if (this.isBuiltInLocation()) {
            String key;
            String code = Locations.getLocationCode(this);
            if (this.getType() == Location.Type.state && !TRANSLATED_STATE_CODES.contains(code)) {
                return this.getModelName();
            }
            Locale locale = LocalePreferences.instance().getUiLocale();
            TranslatedLocations translatedLocations = translatedLocationsCache.getUnchecked(locale);
            if (code != null && translatedLocations.bundleKeys.contains(code)) {
                return translatedLocations.bundle.getString(code);
            }
            if (this.getType() == Location.Type.region && (key = REGIONS_TO_KEYS.get(this.getModelName())) != null) {
                return translatedLocations.bundle.getString(key);
            }
        }
        return this.getModelName();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Location getParent() {
        return this.parent;
    }

    public int hashCode() {
        return (this.getModelName() == null ? 0 : this.getModelName().hashCode()) * 37 + (this.parent == null ? 0 : this.parent.hashCode());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationImpl)) {
            return false;
        }
        LocationImpl that = (LocationImpl)o;
        return Objects.equal(that.parent, this.parent) && Objects.equal(that.getModelName(), this.getModelName()) && Objects.equal((Object)that.getType(), (Object)this.getType()) && Objects.equal(that.getDescription(), this.getDescription()) && Objects.equal(that.getLatLong(), this.getLatLong());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Location[name=");
        builder.append(this.getModelName());
        if (this.getType() != null) {
            builder.append(",type=").append((Object)this.getType());
        }
        if (this.getParent() != null) {
            builder.append(",in=").append(this.getParent());
        }
        if (this.getLatLong().isPresent()) {
            builder.append(",latLong=").append(this.getLatLong().get());
        }
        if (this.getDescription() != null) {
            builder.append(",description=").append(this.getDescription());
        }
        builder.append("]");
        return builder.toString();
    }

    void locationAdded(String id) {
        this.setIdInternal(id);
        if (this.parent != null) {
            ((LocationImpl)this.parent).addChild(this);
        }
    }

    void locationAddedAsReplacement(LocationImpl oldLocation) {
        this.setIdInternal(oldLocation.getId());
        if (oldLocation.contents != null) {
            for (Location child : ImmutableList.copyOf(oldLocation.contents.values())) {
                ((LocationImpl)child).setParent(this);
            }
        }
        if (oldLocation.getParent() != null) {
            if (oldLocation.getParent() == this.getParent()) {
                ((LocationImpl)oldLocation.getParent()).replaceChild(oldLocation, this);
            } else {
                ((LocationImpl)oldLocation.getParent()).removeChild(oldLocation);
                ((LocationImpl)this.getParent()).addChild(this);
            }
        }
    }

    void setIdInternal(String id) {
        this.id = id;
    }

    String getDefaultId() {
        StringBuilder builder = new StringBuilder(6);
        String[] nameParts = Iterables.toArray(WHITESPACE_SPLITTER.split(this.getModelName()), String.class);
        for (int i = 0; i < nameParts.length; ++i) {
            String namePart = nameParts[i];
            int remainingChars = 6 - builder.length();
            int charsPerWord = (int)Math.round(Math.ceil((float)remainingChars / (float)(nameParts.length - i)));
            this.addFirstIdChars(builder, namePart, charsPerWord);
        }
        if (builder.length() > 6) {
            builder.setLength(6);
        }
        return this.builtInPrefix != null ? this.builtInPrefix + builder.toString() : builder.toString();
    }

    private void addFirstIdChars(StringBuilder buffer, String name, int charCount) {
        int len = name.length();
        int added = 0;
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if ((ch < 'A' || ch > 'Z') && (ch < 'a' || ch > 'z')) continue;
            buffer.append(Character.toLowerCase(ch));
            if (++added >= charCount) break;
        }
    }

    void replaceChild(Location oldLocation, Location newLocation) {
        Preconditions.checkState(oldLocation.getParent() == this);
        Preconditions.checkState(newLocation.getParent() == this);
        this.contents.remove(oldLocation.getModelName());
        this.contents.put(newLocation.getModelName(), newLocation);
    }

    private void addChild(LocationImpl child) {
        String name;
        if (this.contents == null) {
            this.contents = Maps.newLinkedHashMap();
        }
        if (this.contents.containsKey(name = child.getModelName())) {
            throw new IllegalStateException("Location " + name + " already exists in " + this.getModelName());
        }
        this.contents.put(name, child);
    }

    private void removeChild(LocationImpl child) {
        String name = child.getModelName();
        if (this.contents == null || this.contents.get(name) != child) {
            throw new IllegalStateException(child.toString() + " was not in " + this);
        }
        this.contents.remove(name);
    }

    @Override
    public boolean isBuiltInLocation() {
        if (this.id == null) {
            return this.builtInPrefix != null;
        }
        return this.id.startsWith(BUILT_IN_PREFIX);
    }

    @Override
    public Optional<LatLongCoordinates> getLatLong() {
        return this.latLong;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isPrivate() {
        return this.privateLocation;
    }

    static class TranslatedLocations {
        final ResourceBundle bundle;
        final ImmutableSet<String> bundleKeys;

        TranslatedLocations(Locale locale) {
            this.bundle = ResourceBundle.getBundle("com.scythebill.birdlist.model.sighting.locations", locale);
            this.bundleKeys = ImmutableSet.copyOf(this.bundle.keySet());
        }
    }
}

