/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.LocationImpl;
import java.util.Collection;

public abstract class Location {
    private final String name;
    private final Type type;

    public static Builder builder() {
        return new Builder();
    }

    protected Location(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public final String getModelName() {
        return this.name;
    }

    public final Type getType() {
        return this.type;
    }

    public Builder asBuilder() {
        Builder builder = new Builder().setName(this.name).setParent(this.getParent()).setEbirdCode(this.getEbirdCode()).setLatLong(this.getLatLong().orNull()).setType(this.getType()).setPrivate(this.isPrivate()).setDescription(this.getDescription());
        return builder;
    }

    public String getDisplayName() {
        return this.getModelName();
    }

    public abstract void reparent(Location var1);

    public abstract Collection<Location> contents();

    public abstract Location getContent(String var1);

    public abstract boolean isIn(Location var1);

    public abstract String getEbirdCode();

    public abstract String getId();

    public abstract Location getParent();

    public abstract boolean isBuiltInLocation();

    public abstract Optional<LatLongCoordinates> getLatLong();

    public abstract String getDescription();

    public abstract boolean isPrivate();

    public static class Builder {
        String name;
        String description;
        Type type;
        String ebirdCode;
        Location parent;
        boolean privateLocation;
        String builtInPrefix;
        LatLongCoordinates latLong;

        public Builder setName(String name) {
            if (Strings.isNullOrEmpty(name)) {
                throw new IllegalArgumentException("Empty names are not allowed for locations.");
            }
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setType(Type type) {
            this.type = type;
            return this;
        }

        public Builder setEbirdCode(String ebirdCode) {
            this.ebirdCode = ebirdCode;
            return this;
        }

        public Builder setLatLong(LatLongCoordinates latLong) {
            this.latLong = latLong;
            return this;
        }

        public Builder setParent(Location parent) {
            this.parent = parent;
            return this;
        }

        public Builder setPrivate(boolean privateLocation) {
            this.privateLocation = privateLocation;
            return this;
        }

        public Builder setBuiltInPrefix(String builtInPrefix) {
            this.builtInPrefix = builtInPrefix;
            return this;
        }

        public Location build() {
            return new LocationImpl(this);
        }
    }

    public static enum Type {
        park("Park"),
        town("Town"),
        city("City"),
        county("County"),
        state("State/Province"),
        country("Country"),
        region("Region");

        private final String text;

        private Type(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

