/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;

public class Link
implements Cloneable {
    private final URI uri;
    private String name;

    public Link(File file) {
        this(file.toURI());
    }

    public Link(URI uri) {
        if ("file".equals(uri.getScheme()) && "localhost".equals(uri.getAuthority())) {
            try {
                uri = new URI(uri.getScheme(), null, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        this.uri = uri;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean isFileBased() {
        return "file".equals(this.uri.getScheme());
    }

    public File toFile() {
        Preconditions.checkState(this.isFileBased());
        return new File(this.uri);
    }

    public String getDisplayName() {
        if (this.name != null) {
            return this.name;
        }
        return Link.lastPartOfPathWithoutFileExtension(this.uri);
    }

    private static String lastPartOfPathWithoutFileExtension(URI uri) {
        int lastPeriod;
        String path = uri.getPath();
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == path.length() - 1) {
            lastSlash = path.lastIndexOf(47, lastSlash - 1);
        }
        if (lastSlash > 0) {
            path = path.substring(lastSlash + 1);
        }
        if ((lastPeriod = path.lastIndexOf(46)) > 0) {
            path = path.substring(0, lastPeriod);
        }
        return path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = Strings.emptyToNull(name);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("url", this.uri).add("name", this.name).omitNullValues().toString();
    }

    public Link clone() throws CloneNotSupportedException {
        return (Link)super.clone();
    }
}

