/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Locale;

public class LatLongCoordinates {
    private final String latitude;
    private final String longitude;
    private final double latitudeDouble;
    private final double longitudeDouble;
    private static final double RADIUS_KM = 6371.0;

    private LatLongCoordinates(double latitude, double longitude) {
        Preconditions.checkArgument(latitude >= -90.0 && latitude <= 90.0, "Latitude not in [-90,90]", (Object)latitude);
        Preconditions.checkArgument(longitude >= -180.0 && longitude <= 180.0, "Longitude not in [-180,180]", (Object)longitude);
        this.latitude = String.format("%3.7f", latitude);
        this.longitude = String.format("%3.7f", longitude);
        this.latitudeDouble = LatLongCoordinates.flexibleParseDouble(this.latitude);
        this.longitudeDouble = LatLongCoordinates.flexibleParseDouble(this.longitude);
    }

    private LatLongCoordinates(String latitude, String longitude) {
        this(LatLongCoordinates.flexibleParseDouble(latitude), LatLongCoordinates.flexibleParseDouble(longitude));
    }

    public static LatLongCoordinates withLatAndLong(double latitude, double longitude) {
        return new LatLongCoordinates(latitude, longitude);
    }

    public static LatLongCoordinates withLatAndLong(String latitude, String longitude) {
        return new LatLongCoordinates(latitude, longitude);
    }

    public String latitude() {
        return this.latitude;
    }

    public String longitude() {
        return this.longitude;
    }

    public double longitudeAsDouble() {
        return this.longitudeDouble;
    }

    public double latitudeAsDouble() {
        return this.latitudeDouble;
    }

    public String latitudeAsCanonicalString() {
        return String.format(Locale.US, "%3.7f", this.latitudeDouble);
    }

    public String longitudeAsCanonicalString() {
        return String.format(Locale.US, "%3.7f", this.longitudeDouble);
    }

    public double kmDistance(LatLongCoordinates that) {
        double thisLatRadians = Math.toRadians(this.latitudeAsDouble());
        double thatLatRadians = Math.toRadians(that.latitudeAsDouble());
        double latDelta = thisLatRadians - thatLatRadians;
        double longDelta = Math.toRadians(this.longitudeAsDouble() - that.longitudeAsDouble());
        double sineHalfLatDelta = Math.sin(latDelta / 2.0);
        double sineHalfLongDelta = Math.sin(longDelta / 2.0);
        double a = sineHalfLatDelta * sineHalfLatDelta + Math.cos(thisLatRadians) * Math.cos(thatLatRadians) * sineHalfLongDelta * sineHalfLongDelta;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c * 6371.0;
    }

    public int hashCode() {
        return Objects.hashCode(this.latitude, this.longitude);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LatLongCoordinates)) {
            return false;
        }
        LatLongCoordinates that = (LatLongCoordinates)obj;
        return this.latitude.equals(that.latitude) && this.longitude.equals(that.longitude);
    }

    public String toString() {
        return String.format("[%s,%s]", this.latitude, this.longitude);
    }

    private static final double flexibleParseDouble(String string) {
        int index;
        boolean negative;
        int length = string.length();
        if (length == 0) {
            throw new NumberFormatException("Empty string");
        }
        if (string.charAt(0) == '-') {
            negative = true;
            index = 1;
        } else {
            negative = false;
            index = 0;
        }
        double accumulator = 0.0;
        while (index < length) {
            char next = string.charAt(index);
            if (next == ',' || next == '.') {
                ++index;
                double nextDecimal = 0.1;
                while (index < length) {
                    next = string.charAt(index);
                    if (next < '0' || next > '9') {
                        if (next == 'E') {
                            Integer exponent = Ints.tryParse(string.substring(index + 1));
                            if (exponent == null) {
                                throw new NumberFormatException("Not a valid double: " + string);
                            }
                            accumulator *= Math.pow(10.0, exponent.intValue());
                            index = length;
                            break;
                        }
                        throw new NumberFormatException("Not a valid double: " + string);
                    }
                    accumulator += nextDecimal * (double)(next - 48);
                    nextDecimal /= 10.0;
                    ++index;
                }
            } else {
                if (next < '0' || next > '9') {
                    throw new NumberFormatException("Not a valid double: " + string);
                }
                accumulator = accumulator * 10.0 + (double)(next - 48);
            }
            ++index;
        }
        return negative ? -accumulator : accumulator;
    }
}

