/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public final class Distance {
    private static final float KILOMETERS_IN_A_MILE = 1.60934f;
    private static final float MILES_IN_A_KILOMETER = 0.621371f;
    private final float distanceInKm;

    private Distance(float distanceInKm) {
        this.distanceInKm = distanceInKm;
    }

    public static final Distance inMiles(float distanceInMiles) {
        return new Distance(distanceInMiles * 1.60934f);
    }

    public static final Distance inKilometers(float distanceInKm) {
        return new Distance(distanceInKm);
    }

    public float miles() {
        return Distance.roundAtThreeDigits(this.distanceInKm * 0.621371f);
    }

    public float kilometers() {
        return Distance.roundAtThreeDigits(this.distanceInKm);
    }

    private static float roundAtThreeDigits(float f) {
        return (float)Math.round(f * 1000.0f) / 1000.0f;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.kilometers()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.kilometers()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Distance)) {
            return false;
        }
        Distance that = (Distance)obj;
        return this.kilometers() == that.kilometers();
    }
}

