/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class ClosestLocations {
    private final TreeMap<Double, String> locations = Maps.newTreeMap();
    private final LatLongCoordinates center;
    private static final Random random = new SecureRandom();

    public ClosestLocations(LatLongCoordinates center) {
        this.center = Preconditions.checkNotNull(center);
    }

    public ClosestLocations(LatLongCoordinates center, LocationSet locations) {
        this(center);
        for (Location root : locations.rootLocations()) {
            this.addLocation(root);
        }
    }

    public static Location nearestLocation(LatLongCoordinates center, LocationSet locations) {
        ClosestLocation bestLocation = new ClosestLocation();
        for (Location root : locations.rootLocations()) {
            bestLocation.testLocation(center, root);
        }
        return bestLocation.minimumLocaiton;
    }

    public Collection<Object> getNearestLocations(int maxCloseLocations, double maxCloseDistanceKm) {
        ListMultimap<Double, String> sortedEntries = Multimaps.newListMultimap(new TreeMap(), ArrayList::new);
        for (Map.Entry<Double, String> entry : this.locations.entrySet()) {
            if (entry.getKey() > maxCloseDistanceKm) break;
            sortedEntries.put(entry.getKey(), entry.getValue());
        }
        return sortedEntries.values().stream().limit(maxCloseLocations).collect(ImmutableList.toImmutableList());
    }

    public void addLocation(Location location) {
        double distance;
        String alreadyPresent;
        if (location.getLatLong().isPresent() && (alreadyPresent = this.locations.put(distance = this.center.kmDistance(location.getLatLong().get()), location.getId())) != null) {
            this.locations.put(distance += random.nextDouble() / 1000.0, alreadyPresent);
        }
        for (Location child : location.contents()) {
            this.addLocation(child);
        }
    }

    private static class ClosestLocation {
        double minimumDistance = Double.MAX_VALUE;
        Location minimumLocaiton = null;

        private ClosestLocation() {
        }

        void testLocation(LatLongCoordinates center, Location location) {
            double distance;
            if (location.getLatLong().isPresent() && (distance = center.kmDistance(location.getLatLong().get())) < this.minimumDistance) {
                this.minimumLocaiton = location;
            }
            for (Location child : location.contents()) {
                this.testLocation(center, child);
            }
        }
    }
}

