/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;

public final class Area {
    private static final float HECTARES_IN_AN_ACRE = 0.404686f;
    private static final float ACRES_IN_A_HECTARE = 2.47105f;
    private final float areaInHectares;

    private Area(float areaInHectares) {
        this.areaInHectares = areaInHectares;
    }

    public static final Area inAcres(float areaInAcres) {
        return new Area(areaInAcres * 0.404686f);
    }

    public static final Area inHectares(float areaInHectares) {
        return new Area(areaInHectares);
    }

    public float acres() {
        return Area.roundAtThreeDigits(this.areaInHectares * 2.47105f);
    }

    public float hectares() {
        return Area.roundAtThreeDigits(this.areaInHectares);
    }

    private static float roundAtThreeDigits(float f) {
        return (float)Math.round(f * 1000.0f) / 1000.0f;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.hectares()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(Float.valueOf(this.hectares()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Area)) {
            return false;
        }
        Area that = (Area)obj;
        return this.hectares() == that.hectares();
    }
}

