/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.sighting;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import com.google.common.primitives.Ints;
import java.text.NumberFormat;

public final class ApproximateNumber {
    private final int number;
    private final char approximateChar;

    private ApproximateNumber(int number, char approximateChar) {
        this.number = number;
        this.approximateChar = approximateChar;
    }

    public static ApproximateNumber tryParse(String string) {
        string = CharMatcher.whitespace().trimFrom(string);
        if (string.isEmpty()) {
            return null;
        }
        if (CharMatcher.inRange('0', '9').matches(string.charAt(0))) {
            Integer integer = Ints.tryParse(string);
            if (integer == null) {
                return null;
            }
            if (integer <= 0) {
                return null;
            }
            return new ApproximateNumber(integer, '\u0000');
        }
        Integer integer = Ints.tryParse(string.substring(1));
        if (integer == null) {
            return null;
        }
        if (integer <= 0) {
            return null;
        }
        if (string.charAt(0) == '-') {
            return null;
        }
        return new ApproximateNumber(integer, string.charAt(0));
    }

    public static ApproximateNumber exact(int value) {
        return new ApproximateNumber(value, '\u0000');
    }

    public int getNumber() {
        return this.number;
    }

    public boolean isExact() {
        return this.approximateChar == '\u0000';
    }

    public String toString() {
        if (this.approximateChar == '\u0000') {
            return "" + this.number;
        }
        return "" + this.approximateChar + this.number;
    }

    public String toFormattedString() {
        if (this.approximateChar == '\u0000') {
            return NumberFormat.getIntegerInstance().format(this.number);
        }
        return this.approximateChar + NumberFormat.getIntegerInstance().format(this.number);
    }

    public int hashCode() {
        return Objects.hashCode(Character.valueOf(this.approximateChar), this.number);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ApproximateNumber)) {
            return false;
        }
        ApproximateNumber that = (ApproximateNumber)obj;
        return this.approximateChar == that.approximateChar && this.number == that.number;
    }

    public ApproximateNumber plus(ApproximateNumber that) {
        if (this.isExact()) {
            if (that.isExact()) {
                return ApproximateNumber.exact(this.getNumber() + that.getNumber());
            }
            return new ApproximateNumber(this.getNumber() + that.getNumber(), that.approximateChar);
        }
        return new ApproximateNumber(this.getNumber() + that.getNumber(), this.approximateChar);
    }
}

