/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

class WesternPalearcticRegion
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(WesternPalearcticRegion.class.getName());
    private static final ImmutableSet<String> WESTERN_PALEARCTIC_BUT_NOT_EUROPE = ImmutableSet.of("TR", "AZ", "AM", "GE", "CY", "IL", new String[]{"PS", "JO", "LB", "KW", "SY", "IQ", "MA", "EH", "DZ", "TN", "LY", "EG", "ES-CN", "CV", "SJ", "FO", "ES-CEUMEL"});
    private Predicate<Sighting> predicate;
    private ImmutableSet<String> syntheticUnionCodes;

    public static WesternPalearcticRegion regionIfAvailable(LocationSet locationSet) {
        Location europe = WesternPalearcticRegion.getBuiltInLocation(locationSet, "Europe");
        if (europe == null) {
            logger.warning("No Western Palearctic list available: No Europe!");
            return null;
        }
        LinkedHashSet<String> syntheticUnionCodes = new LinkedHashSet<String>();
        syntheticUnionCodes.addAll(Checklists.gatherCountryChecklistCodes(europe));
        syntheticUnionCodes.addAll(WESTERN_PALEARCTIC_BUT_NOT_EUROPE);
        ArrayList<Location> list = Lists.newArrayList(europe);
        for (String code : WESTERN_PALEARCTIC_BUT_NOT_EUROPE) {
            Collection<Location> locations = locationSet.getLocationsByCode(code);
            if (locations.isEmpty()) {
                logger.warning("Could not find country code " + code);
                continue;
            }
            list.addAll(locations);
        }
        return new WesternPalearcticRegion(locationSet, list, ImmutableSet.copyOf(syntheticUnionCodes));
    }

    private WesternPalearcticRegion(LocationSet locationSet, Iterable<Location> locations, ImmutableSet<String> syntheticUnionCodes) {
        super("Western Palearctic", SyntheticLocation.Name.WESTERN_PALEARCTIC, "wepale");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            if (location == null) continue;
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
        this.syntheticUnionCodes = syntheticUnionCodes;
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return this.syntheticUnionCodes;
    }

    @Override
    public Collection<Location> syntheticChecklistUnionLocations(LocationSet locationSet, PredefinedLocations predefinedLocations) {
        Location europe = WesternPalearcticRegion.getBuiltInLocation(locationSet, "Europe");
        if (europe == null) {
            logger.warning("No Western Palearctic list available: No Europe!");
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(europe);
        locations.addAll(this.syntheticChecklistUnionLocations(locationSet, predefinedLocations, WESTERN_PALEARCTIC_BUT_NOT_EUROPE));
        return locations;
    }

    private static Location getBuiltInLocation(LocationSet locationSet, String name) {
        Collection<Location> locationsByName = locationSet.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

