/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

class UnitedStatesFiftyLocation
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(UnitedStatesFiftyLocation.class.getName());
    private Predicate<Sighting> predicate;

    public static UnitedStatesFiftyLocation regionIfAvailable(LocationSet locationSet) {
        Location northAmericanUsa = SyntheticLocations.getNorthAmericanUsa(locationSet);
        if (northAmericanUsa == null) {
            logger.warning("No United States in North America - no US 50 list available");
            return null;
        }
        Location hawaii = locationSet.getLocationByCode("US-HI");
        if (hawaii == null) {
            logger.warning("No Hawaii states - no US 50 list available");
            return null;
        }
        return new UnitedStatesFiftyLocation(locationSet, northAmericanUsa, hawaii);
    }

    private UnitedStatesFiftyLocation(LocationSet locationSet, Location ... locations) {
        super("United States - 50 states", SyntheticLocation.Name.UNITED_STATES_FIFTY, "us50");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return ImmutableSet.of("US", "US-HI", "UM-71");
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }
}

