/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class UnitedStatesAndDependentTerritoriesLocation
extends SyntheticLocation {
    private final Predicate<Sighting> predicate;
    private static final ImmutableSet<String> SYNTHETIC_CHECKLIST_UNION = ImmutableSet.of("US", "US-HI", "UM-71", "PR", "GU", "AS", new String[]{"VI", "MP"});

    public static UnitedStatesAndDependentTerritoriesLocation regionIfAvailable(LocationSet locationSet) {
        Location northernMarianaIslands;
        Location usVirginIslands;
        Location americanSamoa;
        Location guam;
        Location puertoRico;
        ArrayList<Location> locations = Lists.newArrayList();
        Collection<Location> unitedStatesLocations = locationSet.getLocationsByModelName("United States");
        for (Location unitedStates : unitedStatesLocations) {
            if (!"US".equals(unitedStates.getEbirdCode())) continue;
            locations.add(unitedStates);
        }
        Location minorIslands = locationSet.getLocationByCode("UM");
        if (minorIslands != null) {
            locations.add(minorIslands);
        }
        if ((puertoRico = locationSet.getLocationByCode("PR")) != null) {
            locations.add(puertoRico);
        }
        if ((guam = locationSet.getLocationByCode("GU")) != null) {
            locations.add(guam);
        }
        if ((americanSamoa = locationSet.getLocationByCode("AS")) != null) {
            locations.add(americanSamoa);
        }
        if ((usVirginIslands = locationSet.getLocationByCode("VI")) != null) {
            locations.add(usVirginIslands);
        }
        if ((northernMarianaIslands = locationSet.getLocationByCode("MP")) != null) {
            locations.add(northernMarianaIslands);
        }
        return new UnitedStatesAndDependentTerritoriesLocation(locationSet, locations);
    }

    private UnitedStatesAndDependentTerritoriesLocation(LocationSet locationSet, List<Location> locations) {
        super("United States (with dependent territories)", SyntheticLocation.Name.UNITED_STATES_AND_DEPENDENT_TERRITORIES, "uswidepterr");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return SYNTHETIC_CHECKLIST_UNION;
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }
}

