/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.query.AbaRegion;
import com.scythebill.birdlist.model.query.AbaRegionWithoutHawaii;
import com.scythebill.birdlist.model.query.AosSouth;
import com.scythebill.birdlist.model.query.AouRegion;
import com.scythebill.birdlist.model.query.ContiguousUnitedStates;
import com.scythebill.birdlist.model.query.GenericSyntheticLocation;
import com.scythebill.birdlist.model.query.KingdomOfTheNetherlands;
import com.scythebill.birdlist.model.query.PacificOceanAbaRegion;
import com.scythebill.birdlist.model.query.SouthernAfricaRegion;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.UnitedStatesAndDependentTerritoriesLocation;
import com.scythebill.birdlist.model.query.UnitedStatesFiftyLocation;
import com.scythebill.birdlist.model.query.WesternPalearcticRegion;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import java.util.Collection;
import java.util.Map;

public class SyntheticLocations {
    private final Map<String, SyntheticLocation> locations = Maps.newHashMap();

    public SyntheticLocations(LocationSet locationSet) {
        this.addIfAvailable(AbaRegion.regionIfAvailable(locationSet));
        this.addIfAvailable(AbaRegionWithoutHawaii.regionIfAvailable(locationSet));
        this.addIfAvailable(UnitedStatesFiftyLocation.regionIfAvailable(locationSet));
        this.addIfAvailable(ContiguousUnitedStates.regionIfAvailable(locationSet));
        this.addIfAvailable(AouRegion.regionIfAvailable(locationSet));
        this.addIfAvailable(AosSouth.regionIfAvailable(locationSet));
        this.addIfAvailable(WesternPalearcticRegion.regionIfAvailable(locationSet));
        this.addIfAvailable(SouthernAfricaRegion.regionIfAvailable(locationSet));
        this.addIfAvailable(UnitedStatesAndDependentTerritoriesLocation.regionIfAvailable(locationSet));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Australia (with dependent territories)", SyntheticLocation.Name.AUSTRALIA_WITH_DEPENDENT_TERRITORIES, "auwidepterr", "AU", "AC", "CS", "CC", "CX", "NF", "HM", "AU-TAS-Macquarie"));
        this.addIfAvailable(GenericSyntheticLocation.named(locationSet, "Australasia (ABA)", SyntheticLocation.Name.AUSTRALASIA_ABA).withAbbreviation("austaba").withRequiredLocations("AU", "PG").withOptionalLocations("AC", "CS").withRemovedLocations("PG-NSA").build());
        this.addIfAvailable(PacificOceanAbaRegion.regionIfAvailable(locationSet));
        this.addIfAvailable(GenericSyntheticLocation.named(locationSet, "Oriental Region", SyntheticLocation.Name.ORIENTAL_REGION).withAbbreviation("orireg").withLocations("ID-Asia", "MV", "IN", "LA", "PK", "HK", "BD", "BT", "BN", "KH", "CN", "CX", "TL", "JP", "LA", "MO", "MY", "MN", "MM", "NP", "KP", "SG", "KR", "LK", "TW", "TH", "VN", "PH").withOptionalLocations("ID-MA", "RU-KYA", "RU-TY", "RU-IRK", "RU-BU", "RU-CHI", "RU-AGB", "RU-ORB", "RU-KAM", "RU-AMU", "RU-YEV", "RU-PRI", "RU-SAK", "RU-KHA", "RU-MAG", "RU-SA", "RU-CHU").withSyntheticChecklistUnion("ID-Asia", "MV", "IN", "LA", "PK", "HK", "BD", "BT", "BN", "KH", "CN", "CX", "TL", "JP", "LA", "MO", "MY", "MN", "MM", "NP", "KP", "SG", "KR", "LK", "TW", "TH", "VN", "PH", "ID-MA", "RU-Asia").build());
        this.addIfAvailable(GenericSyntheticLocation.named(locationSet, "Chile (with offshore islands)", SyntheticLocation.Name.CHILE_WITH_OFFSHORE_ISLANDS).withAbbreviation("clwidepterr").withRequiredLocations("CL").withOptionalLocations("CL-VS-Easter", "CL-VS-JuanFernandez").withSyntheticChecklistUnionFromAllLocations().build());
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Colombia (with Caribbean islands)", SyntheticLocation.Name.COLOMBIA_WITH_CARIBBEAN_ISLANDS, "cowidepterr", "CO", "CO-SAP"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Ecuador (with Galapagos)", SyntheticLocation.Name.ECUADOR_WITH_GALAPAGOS, "ecwidepterr", "EC", "EC-W"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Portugal (with Azores and Madeira)", SyntheticLocation.Name.PORTUGAL_WITH_AZORES_AND_MADEIRA, "ptwidepterr", "PT", "PT-20", "PT-30"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Spain (with Canary Islands, Ceuta, and Melilla)", SyntheticLocation.Name.SPAIN_WTH_CANARY_ISLANDS_ETC, "eswidepterr", "ES", "ES-CEUMEL", "ES-CN"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "New Zealand (with Tokelau)", SyntheticLocation.Name.NEW_ZEALAND_WITH_TOKELAU, "nzwidepterr", "NZ", "TK"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Norway (with Bouvet Island and Svalbard)", SyntheticLocation.Name.NORWAY_WITH_BOUVET_AND_SVALBARD, "nowidepterr", "NO", "BV", "SJ"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "United Kingdom (with dependent territories)", SyntheticLocation.Name.UNITED_KINGDOM_WITH_DEPENDENT_TERRITORIES, "gbwidepterr", "GB", "AI", "BM", "IO", "VG", "KY", "FK", "GI", "MS", "PN", "SH", "TC", "GS"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "China (with administrative regions)", SyntheticLocation.Name.CHINA_WITH_ADMINISTRATIVE_REGIONS, "cnwidepterr", "CN", "HK", "MO"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Kingdom of Denmark", SyntheticLocation.Name.KINGDOM_OF_DENMARK, "dkwidepterr", "DK", "FO", "GL"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "South Africa (with Prince Edward and Marion Islands)", SyntheticLocation.Name.SOUTH_AFRICA_WITH_ISLANDS, "zawidepterr", "ZA", "ZA-WC-EdwardMarion"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "France (with Overseas Territories)", SyntheticLocation.Name.FRANCE_WITH_OVERSEA_TERRITORIES, "frwidepterr", "FR", "BL", "MF", "PM", "WF", "PF", "NC", "CP", "TF", "RE", "GP", "GF", "YT", "MQ"));
        this.addIfAvailable(GenericSyntheticLocation.regionIfAvailable(locationSet, "Ireland (Island of)", SyntheticLocation.Name.IRELAND_ISLAND_OF, "ireislof", "IE", "GB-NIR"));
        this.addIfAvailable(GenericSyntheticLocation.named(locationSet, "Hawaii (with Northwestern Islands)", SyntheticLocation.Name.HAWAII_WITH_NORTHERWESTERN_ISLANDS).withAbbreviation("ushiwinowiis").withRequiredLocations("US-HI").withOptionalLocations("UM-71").withSyntheticChecklistUnionFromAllLocations().build());
        this.addIfAvailable(KingdomOfTheNetherlands.regionIfAvailable(locationSet));
    }

    private void addIfAvailable(SyntheticLocation location) {
        if (location != null) {
            this.locations.put(location.getId(), location);
        }
    }

    public Iterable<SyntheticLocation> locations() {
        return this.locations.values();
    }

    public SyntheticLocation byId(String id) {
        return this.locations.get(id);
    }

    static Location getNorthAmericanUsa(LocationSet locationSet) {
        Location northAmerica = Locations.getBuiltInLocationByModelName(locationSet, "North America");
        if (northAmerica == null) {
            return null;
        }
        Location westIndies = Locations.getBuiltInLocationByModelName(locationSet, "West Indies");
        Collection<Location> locationsByName = locationSet.getLocationsByModelName("United States");
        for (Location location : locationsByName) {
            if (westIndies != null && Locations.isDescendentOfLocation(westIndies, location) || !Locations.isDescendentOfLocation(northAmerica, location)) continue;
            return location;
        }
        return null;
    }
}

