/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;

public abstract class SyntheticLocation
extends Location {
    private final String id;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("com.scythebill.birdlist.model.sighting.locations");
    private Name bundleName;

    protected SyntheticLocation(String name, Name bundleName, String id) {
        super(Location.Type.region, name);
        this.bundleName = bundleName;
        this.id = String.format("***%s***", id);
    }

    public static boolean isSyntheticLocation(String id) {
        return id.startsWith("***") && id.endsWith("***");
    }

    public abstract Predicate<Sighting> isInPredicate();

    @Override
    public String getDisplayName() {
        return this.bundleName.toString();
    }

    public Collection<String> syntheticChecklistUnion() {
        return null;
    }

    public Collection<Location> syntheticChecklistUnionLocations(LocationSet locationSet, PredefinedLocations predefinedLocations) {
        Collection<String> checklistUnion = this.syntheticChecklistUnion();
        if (checklistUnion == null) {
            return null;
        }
        return this.syntheticChecklistUnionLocations(locationSet, predefinedLocations, checklistUnion);
    }

    protected Collection<Location> syntheticChecklistUnionLocations(LocationSet locationSet, PredefinedLocations predefinedLocations, Collection<String> checklistUnion) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (String checklistId : checklistUnion) {
            Location checklistLocation = Checklists.getLocation(locationSet, predefinedLocations, checklistId);
            if (checklistLocation == null) continue;
            locations.add(checklistLocation);
        }
        return locations;
    }

    @Override
    public Collection<Location> contents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Location getContent(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getEbirdCode() {
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Location getParent() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isIn(Location ancestor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reparent(Location newIn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBuiltInLocation() {
        return true;
    }

    @Override
    public Optional<LatLongCoordinates> getLatLong() {
        return Optional.absent();
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    static enum Name {
        ABA_REGION,
        ABA_REGION_WITHOUT_HAWAII,
        UNITED_STATES_FIFTY,
        CONTIGUOUS_UNITED_STATES,
        AOU_NORTH,
        AOU_SOUTH,
        WESTERN_PALEARCTIC,
        SOUTHERN_AFRICA,
        UNITED_STATES_AND_DEPENDENT_TERRITORIES,
        AUSTRALIA_WITH_DEPENDENT_TERRITORIES,
        AUSTRALASIA_ABA,
        PACIFIC_OCEAN_ABA,
        ORIENTAL_REGION,
        CHILE_WITH_OFFSHORE_ISLANDS,
        COLOMBIA_WITH_CARIBBEAN_ISLANDS,
        ECUADOR_WITH_GALAPAGOS,
        PORTUGAL_WITH_AZORES_AND_MADEIRA,
        SPAIN_WTH_CANARY_ISLANDS_ETC,
        NEW_ZEALAND_WITH_TOKELAU,
        NORWAY_WITH_BOUVET_AND_SVALBARD,
        UNITED_KINGDOM_WITH_DEPENDENT_TERRITORIES,
        CHINA_WITH_ADMINISTRATIVE_REGIONS,
        KINGDOM_OF_DENMARK,
        SOUTH_AFRICA_WITH_ISLANDS,
        FRANCE_WITH_OVERSEA_TERRITORIES,
        IRELAND_ISLAND_OF,
        HAWAII_WITH_NORTHERWESTERN_ISLANDS,
        KINGDOM_OF_THE_NETHERLANDS;


        public String toString() {
            return BUNDLE.getString(this.name());
        }
    }
}

