/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

class SouthernAfricaRegion
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(SouthernAfricaRegion.class.getName());
    private static final ImmutableSet<String> SOUTHERN_AFRICAN_IDS = ImmutableSet.of("ZA", "ZW", "BW", "NA", "SZ", "LS", new String[]{"MZ-L", "MZ-G", "MZ-I", "MZ-B", "MZ-S", "MZ-T"});
    private Predicate<Sighting> predicate;

    public static SouthernAfricaRegion regionIfAvailable(LocationSet locationSet) {
        ArrayList<Location> list = Lists.newArrayList();
        for (String code : SOUTHERN_AFRICAN_IDS) {
            Location location = locationSet.getLocationByCode(code);
            if (location == null && !code.contains("-")) {
                logger.warning("Could not find country code " + code);
                continue;
            }
            list.add(location);
        }
        return new SouthernAfricaRegion(locationSet, list);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return SOUTHERN_AFRICAN_IDS;
    }

    private SouthernAfricaRegion(LocationSet locationSet, Iterable<Location> locations) {
        super("Southern Africa", SyntheticLocation.Name.SOUTHERN_AFRICA, "sounafr");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            if (location == null) continue;
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }
}

