/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.query.PartialPredicates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.Trips;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;

public class SightingPredicates {
    private SightingPredicates() {
    }

    public static Predicate<Sighting> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<Sighting> isHeardOnly() {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return input.hasSightingInfo() && input.getSightingInfo().isHeardOnly();
            }

            public String toString() {
                return "IsHeardOnly[]";
            }
        };
    }

    public static Predicate<Sighting> isPhotographed() {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return input.hasSightingInfo() && input.getSightingInfo().isPhotographed();
            }

            public String toString() {
                return "isPhotographed[]";
            }
        };
    }

    public static Predicate<Sighting> in(final Location queryLoc, LocationSet locations) {
        Preconditions.checkNotNull(queryLoc);
        final HashSet allLocationIds = new HashSet();
        Locations.visitLocations(queryLoc, l -> allLocationIds.add(l.getId()));
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                return allLocationIds.contains(sighting.getLocationId());
            }

            public String toString() {
                return "LocationIsIn[" + queryLoc.getModelName() + "]";
            }
        };
    }

    public static Predicate<Sighting> afterOrEquals(final ReadablePartial after) {
        final Predicate<ReadablePartial> datePartial = PartialPredicates.afterOrEquals(after);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                ReadablePartial date = sighting.getStartDateAsPartial();
                if (date == null) {
                    return false;
                }
                return datePartial.apply(date);
            }

            public String toString() {
                return "AfterOrEquals[" + after + "]";
            }
        };
    }

    public static Predicate<Sighting> after(final ReadablePartial after) {
        final Predicate<ReadablePartial> datePartial = PartialPredicates.after(after);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                ReadablePartial date = sighting.getStartDateAsPartial();
                if (date == null) {
                    return false;
                }
                return datePartial.apply(date);
            }

            public String toString() {
                return "After[" + after + "]";
            }
        };
    }

    public static Predicate<Sighting> dateIsExactly(final ReadablePartial exactly) {
        final Predicate<ReadablePartial> datePartial = PartialPredicates.dateIsExactly(exactly);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                ReadablePartial date = sighting.getSingleDateAsPartial();
                if (date == null) {
                    return false;
                }
                return datePartial.apply(date);
            }

            public String toString() {
                return "DateIsExactly[" + exactly + "]";
            }
        };
    }

    public static Predicate<Sighting> timeIsExactly(final ReadablePartial exactly) {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                LocalTime time = sighting.getStoredTimeAsPartial();
                if (time == null) {
                    return false;
                }
                return time.equals(exactly);
            }

            public String toString() {
                return "TimeIsExactly[" + exactly + "]";
            }
        };
    }

    public static Predicate<Sighting> beforeOrEquals(final ReadablePartial partial) {
        final Predicate<ReadablePartial> datePartial = PartialPredicates.beforeOrEquals(partial);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                ReadablePartial date = sighting.getEndDateAsPartial();
                if (date == null) {
                    return false;
                }
                return datePartial.apply(date);
            }

            public String toString() {
                return "BeforeOrEquals[" + partial + "]";
            }
        };
    }

    public static Predicate<Sighting> before(final ReadablePartial partial) {
        final Predicate<ReadablePartial> datePartial = PartialPredicates.before(partial);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting sighting) {
                ReadablePartial date = sighting.getEndDateAsPartial();
                if (date == null) {
                    return false;
                }
                return datePartial.apply(date);
            }

            public String toString() {
                return "Before[" + partial + "]";
            }
        };
    }

    public static Predicate<Sighting> sightingStatusIsIn(final Collection<SightingInfo.SightingStatus> allowedStatuses) {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return allowedStatuses.contains((Object)input.getSightingInfo().getSightingStatus());
            }

            public String toString() {
                return "StatusIsIn[" + allowedStatuses + "]";
            }
        };
    }

    public static Predicate<Sighting> is(final Location location, LocationSet locationSet) {
        Preconditions.checkNotNull(location);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return location.getId().equals(input.getLocationId());
            }

            public String toString() {
                return "LocationIs[" + location.getModelName() + "]";
            }
        };
    }

    public static Predicate<Sighting> compatibleWith(Taxonomy compatibleTaxonomy) {
        final Taxonomy baseTaxonomy = TaxonUtils.getBaseTaxonomy(compatibleTaxonomy);
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return input.getTaxonomy() == baseTaxonomy;
            }

            public String toString() {
                return "CompatibleWith[" + baseTaxonomy.getName() + "]";
            }
        };
    }

    public static Predicate<Sighting> includesUser(final User user) {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                return input.hasSightingInfo() && input.getSightingInfo().getUsers().contains(user);
            }

            public String toString() {
                return "IncludesUser[" + user + "]";
            }
        };
    }

    public static Predicate<Sighting> includesAnyOfUsers(final ImmutableSet<User> users) {
        return new Predicate<Sighting>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean apply(Sighting input) {
                if (!input.hasSightingInfo()) return false;
                if (!input.getSightingInfo().getUsers().stream().anyMatch(users::contains)) return false;
                return true;
            }

            public String toString() {
                return "IncludesAnyOfUsers[" + users + "]";
            }
        };
    }

    public static Predicate<Sighting> usersAreExactly(final ImmutableSet<User> userSet) {
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                ImmutableSet<Object> sightingUsers = input.hasSightingInfo() ? input.getSightingInfo().getUsers() : ImmutableSet.of();
                return sightingUsers.equals(userSet);
            }

            public String toString() {
                return "UsersAreExactly[" + userSet + "]";
            }
        };
    }

    public static Predicate<Sighting> isPartOfTrip(final Trip trip, LocationSet locationSet) {
        final Predicate<Sighting> datePredicate = Predicates.and(SightingPredicates.afterOrEquals(trip.startDate()), SightingPredicates.beforeOrEquals(trip.endDate()));
        if (trip.locationId() == null) {
            return datePredicate;
        }
        Location tripLocation = locationSet.getLocation(trip.locationId());
        final HashSet allLocationIds = new HashSet();
        Locations.visitLocations(tripLocation, l -> allLocationIds.add(l.getId()));
        return new Predicate<Sighting>(){

            @Override
            public boolean apply(Sighting input) {
                if (input.getTrip() == trip) {
                    return true;
                }
                if (!allLocationIds.contains(input.getLocationId())) {
                    return false;
                }
                return datePredicate.apply(input);
            }

            public String toString() {
                return "IsPartOfTrip[" + Trips.nameWithDate(trip, Locale.getDefault()) + "]";
            }
        };
    }
}

