/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.util.ResolvedComparator;
import org.joda.time.Chronology;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;

public class SightingComparators {
    private static final ImmutableMap<SightingInfo.SightingStatus, Integer> SIGHTING_STATUS_VALUES;

    private SightingComparators() {
    }

    public static Ordering<Sighting> preferNotHeardOnly() {
        return new HeardOnlyComparator();
    }

    public static Ordering<Sighting> preferMoreRecent() {
        return new MoreRecentComparator();
    }

    public static Ordering<Sighting> preferEarlier() {
        return new MoreRecentComparator().reverse();
    }

    public static Ordering<Sighting> preferEarlierInTheYear() {
        return new LaterInTheYearComparator().reverse();
    }

    public static Ordering<Sighting> preferNotIntroduced() {
        return new PreferNotIntroducedComparator();
    }

    public static Ordering<Sighting> preferHigherCounts() {
        return new HigherCountComparator();
    }

    public static Ordering<Sighting> inTaxonomicOrder(Taxonomy taxonomy) {
        return new TaxonomicOrdering(taxonomy);
    }

    public static int comparePartials(ReadablePartial a, ReadablePartial b) {
        Chronology chrono = a.getChronology();
        int aSize = a.size();
        int bSize = b.size();
        for (int i = 0; i < aSize && i < bSize; ++i) {
            int bValue;
            DateTimeFieldType bFieldType;
            DateTimeFieldType aFieldType = a.getFieldType(i);
            if (aFieldType != (bFieldType = b.getFieldType(i))) {
                return aFieldType.getDurationType().getField(chrono).compareTo(bFieldType.getDurationType().getField(chrono));
            }
            int aValue = a.getValue(i);
            if (aValue == (bValue = b.getValue(i))) continue;
            return aValue - bValue;
        }
        return aSize - bSize;
    }

    static {
        ImmutableMap.Builder<SightingInfo.SightingStatus, Integer> builder = ImmutableMap.builder();
        builder.put(SightingInfo.SightingStatus.NONE, 0);
        builder.put(SightingInfo.SightingStatus.RECORD_NOT_ACCEPTED, 1);
        builder.put(SightingInfo.SightingStatus.INTRODUCED, 2);
        builder.put(SightingInfo.SightingStatus.BETTER_VIEW_DESIRED, 3);
        builder.put(SightingInfo.SightingStatus.INTRODUCED_NOT_ESTABLISHED, 4);
        builder.put(SightingInfo.SightingStatus.RESTRAINED, 5);
        builder.put(SightingInfo.SightingStatus.UNSATISFACTORY_VIEWS, 6);
        builder.put(SightingInfo.SightingStatus.ID_UNCERTAIN, 7);
        builder.put(SightingInfo.SightingStatus.SIGNS, 8);
        builder.put(SightingInfo.SightingStatus.DEAD, 9);
        builder.put(SightingInfo.SightingStatus.NOT_BY_ME, 10);
        builder.put(SightingInfo.SightingStatus.DOMESTIC, 11);
        SIGHTING_STATUS_VALUES = builder.build();
    }

    private static final class HeardOnlyComparator
    extends Ordering<Sighting> {
        private HeardOnlyComparator() {
        }

        @Override
        public int compare(Sighting a, Sighting b) {
            int aValue = a.getSightingInfo().isHeardOnly() ? 1 : 0;
            int bValue = b.getSightingInfo().isHeardOnly() ? 1 : 0;
            return bValue - aValue;
        }
    }

    private static final class MoreRecentComparator
    extends Ordering<Sighting> {
        private MoreRecentComparator() {
        }

        @Override
        public int compare(Sighting a, Sighting b) {
            ReadablePartial aDate = a.getStartDateAsPartial();
            ReadablePartial bDate = b.getStartDateAsPartial();
            if (aDate == null) {
                return bDate == null ? 0 : -1;
            }
            if (bDate == null) {
                return 1;
            }
            int compared = SightingComparators.comparePartials(aDate, bDate);
            if (compared != 0) {
                return compared;
            }
            LocalTime aTime = a.getStoredTimeAsPartial();
            LocalTime bTime = b.getStoredTimeAsPartial();
            if (aTime == null) {
                return bTime == null ? 0 : -1;
            }
            if (bTime == null) {
                return 1;
            }
            return SightingComparators.comparePartials(aTime, bTime);
        }
    }

    private static final class LaterInTheYearComparator
    extends Ordering<Sighting> {
        private LaterInTheYearComparator() {
        }

        @Override
        public int compare(Sighting a, Sighting b) {
            int compared;
            ReadablePartial aDate = a.getEndDateAsPartial();
            ReadablePartial bDate = b.getEndDateAsPartial();
            if (aDate == null) {
                return bDate == null ? 0 : -1;
            }
            if (bDate == null) {
                return 1;
            }
            if (aDate.isSupported(DateTimeFieldType.year())) {
                aDate = new Partial(aDate).with(DateTimeFieldType.year(), 1988);
            }
            if (bDate.isSupported(DateTimeFieldType.year())) {
                bDate = new Partial(bDate).with(DateTimeFieldType.year(), 1988);
            }
            if ((compared = SightingComparators.comparePartials(aDate, bDate)) != 0) {
                return compared;
            }
            LocalTime aTime = a.getStoredTimeAsPartial();
            LocalTime bTime = b.getStoredTimeAsPartial();
            if (aTime == null) {
                return bTime == null ? 0 : -1;
            }
            if (bTime == null) {
                return 1;
            }
            return SightingComparators.comparePartials(aTime, bTime);
        }
    }

    private static final class PreferNotIntroducedComparator
    extends Ordering<Sighting> {
        private PreferNotIntroducedComparator() {
        }

        @Override
        public int compare(Sighting a, Sighting b) {
            SightingInfo.SightingStatus aStatus = a.getSightingInfo().getSightingStatus();
            SightingInfo.SightingStatus bStatus = b.getSightingInfo().getSightingStatus();
            return SIGHTING_STATUS_VALUES.get((Object)bStatus) - SIGHTING_STATUS_VALUES.get((Object)aStatus);
        }
    }

    private static final class HigherCountComparator
    extends Ordering<Sighting> {
        private HigherCountComparator() {
        }

        @Override
        public int compare(Sighting a, Sighting b) {
            int aCount = a.hasSightingInfo() && a.getSightingInfo().getNumber() != null ? a.getSightingInfo().getNumber().getNumber() : 0;
            int bCount = b.hasSightingInfo() && b.getSightingInfo().getNumber() != null ? b.getSightingInfo().getNumber().getNumber() : 0;
            return aCount - bCount;
        }
    }

    private static class TaxonomicOrdering
    extends Ordering<Sighting> {
        private final Taxonomy taxonomy;
        private final ResolvedComparator resolvedComparator = new ResolvedComparator();

        TaxonomicOrdering(Taxonomy taxonomy) {
            this.taxonomy = taxonomy;
        }

        @Override
        public int compare(Sighting left, Sighting right) {
            SightingTaxon.Resolved leftResolved = left.getTaxon().resolve(this.taxonomy);
            SightingTaxon.Resolved rightResolved = right.getTaxon().resolve(this.taxonomy);
            return this.resolvedComparator.compare(rightResolved, leftResolved);
        }
    }
}

