/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.sighting.VisitInfoKeyOrdering;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;

public class QueryResults {
    private final List<Listener> listeners = Lists.newCopyOnWriteArrayList();
    private final Taxonomy taxonomy;
    private final Checklist checklist;
    private final ImmutableMap<Taxonomy, Checklist> incompatibleTaxonomyChecklists;
    private final Multimap<String, Sighting> sightings;
    private final boolean keepInvalidSightingsAfterUpdate;
    private final boolean includeFamilyNames;
    private final boolean includeAllChecklistSpecies;
    private final Taxon.Type smallestType;
    private final Predicate<Sighting> countable;
    private final QueryDefinition queryDefinition;
    private final Predicate<SightingTaxon.Resolved> taxonFilter;
    private final Map<Sighting, QueryDefinition.QueryAnnotation> annotations;
    private final Map<QueryDefinition.QueryAnnotation, Set<Sighting>> sightingsWithAnnotation = Maps.newHashMap();
    private final Map<QueryDefinition.QueryAnnotation, Set<SightingTaxon.Resolved>> taxaWithAnnotation = Maps.newHashMap();
    private Set<String> countableSightingTaxa;
    private Set<SightingTaxon> countableNonSingleSightingTaxa;
    private List<SightingTaxon.Resolved> taxaAsList;
    private Set<String> speciesIds;
    private List<SightingTaxon.Resolved> countableTaxaAsList;
    private Multimap<SightingTaxon, Sighting> nonSingleSightings;
    private boolean queryInvalid;
    private ImmutableSet<Checklist.Status> ignoredStatus;
    private final Set<VisitInfoKey> incompatibleVisitInfos;
    private final Map<Taxonomy, Multimap<String, Sighting>> incompatibleSightings;
    private final Map<Taxonomy, Multimap<SightingTaxon, Sighting>> incompatibleNonSingleSightings;

    QueryResults(Taxonomy taxonomy, @Nullable Checklist checklist, @Nullable Map<Taxonomy, Checklist> incompatibleTaxonomyChecklists, QueryDefinition queryDefinition, Builder builder, Taxon.Type smallestType, @Nullable Predicate<Sighting> countable) {
        this.taxonomy = taxonomy;
        this.checklist = checklist;
        this.incompatibleTaxonomyChecklists = incompatibleTaxonomyChecklists == null ? ImmutableMap.of() : ImmutableMap.copyOf(incompatibleTaxonomyChecklists);
        this.queryDefinition = Preconditions.checkNotNull(queryDefinition);
        this.taxonFilter = Preconditions.checkNotNull(builder.taxonFilter);
        this.countable = countable;
        this.sightings = builder.sightings;
        this.nonSingleSightings = builder.nonSingleSightings;
        this.smallestType = smallestType;
        this.annotations = builder.annotations;
        this.keepInvalidSightingsAfterUpdate = builder.keepInvalidSightingsAfterUpdate;
        this.includeFamilyNames = !builder.dontIncludeFamilyNames;
        this.includeAllChecklistSpecies = builder.includeAllChecklistSpecies;
        this.ignoredStatus = builder.ignoredStatus;
        this.incompatibleVisitInfos = Collections.unmodifiableSet(builder.incompatibleVisitInfos);
        this.incompatibleSightings = builder.incompatibleSightings;
        this.incompatibleNonSingleSightings = builder.incompatibleNonSingleSightings;
        this.precomputeResults(true);
    }

    private void precomputeResults(boolean updateTaxa) {
        this.countableSightingTaxa = this.getCountablePredicate() == null ? this.sightings.keySet() : ImmutableSet.copyOf(Multimaps.filterValues(this.sightings, this.getCountablePredicate()).keySet());
        Set<SightingTaxon> set = this.countableNonSingleSightingTaxa = this.getCountablePredicate() == null ? this.nonSingleSightings.keySet() : ImmutableSet.copyOf(Multimaps.filterValues(this.nonSingleSightings, this.getCountablePredicate()).keySet());
        if (updateTaxa) {
            this.taxaAsList = this.getResolvedTaxa(this.taxonomy, this.sightings.keySet(), this.nonSingleSightings.keySet(), this.includeFamilyNames, this.includeAllChecklistSpecies);
            this.countableTaxaAsList = this.getCountablePredicate() == null ? this.taxaAsList : this.getResolvedTaxa(this.taxonomy, this.countableSightingTaxa, this.countableNonSingleSightingTaxa, this.includeFamilyNames, this.includeAllChecklistSpecies);
        }
        this.speciesIds = null;
    }

    public Taxonomy getTaxonomy() {
        return this.taxonomy;
    }

    public Taxon.Type getSmallestType() {
        return this.smallestType;
    }

    public int getCountableSpeciesSize(Taxonomy taxonomy, boolean includeNonSingle) {
        Set<String> countableSpeciesIds = this.getCountableSpeciesIds(taxonomy);
        if (!includeNonSingle) {
            return countableSpeciesIds.size();
        }
        int nonSingleCount = this.countNonSingleTaxa(taxonomy, countableSpeciesIds, Taxon.Type.species);
        return countableSpeciesIds.size() + nonSingleCount;
    }

    public Set<String> getCountableSpeciesIds(Taxonomy taxonomy) {
        if (taxonomy == this.getTaxonomy()) {
            if (this.speciesIds == null) {
                if (this.smallestType == Taxon.Type.species) {
                    this.speciesIds = this.countableSightingTaxa;
                    HashSet<String> nonSingleButSpecies = Sets.newHashSet();
                    for (SightingTaxon taxon : this.countableNonSingleSightingTaxa) {
                        SightingTaxon species;
                        SightingTaxon.Resolved resolved = taxon.resolveInternal(taxonomy);
                        if (resolved.getSmallestTaxonType() == Taxon.Type.species || (species = resolved.getParentOfAtLeastType(Taxon.Type.species)).getType() != SightingTaxon.Type.SINGLE || this.speciesIds.contains(species.getId())) continue;
                        nonSingleButSpecies.add(species.getId());
                    }
                    if (!nonSingleButSpecies.isEmpty()) {
                        this.speciesIds = Sets.union(nonSingleButSpecies, this.speciesIds);
                    }
                } else {
                    List<SightingTaxon.Resolved> taxa = this.countableTaxaAsList;
                    this.speciesIds = TaxonUtils.getTaxaAtLevel(taxa, Taxon.Type.species);
                }
            }
            return Collections.unmodifiableSet(this.speciesIds);
        }
        LinkedHashSet<String> incompatibleSpeciesIds = new LinkedHashSet<String>();
        for (SightingTaxon.Resolved resolved : this.getCountableTaxaAsList(taxonomy, false)) {
            SightingTaxon species;
            if (resolved.getLargestTaxonType() == Taxon.Type.family || (species = resolved.getParentOfAtLeastType(Taxon.Type.species)).getType() != SightingTaxon.Type.SINGLE) continue;
            incompatibleSpeciesIds.add(species.getId());
        }
        return incompatibleSpeciesIds;
    }

    public int getCountableGroupsAndSpeciesSize(Taxonomy taxonomy, boolean includeNonSingle) {
        Set<String> countableGroupsIds = this.getCountableGroupsAndSpeciesIds(taxonomy);
        if (!includeNonSingle) {
            return countableGroupsIds.size();
        }
        int nonSingleCount = this.countNonSingleTaxa(taxonomy, countableGroupsIds, Taxon.Type.group);
        return countableGroupsIds.size() + nonSingleCount;
    }

    public boolean hasAnnotation(QueryDefinition.QueryAnnotation annotation) {
        Set<SightingTaxon.Resolved> taxa = this.taxaWithAnnotation.get((Object)annotation);
        return taxa != null && !taxa.isEmpty();
    }

    public Set<Sighting> getSightingsWithAnnotation(QueryDefinition.QueryAnnotation annotation) {
        if (!this.sightingsWithAnnotation.containsKey((Object)annotation)) {
            Set<Sighting> filtered = Maps.filterValues(this.annotations, Predicates.equalTo(annotation)).keySet();
            this.sightingsWithAnnotation.put(annotation, filtered);
        }
        return this.sightingsWithAnnotation.get((Object)annotation);
    }

    public Set<SightingTaxon.Resolved> getTaxaWithAnnotation(Taxonomy taxonomy, QueryDefinition.QueryAnnotation annotation) {
        if (taxonomy == this.getTaxonomy() && this.taxaWithAnnotation.containsKey((Object)annotation)) {
            return this.taxaWithAnnotation.get((Object)annotation);
        }
        HashSet<SightingTaxon.Resolved> taxa = Sets.newHashSet();
        for (Sighting sighting : this.getSightingsWithAnnotation(annotation)) {
            if (!TaxonUtils.areCompatible(taxonomy, sighting.getTaxonomy())) continue;
            SightingTaxon taxon = sighting.getTaxon();
            SightingTaxon.Resolved resolved = taxon.resolve(taxonomy);
            taxa.add(resolved);
            while (resolved.getLargestTaxonType() != Taxon.Type.species) {
                resolved = resolved.getParent().resolveInternal(taxonomy);
                taxa.add(resolved);
            }
        }
        if (taxonomy == this.getTaxonomy()) {
            this.taxaWithAnnotation.put(annotation, taxa);
        }
        return taxa;
    }

    public Set<SightingTaxon.Resolved> getTaxaWithAnnotation(Taxonomy taxonomy, QueryDefinition.QueryAnnotation annotation, Taxon.Type type) {
        HashSet<SightingTaxon.Resolved> taxa = Sets.newHashSet();
        for (Sighting sighting : this.getSightingsWithAnnotation(annotation)) {
            SightingTaxon.Resolved resolved;
            SightingTaxon parentOfAtLeastType;
            Optional<QueryDefinition.QueryAnnotation> annotatedAtType;
            if (!TaxonUtils.areCompatible(taxonomy, sighting.getTaxonomy()) || !(annotatedAtType = this.queryDefinition.annotate(sighting, parentOfAtLeastType = (resolved = sighting.getTaxon().resolve(taxonomy)).getParentOfAtLeastType(type))).isPresent() || annotation != annotatedAtType.get()) continue;
            resolved = parentOfAtLeastType.resolveInternal(taxonomy);
            taxa.add(resolved);
        }
        return taxa;
    }

    Set<String> getCountableGroupsAndSpeciesIds(Taxonomy taxonomy) {
        List<SightingTaxon.Resolved> taxa = this.getCountableTaxaAsList(taxonomy, this.includeAllChecklistSpecies);
        Set<String> groupSet = TaxonUtils.getTaxaAtLevel(taxa, Taxon.Type.group);
        for (SightingTaxon.Resolved taxon : taxa) {
            Taxon speciesTaxon;
            SightingTaxon species;
            if (taxon.getType() == SightingTaxon.Type.SINGLE) {
                Taxon speciesTaxon2;
                if (taxon.getSmallestTaxonType() != Taxon.Type.species && taxon.getSmallestTaxonType() != Taxon.Type.subspecies || TaxonUtils.isItselfOrAChildIn(speciesTaxon2 = TaxonUtils.getParentOfType(taxon.getTaxon(), Taxon.Type.species), groupSet)) continue;
                groupSet.add(speciesTaxon2.getId());
                continue;
            }
            if (taxon.getSmallestTaxonType() == Taxon.Type.species || (species = taxon.getParentOfAtLeastType(Taxon.Type.species)).getType() != SightingTaxon.Type.SINGLE || TaxonUtils.isItselfOrAChildIn(speciesTaxon = taxonomy.getTaxon(species.getId()), groupSet)) continue;
            groupSet.add(species.getId());
        }
        return Collections.unmodifiableSet(groupSet);
    }

    Set<String> getCountableSubspeciesGroupsAndSpeciesIds(Taxonomy taxonomy) {
        List<SightingTaxon.Resolved> taxa = this.getCountableTaxaAsList(taxonomy, this.includeAllChecklistSpecies);
        Set<String> subspeciesSet = TaxonUtils.getTaxaAtLevel(taxa, Taxon.Type.subspecies);
        for (SightingTaxon.Resolved taxon : taxa) {
            if (taxon.getType() != SightingTaxon.Type.SINGLE || taxon.getSmallestTaxonType() != Taxon.Type.group || TaxonUtils.isItselfOrAChildIn(taxon.getTaxon(), subspeciesSet)) continue;
            subspeciesSet.add(taxon.getTaxon().getId());
        }
        for (SightingTaxon.Resolved taxon : taxa) {
            if (taxon.getType() != SightingTaxon.Type.SINGLE || taxon.getSmallestTaxonType() != Taxon.Type.species || TaxonUtils.isItselfOrAChildIn(taxon.getTaxon(), subspeciesSet)) continue;
            subspeciesSet.add(taxon.getTaxon().getId());
        }
        for (SightingTaxon.Resolved taxon : taxa) {
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getSmallestTaxonType() == Taxon.Type.species) continue;
            SightingTaxon sightingTaxon = taxon.getParentOfAtLeastType(Taxon.Type.group);
            Taxon taxonToTest = null;
            if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE) {
                taxonToTest = taxonomy.getTaxon(sightingTaxon.getId());
            } else {
                sightingTaxon = taxon.getParentOfAtLeastType(Taxon.Type.species);
                if (sightingTaxon.getType() == SightingTaxon.Type.SINGLE) {
                    taxonToTest = taxonomy.getTaxon(sightingTaxon.getId());
                }
            }
            if (taxonToTest == null || TaxonUtils.isItselfOrAChildIn(taxonToTest, subspeciesSet)) continue;
            subspeciesSet.add(taxonToTest.getId());
        }
        return Collections.unmodifiableSet(subspeciesSet);
    }

    public int getCountableSubspeciesGroupsAndSpeciesSize(Taxonomy taxonomy, boolean includeNonSingle) {
        Set<String> countableSubspeciesIds = this.getCountableSubspeciesGroupsAndSpeciesIds(taxonomy);
        if (!includeNonSingle) {
            return countableSubspeciesIds.size();
        }
        int nonSingleCount = this.countNonSingleTaxa(taxonomy, countableSubspeciesIds, Taxon.Type.subspecies);
        return countableSubspeciesIds.size() + nonSingleCount;
    }

    private int countNonSingleTaxa(Taxonomy taxonomy, Set<String> countableTaxaIds, Taxon.Type taxonType) {
        int nonSingleCount = 0;
        HashSet<String> nonSingleIds = Sets.newHashSet();
        for (SightingTaxon.Resolved resolved : this.getCountableTaxaAsList(taxonomy, false)) {
            if (resolved.getType() != SightingTaxon.Type.SP || resolved.getLargestTaxonType() != taxonType) continue;
            boolean alreadyCounted = false;
            for (String id : resolved.getSightingTaxon().getIds()) {
                if (!countableTaxaIds.contains(id) && !nonSingleIds.contains(id)) continue;
                alreadyCounted = true;
                break;
            }
            if (alreadyCounted) continue;
            ++nonSingleCount;
            for (String id : resolved.getSightingTaxon().getIds()) {
                nonSingleIds.add(id);
            }
        }
        return nonSingleCount;
    }

    public List<SightingTaxon.Resolved> getTaxaAsList() {
        return Collections.unmodifiableList(this.taxaAsList);
    }

    public List<VisitInfoKey> getAllVisitInfoKeys() {
        TreeSet<VisitInfoKey> visitInfoKeys = Sets.newTreeSet(new VisitInfoKeyOrdering());
        visitInfoKeys.addAll(this.incompatibleVisitInfos);
        for (Sighting sighting : this.sightings.values()) {
            VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
            if (visitInfoKey == null) continue;
            visitInfoKeys.add(visitInfoKey);
        }
        return ImmutableList.copyOf(visitInfoKeys);
    }

    public List<VisitInfoKey> getVisitInfoKeys(String locationId) {
        TreeSet<VisitInfoKey> visitInfoKeys = Sets.newTreeSet(new VisitInfoKeyOrdering());
        for (Sighting sighting : this.sightings.values()) {
            VisitInfoKey visitInfoKey;
            if (!locationId.equals(sighting.getLocationId()) || (visitInfoKey = VisitInfoKey.forSighting(sighting)) == null) continue;
            visitInfoKeys.add(visitInfoKey);
        }
        return ImmutableList.copyOf(visitInfoKeys);
    }

    public Collection<Sighting> getAllSightings(Taxon taxon) {
        return this.getAllSightings(SightingTaxons.newResolved(taxon));
    }

    public Collection<Sighting> getAllSightings(SightingTaxon.Resolved taxon) {
        return Collections.unmodifiableCollection(this.getTaxonSightings(taxon));
    }

    public Sighting getBestSighting(Taxon taxon, Ordering<Sighting> ordering) {
        return this.getBestSighting(SightingTaxons.newResolved(taxon), ordering);
    }

    public boolean isCountable(SightingTaxon.Resolved taxon) {
        if (this.getCountablePredicate() == null) {
            return true;
        }
        Collection<Sighting> taxonSightings = this.getTaxonSightings(taxon);
        return taxonSightings.stream().anyMatch(this.getCountablePredicate());
    }

    public Sighting getBestSighting(SightingTaxon.Resolved taxon, Ordering<Sighting> ordering) {
        Collection<Sighting> taxonSightings = this.getTaxonSightings(taxon);
        return taxonSightings.isEmpty() ? null : ordering.max(taxonSightings);
    }

    public List<Sighting> getBestSightings(SightingTaxon.Resolved taxon, Ordering<Sighting> ordering, int count) {
        Collection<Sighting> taxonSightings = this.getTaxonSightings(taxon);
        return taxonSightings.isEmpty() ? ImmutableList.of() : ordering.greatestOf(taxonSightings, count);
    }

    private Collection<Sighting> getTaxonSightings(SightingTaxon.Resolved taxon) {
        if (taxon.getTaxonomy() == this.getTaxonomy()) {
            switch (taxon.getType()) {
                case SINGLE: {
                    return this.sightings.get(taxon.getTaxon().getId());
                }
            }
            return this.nonSingleSightings.get(taxon.getSightingTaxon());
        }
        return this.getAllSightingsIncompatible(taxon);
    }

    public boolean containsTaxon(Taxon taxon) {
        return this.sightings.containsKey(taxon.getId());
    }

    public boolean containsTaxonCountably(Taxon taxon) {
        return this.countableSightingTaxa.contains(taxon.getId());
    }

    public int getSightingsCount(Taxonomy taxonomy) {
        if (taxonomy == this.getTaxonomy()) {
            return this.sightings.size() + this.nonSingleSightings.size();
        }
        return ((Multimap)this.incompatibleSightings.getOrDefault(taxonomy, ImmutableMultimap.of())).size() + ((Multimap)this.incompatibleNonSingleSightings.getOrDefault(taxonomy, ImmutableMultimap.of())).size();
    }

    private List<SightingTaxon.Resolved> getResolvedTaxa(Taxonomy taxonomy, Set<String> ids, Set<SightingTaxon> nonSingleTaxa, boolean includeFamilies, boolean includeChecklist) {
        ArrayList<SightingTaxon.Resolved> list = Lists.newArrayListWithExpectedSize(ids.size());
        ArrayListMultimap<String, SightingTaxon> idsWithNonSingleTaxa = ArrayListMultimap.create();
        for (SightingTaxon taxon : nonSingleTaxa) {
            for (String id : taxon.getIds()) {
                idsWithNonSingleTaxa.put(id, taxon);
            }
        }
        this.addTaxa(list, taxonomy, ids, idsWithNonSingleTaxa, taxonomy.getRoot(), includeFamilies, includeChecklist, null);
        return list;
    }

    private boolean addTaxa(List<SightingTaxon.Resolved> list, Taxonomy taxonomy, Set<String> ids, Multimap<String, SightingTaxon> idsWithNonSingleTaxa, Taxon taxon, boolean includeFamilies, boolean includeChecklist, Taxon currentFamily) {
        Object resolved;
        boolean added = false;
        if (taxon.getType().compareTo(this.getSmallestType()) < 0) {
            return false;
        }
        if ((ids.contains(taxon.getId()) || includeChecklist && this.shouldBeAddedFromChecklist(taxon)) && this.taxonFilter.apply((SightingTaxon.Resolved)(resolved = SightingTaxons.newResolved(taxon)))) {
            if (includeFamilies && currentFamily != null) {
                list.add(SightingTaxons.newResolved(currentFamily));
            }
            list.add((SightingTaxon.Resolved)resolved);
            added = true;
            currentFamily = null;
        }
        if (taxon.getType() == Taxon.Type.family) {
            currentFamily = taxon;
        }
        for (Taxon child : taxon.getContents()) {
            if (!this.addTaxa(list, taxonomy, ids, idsWithNonSingleTaxa, child, includeFamilies, includeChecklist, currentFamily)) continue;
            added = true;
            currentFamily = null;
        }
        if (idsWithNonSingleTaxa.containsKey(taxon.getId())) {
            Collection<SightingTaxon> sightingTaxa = idsWithNonSingleTaxa.get(taxon.getId());
            for (SightingTaxon sightingTaxon : sightingTaxa) {
                SightingTaxon.Resolved resolved2;
                boolean stillPending = false;
                for (String id : sightingTaxon.getIds()) {
                    if (id.equals(taxon.getId()) || !idsWithNonSingleTaxa.containsKey(id)) continue;
                    stillPending = true;
                    break;
                }
                if (stillPending || !this.taxonFilter.apply(resolved2 = sightingTaxon.resolveInternal(taxonomy))) continue;
                if (includeFamilies && currentFamily != null) {
                    list.add(SightingTaxons.newResolved(currentFamily));
                }
                added = true;
                currentFamily = null;
                list.add(resolved2);
            }
            idsWithNonSingleTaxa.removeAll(taxon.getId());
        }
        return added;
    }

    private boolean shouldBeAddedFromChecklist(Taxon taxon) {
        if (!this.includeAllChecklistSpecies) {
            return false;
        }
        Checklist checklist = this.getChecklist(taxon.getTaxonomy());
        if (checklist == null) {
            return false;
        }
        if (!checklist.includesTaxon(taxon)) {
            return false;
        }
        if (this.ignoredStatus.isEmpty()) {
            return true;
        }
        Checklist.Status status = checklist.getStatus(this.taxonomy, SightingTaxons.newSightingTaxon(taxon.getId()));
        return !this.ignoredStatus.contains((Object)status);
    }

    public void removeSightings(Collection<Sighting> removedSightings) {
        this.updateSightings(removedSightings, ImmutableList.of(), true);
    }

    public void updateSightings(Collection<Sighting> removedSightings, Collection<Sighting> addedSightings, boolean updateTaxa) {
        this.sightings.values().removeAll(removedSightings);
        this.nonSingleSightings.values().removeAll(removedSightings);
        for (Sighting removedSighting : removedSightings) {
            Multimap<Object, Sighting> multimap;
            if (TaxonUtils.areCompatible(removedSighting.getTaxonomy(), this.taxonomy)) continue;
            SightingTaxon taxon = removedSighting.getTaxon();
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                multimap = this.incompatibleSightings.get(removedSighting.getTaxonomy());
                if (multimap == null) continue;
                multimap.remove(taxon.getId(), removedSighting);
                continue;
            }
            multimap = this.incompatibleNonSingleSightings.get(removedSighting.getTaxonomy());
            if (multimap == null) continue;
            multimap.remove(taxon, removedSighting);
        }
        for (Sighting addedSighting : addedSightings) {
            boolean isValidSighting = this.queryDefinition.predicate().apply(addedSighting);
            if (!isValidSighting) {
                if (!this.keepInvalidSightingsAfterUpdate) continue;
                this.queryInvalid = true;
            }
            SightingTaxon taxon = addedSighting.getTaxon();
            if (TaxonUtils.areCompatible(addedSighting.getTaxonomy(), this.taxonomy)) {
                SightingTaxon.Resolved resolved = taxon.resolve(this.taxonomy);
                if ((taxon = resolved.getParentOfAtLeastType(this.smallestType)).getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                    this.sightings.put(taxon.getId(), addedSighting);
                    continue;
                }
                this.nonSingleSightings.put(taxon, addedSighting);
                continue;
            }
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                this.incompatibleSightings.computeIfAbsent(addedSighting.getTaxonomy(), __ -> ArrayListMultimap.create()).put(taxon.getId(), addedSighting);
                continue;
            }
            this.incompatibleNonSingleSightings.computeIfAbsent(addedSighting.getTaxonomy(), __ -> ArrayListMultimap.create()).put(taxon, addedSighting);
        }
        this.precomputeResults(updateTaxa);
        this.notifyListeners();
    }

    public TreeMap<Sighting, SightingTaxon.Resolved> gatherSortedSightings(List<SightingTaxon.Resolved> taxa, Ordering<Sighting> sightingOrdering, int sightingsCount) {
        TreeMap<Sighting, SightingTaxon.Resolved> allSightings = Maps.newTreeMap(sightingOrdering.reverse().compound(Ordering.arbitrary()));
        for (SightingTaxon.Resolved taxon : taxa) {
            if (taxon.getSmallestTaxonType() == Taxon.Type.family) continue;
            for (Sighting sighting : this.getBestSightings(taxon, sightingOrdering, Math.max(1, sightingsCount))) {
                allSightings.put(sighting, taxon);
            }
        }
        return allSightings;
    }

    public SightingTaxon.Resolved resolveToType(SightingTaxon taxon) {
        SightingTaxon.Resolved resolved = taxon.resolve(this.taxonomy);
        if ((taxon = resolved.getParentOfAtLeastType(this.smallestType)).getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
            taxon = SightingTaxons.newSightingTaxon(taxon.getId());
        }
        return taxon.resolveInternal(this.taxonomy);
    }

    public void addListener(Listener listener) {
        this.listeners.add(Preconditions.checkNotNull(listener));
    }

    private void notifyListeners() {
        for (Listener listener : this.listeners) {
            listener.resultsChanged();
        }
    }

    public boolean isQueryInvalid() {
        return this.queryInvalid;
    }

    public Iterable<Sighting> getAllSightings() {
        return Iterables.concat(this.sightings.values(), this.nonSingleSightings.values());
    }

    @Nullable
    public Checklist getChecklist(Taxonomy taxonomy) {
        if (taxonomy == this.getTaxonomy()) {
            return this.checklist;
        }
        return this.incompatibleTaxonomyChecklists.get(taxonomy);
    }

    public Optional<QueryDefinition.QueryAnnotation> getAnnotation(Sighting sighting, SightingTaxon taxon) {
        return this.queryDefinition.annotate(sighting, taxon);
    }

    public boolean containsAnnotation(QueryDefinition.QueryAnnotation annotation, SightingTaxon.Resolved resolved) {
        return this.getTaxaWithAnnotation(resolved.getTaxonomy(), annotation).contains(resolved);
    }

    public int getFamilyCount(Taxonomy taxonomy) {
        int familyCount = 0;
        for (SightingTaxon.Resolved resolved : this.getCountableTaxaAsList(taxonomy, this.includeAllChecklistSpecies)) {
            if (resolved.getSmallestTaxonType() != Taxon.Type.family) continue;
            ++familyCount;
        }
        return familyCount;
    }

    public int getSpuhCount() {
        return (int)this.countableTaxaAsList.stream().filter(s -> s.getType() == SightingTaxon.Type.SP).count();
    }

    public Collection<Taxonomy> getIncompatibleTaxonomies() {
        return ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.incompatibleSightings.keySet())).addAll(this.incompatibleNonSingleSightings.keySet())).build();
    }

    public List<SightingTaxon.Resolved> getIncompatibleTaxaAsList(Taxonomy taxonomy, boolean includeFamilies) {
        if (!(this.incompatibleSightings.containsKey(taxonomy) || this.incompatibleNonSingleSightings.containsKey(taxonomy) || this.includeAllChecklistSpecies)) {
            return ImmutableList.of();
        }
        return this.getResolvedTaxa(taxonomy, ((Multimap)this.incompatibleSightings.getOrDefault(taxonomy, ImmutableMultimap.of())).keySet(), ((Multimap)this.incompatibleNonSingleSightings.getOrDefault(taxonomy, ImmutableMultimap.of())).keySet(), includeFamilies, this.includeAllChecklistSpecies);
    }

    private Collection<Sighting> getAllSightingsIncompatible(SightingTaxon.Resolved taxon) {
        switch (taxon.getType()) {
            case SINGLE: {
                return Collections.unmodifiableCollection(((Multimap)this.incompatibleSightings.getOrDefault(taxon.getTaxonomy(), ImmutableMultimap.of())).get(taxon.getTaxon().getId()));
            }
        }
        SightingTaxon sightingTaxon = taxon.getSightingTaxon();
        return Collections.unmodifiableCollection(((Multimap)this.incompatibleNonSingleSightings.getOrDefault(taxon.getTaxonomy(), ImmutableMultimap.of())).get(sightingTaxon));
    }

    private List<SightingTaxon.Resolved> getCountableTaxaAsList(Taxonomy taxonomy, boolean includeChecklist) {
        if (taxonomy == this.getTaxonomy()) {
            return this.countableTaxaAsList;
        }
        Multimap countableSingleSightings = this.incompatibleSightings.getOrDefault(taxonomy, ImmutableMultimap.of());
        if (this.getCountablePredicate() != null) {
            countableSingleSightings = Multimaps.filterValues(countableSingleSightings, this.getCountablePredicate());
        }
        Multimap countableNonSingleSightings = this.incompatibleNonSingleSightings.getOrDefault(taxonomy, ImmutableMultimap.of());
        if (this.getCountablePredicate() != null) {
            countableNonSingleSightings = Multimaps.filterValues(countableNonSingleSightings, this.getCountablePredicate());
        }
        return this.getResolvedTaxa(taxonomy, countableSingleSightings.keySet(), countableNonSingleSightings.keySet(), this.includeFamilyNames, includeChecklist);
    }

    public Predicate<Sighting> getCountablePredicate() {
        return this.countable;
    }

    static class Builder {
        private final Multimap<String, Sighting> sightings = ArrayListMultimap.create();
        private final Multimap<SightingTaxon, Sighting> nonSingleSightings = ArrayListMultimap.create();
        private final Map<Taxonomy, Multimap<String, Sighting>> incompatibleSightings = new LinkedHashMap<Taxonomy, Multimap<String, Sighting>>();
        private final Map<Taxonomy, Multimap<SightingTaxon, Sighting>> incompatibleNonSingleSightings = new LinkedHashMap<Taxonomy, Multimap<SightingTaxon, Sighting>>();
        private final Map<Sighting, QueryDefinition.QueryAnnotation> annotations = Maps.newHashMap();
        private final Set<VisitInfoKey> incompatibleVisitInfos = new LinkedHashSet<VisitInfoKey>();
        private boolean keepInvalidSightingsAfterUpdate;
        private boolean dontIncludeFamilyNames;
        private boolean includeAllChecklistSpecies;
        private Predicate<SightingTaxon.Resolved> taxonFilter;
        private ImmutableSet<Checklist.Status> ignoredStatus;

        Builder() {
        }

        void addSighting(Sighting sighting, SightingTaxon taxon, Optional<QueryDefinition.QueryAnnotation> annotation) {
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                this.sightings.put(taxon.getId(), sighting);
            } else {
                this.nonSingleSightings.put(taxon, sighting);
            }
            if (annotation.isPresent()) {
                this.annotations.put(sighting, annotation.get());
            }
        }

        void addSighting(Sighting sighting, SightingTaxon taxon) {
            this.addSighting(sighting, taxon, Optional.absent());
        }

        void addIncompatibleSighting(Sighting sighting, SightingTaxon taxon, Optional<QueryDefinition.QueryAnnotation> annotation) {
            VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
            if (visitInfoKey != null) {
                this.incompatibleVisitInfos.add(visitInfoKey);
            }
            if (taxon.getType() == SightingTaxon.Type.SINGLE || taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                this.incompatibleSightings.computeIfAbsent(sighting.getTaxonomy(), __ -> ArrayListMultimap.create()).put(taxon.getId(), sighting);
            } else {
                this.incompatibleNonSingleSightings.computeIfAbsent(sighting.getTaxonomy(), __ -> ArrayListMultimap.create()).put(taxon, sighting);
            }
            if (annotation.isPresent()) {
                this.annotations.put(sighting, annotation.get());
            }
        }

        void dontIncludeFamilyNames() {
            this.dontIncludeFamilyNames = true;
        }

        void keepInvalidSightingsAfterUpdate() {
            this.keepInvalidSightingsAfterUpdate = true;
        }

        public void includeAllChecklistSpecies(Iterable<Checklist.Status> ignoredStatus) {
            this.includeAllChecklistSpecies = true;
            this.ignoredStatus = ImmutableSet.copyOf(ignoredStatus);
        }

        public void withTaxonFilter(Predicate<SightingTaxon.Resolved> taxonFilter) {
            this.taxonFilter = taxonFilter;
        }

        public void postProcess(QueryDefinition.PostProcessor postProcessor, @Nullable Predicate<Sighting> countablePredicate) {
            Iterator<String> sightingsIterator = this.sightings.keySet().iterator();
            while (sightingsIterator.hasNext()) {
                String taxonId = sightingsIterator.next();
                if (postProcessor.acceptTaxon(SightingTaxons.newSightingTaxon(taxonId), this.sightings.get(taxonId), countablePredicate)) continue;
                sightingsIterator.remove();
            }
            Iterator<SightingTaxon> nonSingleSightingsIterator = this.nonSingleSightings.keySet().iterator();
            while (nonSingleSightingsIterator.hasNext()) {
                SightingTaxon taxon = nonSingleSightingsIterator.next();
                if (postProcessor.acceptTaxon(taxon, this.nonSingleSightings.get(taxon), countablePredicate)) continue;
                nonSingleSightingsIterator.remove();
            }
        }
    }

    public static interface Listener {
        public void resultsChanged();
    }
}

