/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.query.PredicateQueryDefinition;
import com.scythebill.birdlist.model.query.QueryDefinition;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.Map;
import javax.annotation.Nullable;

public class QueryProcessor {
    private final ReportSet reportSet;
    private final Taxonomy taxonomy;
    private final Checklist checklist;
    private boolean keepInvalidSightingsAfterUpdate;
    private boolean dontIncludeFamilyNames;
    private boolean includeAllChecklistSpecies;
    private Predicate<SightingTaxon.Resolved> taxonFilter = Predicates.alwaysTrue();
    private ImmutableSet<Checklist.Status> ignoredStatus;
    private boolean includeIncompatibleSightings;
    private boolean onlyIncludeCountableSightings;
    private Predicate<Sighting> additionalPredicate;
    private ImmutableMap<Taxonomy, Checklist> incompatibleTaxonomyChecklists;

    public QueryProcessor(ReportSet reportSet, Taxonomy taxonomy) {
        this(reportSet, taxonomy, null, null);
    }

    public QueryProcessor(ReportSet reportSet, Taxonomy taxonomy, @Nullable Checklist checklist, @Nullable Map<Taxonomy, Checklist> incompatibleTaxonomyChecklists) {
        this.reportSet = Preconditions.checkNotNull(reportSet);
        this.taxonomy = Preconditions.checkNotNull(taxonomy);
        this.checklist = checklist;
        this.incompatibleTaxonomyChecklists = incompatibleTaxonomyChecklists == null ? ImmutableMap.of() : ImmutableMap.copyOf(incompatibleTaxonomyChecklists);
    }

    private QueryResults.Builder runQueryInternal(QueryDefinition queryDefinition, Taxon.Type smallestType, Predicate<Sighting> countablePredicate) {
        Preconditions.checkNotNull(queryDefinition);
        boolean resolveAll = smallestType != Taxon.Type.subspecies || this.taxonomy instanceof MappedTaxonomy;
        QueryResults.Builder resultsBuilder = new QueryResults.Builder();
        if (this.keepInvalidSightingsAfterUpdate) {
            resultsBuilder.keepInvalidSightingsAfterUpdate();
        }
        if (this.dontIncludeFamilyNames) {
            resultsBuilder.dontIncludeFamilyNames();
        }
        if (this.includeAllChecklistSpecies) {
            resultsBuilder.includeAllChecklistSpecies(this.ignoredStatus);
        }
        resultsBuilder.withTaxonFilter(this.taxonFilter);
        if (queryDefinition.preprocessor().isPresent()) {
            QueryDefinition.Preprocessor preprocessor = queryDefinition.preprocessor().get();
            preprocessor.reset();
            for (Sighting sighting : this.reportSet.getSightings(this.taxonomy)) {
                preprocessor.preprocess(sighting, countablePredicate);
            }
        }
        Predicate<Sighting> sightingPredicate = Preconditions.checkNotNull(queryDefinition.predicate());
        if (this.onlyIncludeCountableSightings && countablePredicate != null) {
            sightingPredicate = Predicates.and(sightingPredicate, countablePredicate);
        }
        if (this.additionalPredicate != null) {
            sightingPredicate = Predicates.and(sightingPredicate, this.additionalPredicate);
        }
        for (Sighting sighting : this.reportSet.getSightings()) {
            Optional<QueryDefinition.QueryAnnotation> annotation;
            SightingTaxon.Resolved resolved;
            SightingTaxon taxon;
            if (!sightingPredicate.apply(sighting)) continue;
            if (TaxonUtils.areCompatible(sighting.getTaxonomy(), this.taxonomy)) {
                taxon = sighting.getTaxon();
                if (resolveAll) {
                    resolved = taxon.resolve(this.taxonomy);
                    taxon = resolved.getParentOfAtLeastType(smallestType);
                }
                annotation = queryDefinition.annotate(sighting, taxon);
                resultsBuilder.addSighting(sighting, taxon, annotation);
                continue;
            }
            if (!this.includeIncompatibleSightings) continue;
            taxon = sighting.getTaxon();
            if (resolveAll) {
                resolved = taxon.resolve(sighting.getTaxonomy());
                taxon = resolved.getParentOfAtLeastType(smallestType);
            }
            annotation = queryDefinition.annotate(sighting, taxon);
            resultsBuilder.addIncompatibleSighting(sighting, taxon, annotation);
        }
        Optional<QueryDefinition.PostProcessor> postProcessor = queryDefinition.postprocessor();
        if (postProcessor.isPresent()) {
            resultsBuilder.postProcess(postProcessor.get(), countablePredicate);
        }
        return resultsBuilder;
    }

    public QueryResults runQuery(QueryDefinition queryDefinition, @Nullable Predicate<Sighting> countablePredicate, Taxon.Type smallestType) {
        return new QueryResults(this.taxonomy, this.checklist, this.incompatibleTaxonomyChecklists, queryDefinition, this.runQueryInternal(queryDefinition, smallestType, countablePredicate), smallestType, countablePredicate);
    }

    public QueryResults runQuery(Predicate<Sighting> sightingPredicate, @Nullable Predicate<Sighting> countablePredicate, Taxon.Type smallestType) {
        return this.runQuery(new PredicateQueryDefinition(sightingPredicate), countablePredicate, smallestType);
    }

    public void keepInvalidSightingsAfterUpdate() {
        this.keepInvalidSightingsAfterUpdate = true;
    }

    public void dontIncludeFamilyNames() {
        this.dontIncludeFamilyNames = true;
    }

    public void includeAllChecklistSpecies(Iterable<Checklist.Status> ignoredStatus) {
        this.includeAllChecklistSpecies = true;
        this.ignoredStatus = ImmutableSet.copyOf(ignoredStatus);
    }

    public void withTaxonFilter(Predicate<SightingTaxon.Resolved> taxonFilter) {
        this.taxonFilter = taxonFilter;
    }

    public QueryProcessor includingIncompatibleSightings() {
        this.includeIncompatibleSightings = true;
        return this;
    }

    public QueryProcessor onlyIncludeCountableSightings() {
        this.onlyIncludeCountableSightings = true;
        return this;
    }

    public QueryProcessor withAdditionalPredicate(Predicate<Sighting> additionalPredicate) {
        this.additionalPredicate = this.additionalPredicate == null ? additionalPredicate : Predicates.and(this.additionalPredicate, additionalPredicate);
        return this;
    }
}

