/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;

public class PartialPredicates {
    private static final int ALWAYS_FALSE_SENTINEL = Integer.MIN_VALUE;

    private PartialPredicates() {
    }

    public static Predicate<ReadablePartial> afterOrEquals(final ReadablePartial after) {
        return new Predicate<ReadablePartial>(){

            @Override
            public boolean apply(ReadablePartial date) {
                int value = PartialPredicates.comparePartialsFlexible(after, date);
                if (value == Integer.MIN_VALUE) {
                    return false;
                }
                return value >= 0;
            }

            public String toString() {
                return "AfterOrEquals[" + after + "]";
            }
        };
    }

    public static Predicate<ReadablePartial> after(final ReadablePartial after) {
        return new Predicate<ReadablePartial>(){

            @Override
            public boolean apply(ReadablePartial date) {
                int value = PartialPredicates.comparePartialsFlexible(after, date);
                if (value == Integer.MIN_VALUE) {
                    return false;
                }
                return value > 0;
            }

            public String toString() {
                return "After[" + after + "]";
            }
        };
    }

    public static Predicate<ReadablePartial> dateIsExactly(final ReadablePartial exactly) {
        return new Predicate<ReadablePartial>(){

            @Override
            public boolean apply(ReadablePartial date) {
                return date.equals(exactly);
            }

            public String toString() {
                return "DateIsExactly[" + exactly + "]";
            }
        };
    }

    public static Predicate<ReadablePartial> beforeOrEquals(final ReadablePartial partial) {
        return new Predicate<ReadablePartial>(){

            @Override
            public boolean apply(ReadablePartial date) {
                int value = PartialPredicates.comparePartialsFlexible(partial, date);
                if (value == Integer.MIN_VALUE) {
                    return false;
                }
                return value <= 0;
            }

            public String toString() {
                return "BeforeOrEquals[" + partial + "]";
            }
        };
    }

    public static Predicate<ReadablePartial> before(final ReadablePartial partial) {
        return new Predicate<ReadablePartial>(){

            @Override
            public boolean apply(ReadablePartial date) {
                int value = PartialPredicates.comparePartialsFlexible(partial, date);
                if (value == Integer.MIN_VALUE) {
                    return false;
                }
                return value < 0;
            }

            public String toString() {
                return "Before[" + partial + "]";
            }
        };
    }

    public static boolean isStrictSuperset(ReadablePartial base, ReadablePartial maybeSuperset) {
        return PartialPredicates.isPartialSuperset(base, maybeSuperset) && !PartialPredicates.isPartialSuperset(maybeSuperset, base);
    }

    private static boolean isPartialSuperset(ReadablePartial base, ReadablePartial partial) {
        for (int i = 0; i < base.size(); ++i) {
            DateTimeFieldType type = base.getFieldType(i);
            if (partial.isSupported(type)) continue;
            return false;
        }
        return true;
    }

    public static int comparePartialsSubset(ReadablePartial base, ReadablePartial partial) {
        for (int i = 0; i < base.size(); ++i) {
            int partialValue;
            DateTimeFieldType type = base.getFieldType(i);
            int baseValue = base.getValue(i);
            if (baseValue == (partialValue = partial.get(type))) continue;
            return partialValue - baseValue;
        }
        return 0;
    }

    private static int comparePartialsFlexible(ReadablePartial base, ReadablePartial partial) {
        for (int i = 0; i < base.size(); ++i) {
            DateTimeFieldType type = base.getFieldType(i);
            int baseValue = base.getValue(i);
            if (!partial.isSupported(type)) {
                return Integer.MIN_VALUE;
            }
            int partialValue = partial.get(type);
            if (baseValue == partialValue) continue;
            return partialValue - baseValue;
        }
        return 0;
    }
}

