/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Logger;

class PacificOceanAbaRegion
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(PacificOceanAbaRegion.class.getName());
    private static final ImmutableSet<String> PACIFIC_OCEAN_ABA_BUT_NOT_PACIFIC_OCEAN = ImmutableSet.of("AU-TAS-Macquarie", "NC", "NZ", "NF", "SB", "VU", new String[0]);
    private static final ImmutableSet<String> PACIFIC_OCEAN_ABA_BUT_NOT_PACIFIC_OCEAN_DONT_WARN = ImmutableSet.of("PG-NSA");
    private Predicate<Sighting> predicate;
    private ImmutableSet<String> syntheticUnionCodes;

    public static PacificOceanAbaRegion regionIfAvailable(LocationSet locationSet) {
        Location location;
        Location pacificOcean = PacificOceanAbaRegion.getBuiltInLocation(locationSet, "Pacific Ocean");
        if (pacificOcean == null) {
            logger.warning("No Pacific Ocean (ABA) list available: No Pacific Ocean!");
            return null;
        }
        LinkedHashSet<String> syntheticUnionCodes = new LinkedHashSet<String>();
        syntheticUnionCodes.addAll(Checklists.gatherCountryChecklistCodes(pacificOcean));
        syntheticUnionCodes.addAll(PACIFIC_OCEAN_ABA_BUT_NOT_PACIFIC_OCEAN);
        ArrayList<Location> list = Lists.newArrayList(pacificOcean);
        for (String code : PACIFIC_OCEAN_ABA_BUT_NOT_PACIFIC_OCEAN) {
            location = locationSet.getLocationByCode(code);
            if (location == null) {
                logger.warning("Could not find country code " + code);
                continue;
            }
            list.add(location);
        }
        for (String code : PACIFIC_OCEAN_ABA_BUT_NOT_PACIFIC_OCEAN_DONT_WARN) {
            location = locationSet.getLocationByCode(code);
            if (location == null) continue;
            list.add(location);
        }
        return new PacificOceanAbaRegion(locationSet, list, ImmutableSet.copyOf(syntheticUnionCodes));
    }

    private PacificOceanAbaRegion(LocationSet locationSet, Iterable<Location> locations, ImmutableSet<String> syntheticUnionCodes) {
        super("Pacific Ocean (ABA)", SyntheticLocation.Name.PACIFIC_OCEAN_ABA, "pacoceaba");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            if (location == null) continue;
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
        this.syntheticUnionCodes = syntheticUnionCodes;
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return this.syntheticUnionCodes;
    }

    private static Location getBuiltInLocation(LocationSet locationSet, String name) {
        Collection<Location> locationsByName = locationSet.getLocationsByModelName(name);
        for (Location location : locationsByName) {
            if (!location.isBuiltInLocation()) continue;
            return location;
        }
        return null;
    }
}

