/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class KingdomOfTheNetherlands
extends SyntheticLocation {
    private final Predicate<Sighting> predicate;

    public static KingdomOfTheNetherlands regionIfAvailable(LocationSet locationSet) {
        ArrayList<Location> locations = Lists.newArrayList();
        Location netherlands = locationSet.getLocationByCode("NL");
        if (netherlands == null) {
            return null;
        }
        locations.addAll(locationSet.getLocationsByCode("BQ"));
        Location aruba = locationSet.getLocationByCode("AW");
        if (aruba != null) {
            locations.add(aruba);
        }
        return new KingdomOfTheNetherlands(locationSet, locations);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return ImmutableSet.of("NL", "BQ", "AW", "CW", "BQ-BO");
    }

    private KingdomOfTheNetherlands(LocationSet locationSet, List<Location> locations) {
        super("Kingdom of the Netherlands", SyntheticLocation.Name.KINGDOM_OF_THE_NETHERLANDS, "nlwidepterr");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }
}

