/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;

class GenericSyntheticLocation
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(GenericSyntheticLocation.class.getName());
    private final Predicate<Sighting> predicate;
    private ImmutableSet<String> syntheticChecklistUnion;

    public static Builder named(LocationSet locationSet, String name, SyntheticLocation.Name bundleName) {
        return new Builder(locationSet, name, bundleName);
    }

    public static GenericSyntheticLocation regionIfAvailable(LocationSet locationSet, String name, SyntheticLocation.Name bundleName, String abbreviation, String ... codes) {
        ArrayList<Location> list = Lists.newArrayList();
        ImmutableSet.Builder syntheticChecklistCodes = ImmutableSet.builder();
        for (String code : codes) {
            Collection<Location> locations = locationSet.getLocationsByCode(code);
            if (locations.isEmpty()) {
                logger.warning("Could not find country code " + code + ", needed for " + name);
                continue;
            }
            list.addAll(locations);
            syntheticChecklistCodes.add(code);
        }
        return new GenericSyntheticLocation(locationSet, name, bundleName, abbreviation, list, ImmutableList.of(), (ImmutableSet<String>)syntheticChecklistCodes.build());
    }

    private GenericSyntheticLocation(LocationSet locationSet, String name, SyntheticLocation.Name bundleName, String abbreviation, List<Location> locations, List<Location> removedLocations, ImmutableSet<String> syntheticChecklistUnion) {
        super(name, bundleName, abbreviation);
        List<Predicate<Sighting>> inList = this.locationsToPredicates(locationSet, locations);
        if (removedLocations.isEmpty()) {
            this.predicate = Predicates.or(inList);
        } else {
            List<Predicate<Sighting>> notInList = this.locationsToPredicates(locationSet, removedLocations);
            this.predicate = Predicates.and(Predicates.not(Predicates.or(notInList)), Predicates.or(inList));
        }
        this.syntheticChecklistUnion = syntheticChecklistUnion;
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return this.syntheticChecklistUnion;
    }

    List<Predicate<Sighting>> locationsToPredicates(LocationSet locationSet, List<Location> locations) {
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            if (location == null) continue;
            list.add(SightingPredicates.in(location, locationSet));
        }
        return list;
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    public static class Builder {
        private String name;
        private SyntheticLocation.Name bundleName;
        private LocationSet locationSet;
        private String abbreviation;
        private List<Location> locations = new ArrayList<Location>();
        private List<Location> removedLocations = new ArrayList<Location>();
        private boolean dontCreate;
        private ImmutableSet.Builder<String> checklistCodes = ImmutableSet.builder();
        private ImmutableSet<String> syntheticChecklistUnion;

        Builder(LocationSet locationSet, String name, SyntheticLocation.Name bundleName) {
            this.locationSet = locationSet;
            this.bundleName = bundleName;
            this.name = name;
        }

        public Builder withAbbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return this;
        }

        public Builder withRequiredLocations(String ... codes) {
            for (String code : codes) {
                if (this.addLocationByCode(code)) continue;
                logger.warning("Could not find required country code " + code + ", needed for " + this.name);
                this.dontCreate = true;
            }
            return this;
        }

        public Builder withLocations(String ... codes) {
            for (String code : codes) {
                if (this.addLocationByCode(code)) continue;
                logger.warning("Could not find country code " + code + ", needed for " + this.name);
            }
            return this;
        }

        public Builder withOptionalLocations(String ... codes) {
            for (String code : codes) {
                this.addLocationByCode(code);
            }
            return this;
        }

        private boolean addLocationByCode(String code) {
            boolean found = false;
            if (code.equals("ID-Asia")) {
                for (Location indonesia : this.locationSet.getLocationsByCode("ID")) {
                    if (!Locations.getBuiltInAncestor(indonesia.getParent()).getModelName().equals("Asia")) continue;
                    this.locations.add(indonesia);
                    found = true;
                }
            } else {
                Preconditions.checkArgument(!code.startsWith("ID-A"), "Indonesia regional lists not supported");
                for (Location location : this.locationSet.getLocationsByCode(code)) {
                    this.locations.add(location);
                    found = true;
                }
            }
            this.checklistCodes.add((Object)code);
            return found;
        }

        public Builder withRemovedLocations(String ... codes) {
            for (String code : codes) {
                Collection<Location> locations = this.locationSet.getLocationsByCode(code);
                this.removedLocations.addAll(locations);
            }
            return this;
        }

        public Builder withSyntheticChecklistUnionFromAllLocations() {
            this.syntheticChecklistUnion = this.checklistCodes.build();
            return this;
        }

        public Builder withSyntheticChecklistUnion(String ... codes) {
            this.syntheticChecklistUnion = ImmutableSet.copyOf(codes);
            return this;
        }

        public GenericSyntheticLocation build() {
            if (this.dontCreate) {
                return null;
            }
            if (this.locations.isEmpty()) {
                return null;
            }
            Preconditions.checkState(this.abbreviation != null, "No abbreviation set");
            return new GenericSyntheticLocation(this.locationSet, this.name, this.bundleName, this.abbreviation, this.locations, this.removedLocations, this.syntheticChecklistUnion);
        }
    }
}

