/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.Collection;
import java.util.logging.Logger;

class ContiguousUnitedStates
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(ContiguousUnitedStates.class.getName());
    private Predicate<Sighting> predicate;
    private static final ImmutableSet<String> SYNTHETIC_CHECKLIST_UNION = ImmutableSet.of("US-AL", "US-AZ", "US-AR", "US-CA", "US-CO", "US-CT", new String[]{"US-DE", "US-DC", "US-FL", "US-GA", "US-ID", "US-IL", "US-IN", "US-IA", "US-KS", "US-KY", "US-LA", "US-ME", "US-MD", "US-MA", "US-MI", "US-MN", "US-MS", "US-MO", "US-MT", "US-NE", "US-NV", "US-NH", "US-NJ", "US-NM", "US-NY", "US-NC", "US-ND", "US-OH", "US-OK", "US-OR", "US-PA", "US-RI", "US-SC", "US-SD", "US-TN", "US-TX", "US-UT", "US-VT", "US-VA", "US-WA", "US-WV", "US-WI", "US-WY"});

    public static ContiguousUnitedStates regionIfAvailable(LocationSet locationSet) {
        Location northAmericanUsa = SyntheticLocations.getNorthAmericanUsa(locationSet);
        if (northAmericanUsa == null) {
            logger.warning("No United States in North America - no contiguous US list available");
            return null;
        }
        Location alaska = locationSet.getLocationByCode("US-AK");
        if (alaska == null) {
            logger.warning("No Alaska state - no contiguous US list available");
            return null;
        }
        return new ContiguousUnitedStates(locationSet, northAmericanUsa, alaska);
    }

    private ContiguousUnitedStates(LocationSet locationSet, Location northAmericaUsa, Location alaska) {
        super("United States - contiguous", SyntheticLocation.Name.CONTIGUOUS_UNITED_STATES, "us48");
        this.predicate = Predicates.and(SightingPredicates.in(northAmericaUsa, locationSet), Predicates.not(SightingPredicates.in(alaska, locationSet)));
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return SYNTHETIC_CHECKLIST_UNION;
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }
}

