/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class AouRegion
extends SyntheticLocation {
    private static final ImmutableSet<String> SYNTHETIC_CHECKLIST_UNION = ImmutableSet.of("US", "CA", "PM", "US-HI", "UM-71", "UM-67", new String[]{"GL", "CU", "BQ", "BS", "MF", "CP", "MX", "BM", "BZ", "CR", "SV", "GT", "HN", "NI", "PA", "AI", "AG", "BB", "VG", "BQ", "KY", "DM", "DO", "GD", "GP", "HT", "JM", "MQ", "MS", "BL", "KN", "LC", "MF", "VC", "CO-SAP", "TC", "PR", "VI"});
    private static final Logger logger = Logger.getLogger(AouRegion.class.getName());
    private Predicate<Sighting> predicate;

    public static AouRegion regionIfAvailable(LocationSet locationSet) {
        Location clipperton;
        Location midway;
        Location johnston;
        Location northAmerica = AouRegion.getNorthAmerica(locationSet);
        if (northAmerica == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(northAmerica);
        Location hawaii = locationSet.getLocationByCode("US-HI");
        if (hawaii != null) {
            locations.add(hawaii);
        }
        if ((johnston = locationSet.getLocationByCode("UM-67")) != null) {
            locations.add(johnston);
        }
        if ((midway = locationSet.getLocationByCode("UM-71")) != null) {
            locations.add(midway);
        }
        if ((clipperton = locationSet.getLocationByCode("CP")) != null) {
            locations.add(clipperton);
        }
        return new AouRegion(locationSet, locations);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return SYNTHETIC_CHECKLIST_UNION;
    }

    @Override
    public Collection<Location> syntheticChecklistUnionLocations(LocationSet locationSet, PredefinedLocations predefinedLocations) {
        Location northAmerica = AouRegion.getNorthAmerica(locationSet);
        if (northAmerica == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(northAmerica);
        locations.addAll(this.syntheticChecklistUnionLocations(locationSet, predefinedLocations, ImmutableSet.of("UM-67", "UM-71", "CP", "US-HI")));
        return locations;
    }

    private AouRegion(LocationSet locationSet, List<Location> locations) {
        super("AOS Area - North", SyntheticLocation.Name.AOU_NORTH, "aou");
        List inPredicates = locations.stream().map(l -> SightingPredicates.in(l, locationSet)).collect(Collectors.toCollection(ArrayList::new));
        this.predicate = Predicates.or(inPredicates);
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    private static Location getNorthAmerica(LocationSet locationSet) {
        Collection<Location> locationsByName = locationSet.getLocationsByModelName("North America");
        if (locationsByName.size() > 1) {
            logger.warning("AOU list not available: >1 North America");
            return null;
        }
        if (locationsByName.isEmpty()) {
            logger.warning("AOU list not available: no North America");
            return null;
        }
        return Iterables.getOnlyElement(locationsByName);
    }
}

