/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.scythebill.birdlist.model.query.AouRegion;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class AosSouth
extends SyntheticLocation {
    private static final ImmutableSet<String> SYNTHETIC_CHECKLIST_UNION = ImmutableSet.of("AR", "AW", "BO", "BR", "BQ-BO", "CL", new String[]{"CO", "CW", "EC", "GF", "GY", "PY", "PE", "SR", "TT", "UY", "VE", "EC-W", "FK"});
    private static final Logger logger = Logger.getLogger(AouRegion.class.getName());
    private Predicate<Sighting> predicate;

    public static AosSouth regionIfAvailable(LocationSet locationSet) {
        Location falklands;
        Location southAmerica = AosSouth.getSouthAmerica(locationSet);
        if (southAmerica == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(southAmerica);
        Location galapagos = locationSet.getLocationByCode("EC-W");
        if (galapagos != null) {
            locations.add(galapagos);
        }
        if ((falklands = locationSet.getLocationByCode("FK")) != null) {
            locations.add(falklands);
        }
        return new AosSouth(locationSet, locations);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return SYNTHETIC_CHECKLIST_UNION;
    }

    @Override
    public Collection<Location> syntheticChecklistUnionLocations(LocationSet locationSet, PredefinedLocations predefinedLocations) {
        Location southAmerica = AosSouth.getSouthAmerica(locationSet);
        if (southAmerica == null) {
            return null;
        }
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(southAmerica);
        locations.addAll(this.syntheticChecklistUnionLocations(locationSet, predefinedLocations, ImmutableSet.of("EC-W", "FK")));
        return locations;
    }

    private AosSouth(LocationSet locationSet, List<Location> locations) {
        super("AOS Area - South", SyntheticLocation.Name.AOU_SOUTH, "aossouth");
        List inPredicates = locations.stream().map(l -> SightingPredicates.in(l, locationSet)).collect(Collectors.toCollection(ArrayList::new));
        this.predicate = Predicates.or(inPredicates);
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    private static Location getSouthAmerica(LocationSet locationSet) {
        Collection<Location> locationsByName = locationSet.getLocationsByModelName("South America");
        if (locationsByName.size() > 1) {
            logger.warning("AOS South list not available: >1 South America");
            return null;
        }
        if (locationsByName.isEmpty()) {
            logger.warning("AOS South list not available: no South America");
            return null;
        }
        return Iterables.getOnlyElement(locationsByName);
    }
}

