/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.query;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.scythebill.birdlist.model.query.SightingPredicates;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.query.SyntheticLocations;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

class AbaRegionWithoutHawaii
extends SyntheticLocation {
    private static final Logger logger = Logger.getLogger(AbaRegionWithoutHawaii.class.getName());
    private Predicate<Sighting> predicate;

    public static AbaRegionWithoutHawaii regionIfAvailable(LocationSet locationSet) {
        Location northAmericanUsa = SyntheticLocations.getNorthAmericanUsa(locationSet);
        if (northAmericanUsa == null) {
            logger.warning("No ABA list available: No United States in North America");
            return null;
        }
        Location canada = AbaRegionWithoutHawaii.getCanada(locationSet);
        if (canada == null) {
            logger.warning("No ABA list available: No country Canada");
            return null;
        }
        return new AbaRegionWithoutHawaii(locationSet, northAmericanUsa, canada, AbaRegionWithoutHawaii.getStPierreAndMiquelon(locationSet));
    }

    private AbaRegionWithoutHawaii(LocationSet locationSet, Location ... locations) {
        super("ABA region (without Hawaii)", SyntheticLocation.Name.ABA_REGION_WITHOUT_HAWAII, "abawh");
        ArrayList<Predicate<Sighting>> list = Lists.newArrayList();
        for (Location location : locations) {
            if (location == null) continue;
            list.add(SightingPredicates.in(location, locationSet));
        }
        this.predicate = Predicates.or(list);
    }

    @Override
    public Collection<String> syntheticChecklistUnion() {
        return ImmutableSet.of("US", "CA", "PM");
    }

    @Override
    public Predicate<Sighting> isInPredicate() {
        return this.predicate;
    }

    private static Location getCanada(LocationSet locationSet) {
        return locationSet.getLocationByCode("CA");
    }

    private static Location getStPierreAndMiquelon(LocationSet locationSet) {
        return locationSet.getLocationByCode("PM");
    }
}

