/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.mapdata;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.FileDataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.Property;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.data.collection.SpatialIndexFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.GeoTools;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexedLine;

public abstract class MapData {
    private static final Logger logger = Logger.getLogger(MapData.class.getName());
    private static final MapData instance = MapData.createMapData();

    public static MapData instance() {
        return instance;
    }

    public abstract String getISOCode(LatLongCoordinates var1);

    private static MapData createMapData() {
        try {
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            FileDataStore mapUnits = dataStoreFactory.createDataStore(Resources.getResource(MapData.class, "ne_50m_admin_0_map_units.shp"));
            SimpleFeatureSource mapUnitsFeatureSource = mapUnits.getFeatureSource();
            FileDataStore states = dataStoreFactory.createDataStore(Resources.getResource(MapData.class, "ne_50m_admin_1_states_provinces.shp"));
            SimpleFeatureSource statesFeatureSource = states.getFeatureSource();
            return new MapDataImpl(mapUnitsFeatureSource.getFeatures(), mapUnitsFeatureSource.getBounds(), statesFeatureSource.getFeatures());
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Failed to parse map data", t);
            return new ThrowingMapData(new IllegalStateException("Could not parse map data", t));
        }
    }

    static class MapDataImpl
    extends MapData {
        private final SimpleFeatureCollection mapUnitFeatures;
        private final ReferencedEnvelope mapUnitEnvelope;
        private final SpatialIndexFeatureCollection mapUnitSpatialIndex;
        private final SimpleFeatureCollection statesFeatures;
        private final FilterFactory filterFactory;
        private final GeometryFactory geometryFactory;
        private final AtomicLong totalTime = new AtomicLong();
        private final AtomicInteger resolutionCount = new AtomicInteger();
        private final SpatialIndexFeatureCollection statesSpatialIndex;
        private static final ImmutableMap<String, String> CODES_TO_EBIRD_CODE = ImmutableMap.builder().put("ATC,ATC", "AC").put("ATG,ACA", "AG").put("ATG,ACB", "AG-10").put("PRT,PAZ", "PT-20").put("PNG,PNB", "PG-NSA").put("BEL,BCR", "BE-BRU").put("GBR,ENG", "GB-ENG").put("BIH,BHF", "BA-BIH").put("BEL,BFR", "BE-VLG").put("PSX,GAZ", "PS").put("GEO,GEG", "GE").put("NOR,NJM", "SJ").put("PRT,PMD", "PT-30").put("CYN,CYN", "CY").put("GBR,NIR", "GB-NIR").put("NOR,NOR", "NO").put("PNG,PNX", "PG").put("PRT,PRX", "PT").put("BIH,BIS", "BA-SRP").put("GBR,SCT", "GB-SCT").put("SRB,SRS", "RS").put("KAS,KAS", "IN-JK").put("SOL,SOL", "SO").put("SRB,SRV", "RS-VO").put("GBR,WLS", "GB-WLS").put("BEL,BWR", "BE-WAL").put("PSX,WEB", "PS").put("TZA,TZZ", "TZ").build();
        private static final ImmutableSet<String> COUNTRIES_WITH_STATES = ImmutableSet.of("CA", "US", "AU", "BR");
        private static final double MAX_SEARCH_DISTANCE = 3.3;

        public MapDataImpl(SimpleFeatureCollection mapUnitFeatures, ReferencedEnvelope mapUnitsEnvelope, SimpleFeatureCollection statesFeatures) {
            this.mapUnitFeatures = mapUnitFeatures;
            this.mapUnitEnvelope = mapUnitsEnvelope;
            this.mapUnitSpatialIndex = new SpatialIndexFeatureCollection((SimpleFeatureType)mapUnitFeatures.getSchema());
            this.mapUnitSpatialIndex.addAll(mapUnitFeatures);
            this.statesFeatures = statesFeatures;
            this.statesSpatialIndex = new SpatialIndexFeatureCollection((SimpleFeatureType)statesFeatures.getSchema());
            this.statesSpatialIndex.addAll(statesFeatures);
            this.filterFactory = CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints());
            this.geometryFactory = new GeometryFactory();
        }

        @Override
        public String getISOCode(LatLongCoordinates latLong) {
            long startTime = System.currentTimeMillis();
            String code = this.getEBirdCodeInternal(latLong);
            long endTime = System.currentTimeMillis();
            long currentTotalTime = this.totalTime.addAndGet(endTime - startTime);
            int currentCount = this.resolutionCount.incrementAndGet();
            if (currentCount % 100 == 0) {
                logger.info(String.format("MapData: %d calls, total time %d ms, avg. %f ms", currentCount, currentTotalTime, (double)currentTotalTime / (double)currentCount));
            }
            if ("EC".equals(code) && latLong.longitudeAsDouble() < -85.0) {
                code = "EC-W";
            }
            return code;
        }

        private String getEBirdCodeInternal(LatLongCoordinates latLong) {
            Point p = this.geometryFactory.createPoint(new Coordinate(latLong.longitudeAsDouble(), latLong.latitudeAsDouble()));
            if (!this.mapUnitEnvelope.contains(p.getCoordinate())) {
                return null;
            }
            SimpleFeature feature = this.findFeature(this.mapUnitFeatures, p);
            if (feature == null && (feature = this.findNearestFeatureWithinDistance(this.mapUnitSpatialIndex, p)) == null) {
                return null;
            }
            Property isoA2Property = feature.getProperty("ISO_A2");
            if (isoA2Property == null) {
                throw new IllegalStateException("Missing ISO_A2 property");
            }
            String isoA2 = (String)isoA2Property.getValue();
            if (COUNTRIES_WITH_STATES.contains(isoA2)) {
                SimpleFeature stateFeature = this.findFeature(this.statesFeatures, p);
                if (stateFeature == null) {
                    stateFeature = this.findNearestFeatureWithinDistance(this.statesSpatialIndex, p);
                }
                if (stateFeature != null) {
                    Property iso3166_2Property = stateFeature.getProperty("iso_3166_2");
                    if (iso3166_2Property == null) {
                        throw new IllegalStateException("Missing iso_3166_2 property");
                    }
                    String iso3166_2 = (String)iso3166_2Property.getValue();
                    if ("AU-X02~".equals(iso3166_2)) {
                        return "AU-NSW";
                    }
                    return iso3166_2;
                }
            }
            if ("-99".equals(isoA2)) {
                Property adm0a3Property = feature.getProperty("ADM0_A3");
                String adm0a3 = adm0a3Property == null ? "" : (String)adm0a3Property.getValue();
                Property guA3Property = feature.getProperty("GU_A3");
                String guA3 = guA3Property == null ? "" : (String)guA3Property.getValue();
                return CODES_TO_EBIRD_CODE.get(String.format("%s,%s", adm0a3, guA3));
            }
            return isoA2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SimpleFeature findFeature(SimpleFeatureCollection features, Point p) {
            PropertyName propertyName = this.filterFactory.property(((SimpleFeatureType)features.getSchema()).getGeometryDescriptor().getName());
            Contains filter = this.filterFactory.contains(propertyName, this.filterFactory.literal(p));
            SimpleFeatureCollection sub = features.subCollection(filter);
            if (sub.size() > 0) {
                try (SimpleFeatureIterator featureIterator = sub.features();){
                    if (featureIterator.hasNext()) {
                        SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
                        return simpleFeature;
                    }
                }
            }
            return null;
        }

        private SimpleFeature findNearestFeatureWithinDistance(SpatialIndexFeatureCollection spatialIndex, Point p) {
            Coordinate coordinate = p.getCoordinate();
            ReferencedEnvelope search = new ReferencedEnvelope(new Envelope(coordinate), spatialIndex.getSchema().getCoordinateReferenceSystem());
            search.expandBy(3.3);
            BBOX bbox = this.filterFactory.bbox((Expression)this.filterFactory.property(spatialIndex.getSchema().getGeometryDescriptor().getName()), search);
            SimpleFeatureCollection candidates = spatialIndex.subCollection(bbox);
            SimpleFeature lastMatched = null;
            double minDist = 3.300001;
            try (SimpleFeatureIterator itr = candidates.features();){
                while (itr.hasNext()) {
                    LinearLocation here;
                    SimpleFeature feature = (SimpleFeature)itr.next();
                    LocationIndexedLine line = new LocationIndexedLine(((MultiPolygon)feature.getDefaultGeometry()).getBoundary());
                    Coordinate point = line.extractPoint(here = line.project(coordinate));
                    double dist = point.distance(coordinate);
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    lastMatched = feature;
                }
            }
            return lastMatched;
        }
    }

    static class ThrowingMapData
    extends MapData {
        private final RuntimeException e;

        ThrowingMapData(RuntimeException e) {
            this.e = e;
        }

        @Override
        public String getISOCode(LatLongCoordinates latLong) {
            throw this.e;
        }
    }
}

