/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.base.CharMatcher;
import com.scythebill.birdlist.model.io.ResponseWriter;
import java.io.IOException;
import java.io.Writer;

public class XmlResponseWriter
extends ResponseWriter {
    private final Writer out;
    private static final CharMatcher INVALID_LOW_XML_CHARACTERS = CharMatcher.inRange('\u0000', '\b').or(CharMatcher.inRange('\u000b', '\f')).or(CharMatcher.inRange('\u000e', '\u001f'));
    private final String encoding;
    private boolean closeStart;

    public XmlResponseWriter(Writer writer, String encoding) {
        this.out = writer;
        this.encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return "text/xml";
    }

    @Override
    public void startDocument() throws IOException {
        this.out.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.out.write(" encoding=\"" + this.encoding + "\"");
        }
        this.out.write("?>");
        this.out.write(System.getProperty("line.separator"));
    }

    @Override
    public void endDocument() throws IOException {
    }

    @Override
    public void startElement(String name, Object objectFor) throws IOException {
        this.closeStartIfNecessary();
        this.out.write(60);
        this.out.write(name);
        this.closeStart = true;
    }

    @Override
    public void writeAttribute(String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        this.out.write(32);
        this.out.write(name);
        this.out.write("=\"");
        this.writeAttributeText(value);
        this.out.write("\"");
    }

    @Override
    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this.closeStartIfNecessary();
            this.out.write("<!-- ");
            this.out.write(comment.toString());
            this.out.write(" -->");
        }
    }

    @Override
    public void writeText(char[] buffer, int offset, int length) throws IOException {
        if (buffer != null && buffer.length > 0) {
            this.closeStartIfNecessary();
            this._writeBodyText(buffer, offset, length);
        }
    }

    @Override
    public void writeText(Object text) throws IOException {
        String str;
        if (text != null && !(str = text.toString()).isEmpty()) {
            this.closeStartIfNecessary();
            this.writeBodyText(str);
        }
    }

    @Override
    public void endElement(String name) throws IOException {
        if (this.closeStart) {
            this.out.write("/>");
            this.closeStart = false;
        } else {
            this.out.write("</");
            this.out.write(name);
            this.out.write(">");
        }
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        return new XmlResponseWriter(writer, this.getCharacterEncoding());
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.closeStartIfNecessary();
            this.out.write(cbuf, off, len);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        if (cbuf.length > 0) {
            this.closeStartIfNecessary();
            this.out.write(cbuf);
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this.out.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        if (!str.isEmpty()) {
            this.closeStartIfNecessary();
            this.out.write(str);
        }
    }

    @Override
    public void writeRawText(String text) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            this.out.write(text);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        if (len > 0) {
            this.closeStartIfNecessary();
            this.out.write(str, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    protected void writeAttributeText(Object text) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeAttributeText(buffer, 0, buffer.length);
    }

    protected void writeBodyText(Object text) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeBodyText(buffer, 0, buffer.length);
    }

    protected void closeStartIfNecessary() throws IOException {
        if (this.closeStart) {
            this.out.write(62);
            this.closeStart = false;
        }
    }

    private void _writeAttributeText(char[] text, int start, int length) throws IOException {
        int end = start + length;
        block7: for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u007f') {
                switch (ch) {
                    case '>': {
                        this.out.write("&gt;");
                        break;
                    }
                    case '<': {
                        this.out.write("&lt;");
                        break;
                    }
                    case '\"': {
                        this.out.write("&quot;");
                        break;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        break;
                    }
                    case '\t': {
                        this.out.write("&#x9;");
                        break;
                    }
                    default: {
                        if (INVALID_LOW_XML_CHARACTERS.matches(ch)) continue block7;
                        this.out.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                int codePoint = Character.codePointAt(text, i);
                this._writeHexRef(codePoint);
                ++i;
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    private void _writeBodyText(char[] text, int start, int length) throws IOException {
        int end = start + length;
        block6: for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch < '\u007f') {
                switch (ch) {
                    case '>': {
                        this.out.write("&gt;");
                        break;
                    }
                    case '<': {
                        this.out.write("&lt;");
                        break;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        break;
                    }
                    case '\t': {
                        this.out.write("&#x9;");
                        break;
                    }
                    default: {
                        if (INVALID_LOW_XML_CHARACTERS.matches(ch)) continue block6;
                        this.out.write(ch);
                        break;
                    }
                }
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                int codePoint = Character.codePointAt(text, i);
                this._writeHexRef(codePoint);
                ++i;
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    private void _writeHexRef(int ch) throws IOException {
        this.out.write("&#x");
        this.out.write(Integer.toHexString(ch));
        this.out.write(59);
    }
}

