/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.base.CharMatcher;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;

public class TimeIO {
    private static final GJChronology GJ_CHRONOLOGY = GJChronology.getInstance();
    private static DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("H").appendLiteral(':').appendPattern("mm").toFormatter().withChronology(IsoChronology.INSTANCE);
    private static DateTimeFormatter TIME_FORMATTER_WITH_SECONDS = new DateTimeFormatterBuilder().appendPattern("H").appendLiteral(':').appendPattern("mm").appendLiteral(':').appendPattern("ss").toFormatter().withChronology(IsoChronology.INSTANCE);
    private static DateTimeFormatter TWELVE_HOUR = new DateTimeFormatterBuilder().appendPattern("h").appendLiteral(':').appendPattern("mm").optionalStart().appendLiteral(' ').optionalEnd().appendPattern("a").toFormatter().withLocale(Locale.US).withChronology(IsoChronology.INSTANCE);
    private static DateTimeFormatter TWELVE_HOUR_WITH_SECONDS = new DateTimeFormatterBuilder().appendPattern("h").appendLiteral(':').appendPattern("mm").appendLiteral(':').appendPattern("ss").optionalStart().appendLiteral(' ').optionalEnd().appendPattern("a").toFormatter().withLocale(Locale.US).withChronology(IsoChronology.INSTANCE);
    private static final CharMatcher COLON = CharMatcher.is(':');

    public static void main(String[] args) {
        System.err.println(TimeIO.fromString("11:59"));
        System.err.println(TimeIO.fromExternalString("12:59 PM"));
        System.err.println(TimeIO.toString(TimeIO.fromString("11:59")));
    }

    public static String toString(ReadablePartial p) {
        if (!p.isSupported(DateTimeFieldType.hourOfDay())) {
            return "";
        }
        int hour = p.get(DateTimeFieldType.hourOfDay());
        int minute = p.isSupported(DateTimeFieldType.minuteOfHour()) ? p.get(DateTimeFieldType.minuteOfHour()) : 0;
        return String.format("%02d:%02d", hour, minute);
    }

    public static String toFileString(ReadablePartial p) {
        if (!p.isSupported(DateTimeFieldType.hourOfDay())) {
            return "";
        }
        int hour = p.get(DateTimeFieldType.hourOfDay());
        int minute = p.isSupported(DateTimeFieldType.minuteOfHour()) ? p.get(DateTimeFieldType.minuteOfHour()) : 0;
        return String.format("%02d%02d", hour, minute);
    }

    public static LocalTime fromString(String string) {
        try {
            return TimeIO.parse(string, TIME_FORMATTER);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static LocalTime fromExternalString(String string) {
        int decimal = string.indexOf(46);
        if (decimal >= 0) {
            string = string.substring(0, decimal);
        }
        LocalTime time = string.endsWith("AM") || string.endsWith("PM") ? (COLON.countIn(string) > 1 ? TimeIO.parse(string, TWELVE_HOUR_WITH_SECONDS) : TimeIO.parse(string, TWELVE_HOUR)) : (COLON.countIn(string) > 1 ? TimeIO.parse(string, TIME_FORMATTER_WITH_SECONDS) : TimeIO.parse(string, TIME_FORMATTER));
        return time;
    }

    public static String toShortUserString(ReadablePartial startTime, Locale locale) {
        if (!startTime.isSupported(DateTimeFieldType.hourOfDay())) {
            return null;
        }
        int hour = startTime.get(DateTimeFieldType.hourOfDay());
        int minute = startTime.isSupported(DateTimeFieldType.minuteOfHour()) ? startTime.get(DateTimeFieldType.minuteOfHour()) : 0;
        LocalTime localTime = new LocalTime(hour, minute, 0, 0, GJ_CHRONOLOGY);
        return DateTimeFormat.shortTime().print(localTime);
    }

    public static LocalTime normalize(LocalTime time) {
        return new LocalTime(time.getHourOfDay(), time.getMinuteOfHour(), 0, 0, GJ_CHRONOLOGY);
    }

    private static LocalTime parse(String string, DateTimeFormatter formatter) {
        try {
            return TimeIO.fromJavaTime(java.time.LocalTime.parse(string, formatter));
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static LocalTime fromJavaTime(java.time.LocalTime javaTime) {
        return new LocalTime(javaTime.getHour(), javaTime.getMinute(), 0, 0, GJ_CHRONOLOGY);
    }
}

