/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends InputStream {
    private final InputStream delegate;
    private long count = 0L;

    public ProgressInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public synchronized long getCurrentPosition() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.incrementCount(this.delegate.read(b, off, len));
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.incrementCount(this.delegate.read(b));
    }

    @Override
    public long skip(long n) throws IOException {
        return this.incrementCount(this.delegate.skip(n));
    }

    @Override
    public int read() throws IOException {
        int readByte = this.delegate.read();
        this.incrementCount(1);
        return readByte;
    }

    private synchronized int incrementCount(int bytesRead) {
        this.count += (long)bytesRead;
        return bytesRead;
    }

    private synchronized long incrementCount(long bytesRead) {
        this.count += bytesRead;
        return bytesRead;
    }
}

