/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Partial;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.GJChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatterBuilder;

public class PartialIO {
    private static final GJChronology GJ_CHRONOLOGY = GJChronology.getInstance();
    private static final char SEPARATOR = '-';
    private static Map<Character, DateTimeFieldType> ABBREVIATIONS_TO_FIELD = PartialIO.createAbbreviationsToFieldMap();
    private static Map<String, Character> FIELD_ABBREVIATIONS = PartialIO.createFieldAbbreviationsMap();
    private static Map<DateTimeFieldType, DateTimeFieldType> NEXT_FIELD_MAP = PartialIO.createNextFieldMap();
    private static final Pattern YEAR_MONTH_DAY = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");

    public static String toUserString(ReadablePartial p, Locale locale) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        if (p.isSupported(DateTimeFieldType.dayOfMonth())) {
            builder.appendDayOfMonth(1);
            builder.appendLiteral(' ');
        }
        if (p.isSupported(DateTimeFieldType.monthOfYear())) {
            builder.appendShortText(DateTimeFieldType.monthOfYear());
            builder.appendLiteral(' ');
        }
        if (p.isSupported(DateTimeFieldType.year())) {
            builder.appendYear(2, 2);
        }
        StringBuffer buffer = new StringBuffer();
        builder.toPrinter().printTo(buffer, p, locale);
        return buffer.toString();
    }

    public static String toShortUserString(ReadablePartial p, Locale locale) {
        DateTimeFormatterBuilder builder;
        if (p.isSupported(DateTimeFieldType.dayOfMonth())) {
            if (p.isSupported(DateTimeFieldType.monthOfYear()) && p.isSupported(DateTimeFieldType.year())) {
                return DateTimeFormat.shortDate().withLocale(locale).print(p);
            }
            builder = new DateTimeFormatterBuilder();
            builder.appendDayOfMonth(1);
            builder.appendLiteral('/');
            if (p.isSupported(DateTimeFieldType.monthOfYear())) {
                builder.appendMonthOfYear(1);
            }
            builder.appendLiteral('/');
            if (p.isSupported(DateTimeFieldType.year())) {
                builder.appendYear(2, 4);
            }
        } else {
            builder = new DateTimeFormatterBuilder();
            boolean hasField = false;
            if (p.isSupported(DateTimeFieldType.monthOfYear())) {
                builder.appendMonthOfYear(1);
                builder.appendLiteral('/');
                hasField = true;
            }
            if (p.isSupported(DateTimeFieldType.year())) {
                builder.appendYear(2, 4);
                hasField = true;
            }
            if (!hasField) {
                return "";
            }
        }
        StringBuffer buffer = new StringBuffer();
        builder.toPrinter().printTo(buffer, p, locale);
        return buffer.toString();
    }

    public static String toString(ReadablePartial p) {
        StringBuilder builder = new StringBuilder(p.size() * 4);
        DateTimeFieldType lastType = null;
        for (int i = 0; i < p.size(); ++i) {
            if (i != 0) {
                builder.append('-');
            }
            DateTimeFieldType type = p.getFieldType(i);
            int value = p.getValue(i);
            if (type != NEXT_FIELD_MAP.get(lastType)) {
                Character abbrev = FIELD_ABBREVIATIONS.get(type.getName());
                if (abbrev == null) {
                    throw new IllegalArgumentException("Field type " + type + " not supported.");
                }
                builder.append(abbrev);
            }
            Preconditions.checkArgument(value >= 0);
            if (value < 10) {
                builder.append('0');
            }
            builder.append(value);
            lastType = type;
        }
        return builder.toString();
    }

    private static ReadablePartial fromYearMonthDayString(String string) {
        int year = Integer.parseUnsignedInt(string.substring(0, 4));
        int month = Integer.parseUnsignedInt(string.substring(5, 7));
        int day = Integer.parseUnsignedInt(string.substring(8));
        return new LocalDate(year, month, day, GJ_CHRONOLOGY);
    }

    public static ReadablePartial fromString(String string) {
        if (YEAR_MONTH_DAY.matcher(string).matches()) {
            return PartialIO.fromYearMonthDayString(string);
        }
        Partial p = new Partial(GJ_CHRONOLOGY);
        DateTimeFieldType lastType = null;
        DateTimeFieldType currentType = null;
        int length = string.length();
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            if (ch >= '0' && ch <= '9') {
                if (currentType == null && (currentType = NEXT_FIELD_MAP.get(lastType)) == null) {
                    throw new IllegalArgumentException("Couldn't guess type of field in " + string);
                }
                Preconditions.checkArgument(p.indexOf(currentType) < 0);
                int separatorIndex = string.indexOf(45, i);
                if (separatorIndex < 0) {
                    separatorIndex = length;
                }
                String numString = string.substring(i, separatorIndex);
                try {
                    int value = Integer.parseInt(numString);
                    p = p.with(currentType, value);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Couldn't parse field in " + string, nfe);
                }
                lastType = currentType;
                currentType = null;
                i = separatorIndex + 1;
                continue;
            }
            if (currentType != null) {
                throw new IllegalArgumentException("Invalid syntax in " + string);
            }
            currentType = ABBREVIATIONS_TO_FIELD.get(Character.valueOf(ch));
            if (currentType == null) {
                throw new IllegalArgumentException("Abbreviation '" + ch + "' not understood  in " + string);
            }
            if (++i != length) continue;
            throw new IllegalArgumentException("Invalid syntax in " + string);
        }
        return p;
    }

    private static Map<Character, DateTimeFieldType> createAbbreviationsToFieldMap() {
        ImmutableMap.Builder<Character, DateTimeFieldType> builder = ImmutableMap.builder();
        builder.put(Character.valueOf('y'), DateTimeFieldType.year()).put(Character.valueOf('M'), DateTimeFieldType.monthOfYear()).put(Character.valueOf('d'), DateTimeFieldType.dayOfMonth()).put(Character.valueOf('h'), DateTimeFieldType.hourOfDay()).put(Character.valueOf('m'), DateTimeFieldType.minuteOfHour()).put(Character.valueOf('s'), DateTimeFieldType.secondOfMinute());
        return builder.build();
    }

    private static Map<String, Character> createFieldAbbreviationsMap() {
        ImmutableMap.Builder<String, Character> builder = ImmutableMap.builder();
        for (Map.Entry<Character, DateTimeFieldType> entry : ABBREVIATIONS_TO_FIELD.entrySet()) {
            builder.put(entry.getValue().getName(), entry.getKey());
        }
        return builder.build();
    }

    private static Map<DateTimeFieldType, DateTimeFieldType> createNextFieldMap() {
        HashMap<DateTimeFieldType, DateTimeFieldType> map = Maps.newHashMap();
        map.put(null, DateTimeFieldType.year());
        map.put(DateTimeFieldType.year(), DateTimeFieldType.monthOfYear());
        map.put(DateTimeFieldType.monthOfYear(), DateTimeFieldType.dayOfMonth());
        map.put(DateTimeFieldType.dayOfMonth(), DateTimeFieldType.hourOfDay());
        map.put(DateTimeFieldType.hourOfDay(), DateTimeFieldType.minuteOfHour());
        map.put(DateTimeFieldType.minuteOfHour(), DateTimeFieldType.secondOfMinute());
        map.put(DateTimeFieldType.secondOfMinute(), null);
        return Collections.unmodifiableMap(map);
    }
}

