/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.base.Preconditions;
import com.scythebill.birdlist.model.io.ImportLines;
import java.io.IOException;

public abstract class MergingImportLines
implements ImportLines {
    private final ImportLines importLines;
    private String[] readAhead = null;
    private boolean needToSkipOneMerge;

    protected MergingImportLines(ImportLines importLines) {
        this.importLines = importLines;
        this.needToSkipOneMerge = this.neverMergeFirstLine();
    }

    @Override
    public void close() throws IOException {
        this.importLines.close();
    }

    @Override
    public ImportLines withoutTrimming() {
        this.importLines.withoutTrimming();
        return this;
    }

    @Override
    public int lineNumber() {
        return this.importLines.lineNumber();
    }

    @Override
    public String[] nextLine() throws IOException {
        String[] line;
        if (this.needToSkipOneMerge) {
            this.needToSkipOneMerge = false;
            return this.nextLineInternal();
        }
        String[] mergedLine = null;
        while (true) {
            if ((line = this.readAhead()) == null) {
                return mergedLine;
            }
            if (mergedLine == null) {
                mergedLine = line;
                continue;
            }
            if (!this.merge(mergedLine, line)) break;
        }
        this.pushBack(line);
        return mergedLine;
    }

    protected abstract boolean merge(String[] var1, String[] var2);

    protected String[] nextLineInternal() throws IOException {
        return this.importLines.nextLine();
    }

    private String[] readAhead() throws IOException {
        if (this.readAhead != null) {
            String[] temp = this.readAhead;
            this.readAhead = null;
            return temp;
        }
        return this.nextLineInternal();
    }

    protected boolean neverMergeFirstLine() {
        return true;
    }

    private void pushBack(String[] nextLine) {
        Preconditions.checkState(this.readAhead == null, "Already have line in readAhead");
        this.readAhead = nextLine;
    }
}

