/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.scythebill.birdlist.model.io.ResponseWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentingResponseWriter
extends ResponseWriter {
    private ResponseWriter decorated;
    private boolean justEndedElement;
    private int elementDepth;
    private int spacesPer;
    private static final int MAX_INDENT = 50;
    private static final int DEFAULT_SPACES_PER_LEVEL = 2;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final char[] spaces = new char[50];

    public IndentingResponseWriter(ResponseWriter decorated) {
        this(decorated, 2);
    }

    public IndentingResponseWriter(ResponseWriter decorated, int spacesPerLevel) {
        this.decorated = decorated;
        this.spacesPer = spacesPerLevel;
    }

    protected ResponseWriter getResponseWriter() {
        return this.decorated;
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        return new IndentingResponseWriter(this.getResponseWriter().cloneWithWriter(writer));
    }

    @Override
    public void startElement(String name, Object objectFor) throws IOException {
        int depth;
        if ((depth = this.elementDepth++) > 0) {
            this._writeIndent(depth);
        }
        this.justEndedElement = false;
        this.getResponseWriter().startElement(name, objectFor);
    }

    @Override
    public void endElement(String name) throws IOException {
        --this.elementDepth;
        this._seeIfJustEndedElement();
        this.getResponseWriter().endElement(name);
        this.justEndedElement = true;
    }

    @Override
    public void writeComment(Object comment) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().writeComment(comment);
        this.getResponseWriter().writeText(LINE_SEPARATOR);
    }

    @Override
    public void writeText(Object text) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().writeText(text);
    }

    @Override
    public void writeText(char[] text, int start, int length) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().writeText(text, start, length);
    }

    @Override
    public void write(String text) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().write(text);
    }

    @Override
    public void write(char[] text, int start, int length) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().write(text, start, length);
    }

    @Override
    public void write(int c) throws IOException {
        this._seeIfJustEndedElement();
        this.getResponseWriter().write(c);
    }

    @Override
    public void writeRawText(String text) throws IOException {
        this.getResponseWriter().writeRawText(text);
    }

    @Override
    public void endDocument() throws IOException {
        this.getResponseWriter().endDocument();
    }

    @Override
    public void startDocument() throws IOException {
        this.getResponseWriter().startDocument();
    }

    @Override
    public void writeAttribute(String name, Object value) throws IOException {
        this.getResponseWriter().writeAttribute(name, value);
    }

    @Override
    public void close() throws IOException {
        this.getResponseWriter().close();
    }

    @Override
    public void flush() throws IOException {
        this.getResponseWriter().flush();
    }

    private void _seeIfJustEndedElement() throws IOException {
        if (this.justEndedElement) {
            this.justEndedElement = false;
            this._writeIndent(this.elementDepth);
        }
    }

    private void _writeIndent(int depth) throws IOException {
        if ((depth *= this.spacesPer) > 50) {
            depth = 50;
        }
        this.getResponseWriter().write(LINE_SEPARATOR);
        if (depth > 0) {
            this.getResponseWriter().write(spaces, 0, depth);
        }
    }

    static {
        for (int i = 0; i < 50; ++i) {
            IndentingResponseWriter.spaces[i] = 32;
        }
    }
}

