/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.html.HtmlEscapers;
import com.scythebill.birdlist.model.io.ResponseWriter;
import java.io.IOException;
import java.io.Writer;

public class HtmlResponseWriter
extends ResponseWriter {
    private static final String[][] emptyElementArr = new String[256][];
    private static final String[] aNames = new String[]{"area"};
    private static final String[] bNames = new String[]{"br", "base", "basefont"};
    private static final String[] cNames = new String[]{"col"};
    private static final String[] fNames = new String[]{"frame"};
    private static final String[] hNames = new String[]{"hr"};
    private static final String[] iNames = new String[]{"img", "input", "isindex"};
    private static final String[] lNames = new String[]{"link"};
    private static final String[] mNames = new String[]{"meta"};
    private static final String[] pNames = new String[]{"param"};
    private final Writer _out;
    private final String _encoding;
    private boolean _closeStart;

    public HtmlResponseWriter(Writer writer, String encoding) {
        this._out = writer;
        this._encoding = encoding;
    }

    public String getCharacterEncoding() {
        return this._encoding;
    }

    public String getContentType() {
        return "text/html";
    }

    @Override
    public void startDocument() throws IOException {
        this._out.write("<!DOCTYPE html>");
        this._out.write(System.getProperty("line.separator"));
    }

    @Override
    public void endDocument() throws IOException {
    }

    @Override
    public void startElement(String name, Object objectFor) throws IOException {
        this.closeStartIfNecessary();
        Writer out = this._out;
        out.write(60);
        out.write(name);
        this._closeStart = true;
    }

    @Override
    public void writeAttribute(String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        Writer out = this._out;
        out.write(32);
        out.write(name);
        out.write("=\"");
        this.writeAttributeText(value);
        out.write("\"");
    }

    @Override
    public void writeComment(Object comment) throws IOException {
        if (comment != null) {
            this.closeStartIfNecessary();
            Writer out = this._out;
            out.write("<!-- ");
            out.write(comment.toString());
            out.write(" -->");
        }
    }

    @Override
    public void writeText(char[] buffer, int offset, int length) throws IOException {
        if (buffer != null) {
            this.closeStartIfNecessary();
            this._writeBodyText(buffer, offset, length);
        }
    }

    @Override
    public void writeText(Object text) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            this.writeBodyText(text);
        }
    }

    @Override
    public void writeRawText(String text) throws IOException {
        if (text != null) {
            this.closeStartIfNecessary();
            this._out.write(text);
        }
    }

    @Override
    public void endElement(String name) throws IOException {
        Writer out = this._out;
        if (this._closeStart) {
            out.write(62);
            this._closeStart = false;
            boolean isEmptyElement = HtmlResponseWriter._isEmptyElement(name);
            if (isEmptyElement) {
                return;
            }
        }
        out.write("</");
        out.write(name);
        out.write(">");
    }

    @Override
    public ResponseWriter cloneWithWriter(Writer writer) {
        return new HtmlResponseWriter(writer, this.getCharacterEncoding());
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf, off, len);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(cbuf);
    }

    @Override
    public void write(int c) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.closeStartIfNecessary();
        this._out.write(str, off, len);
    }

    @Override
    public void close() throws IOException {
        this._out.close();
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    protected void writeAttributeText(Object text) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeAttributeText(buffer, 0, buffer.length);
    }

    protected void writeBodyText(Object text) throws IOException {
        char[] buffer = text.toString().toCharArray();
        this._writeBodyText(buffer, 0, buffer.length);
    }

    protected void closeStartIfNecessary() throws IOException {
        if (this._closeStart) {
            Writer out = this._out;
            out.write(62);
            this._closeStart = false;
        }
    }

    private void _writeAttributeText(char[] text, int start, int length) throws IOException {
        Writer out = this._out;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                switch (ch) {
                    case '>': {
                        out.write("&gt;");
                        break;
                    }
                    case '<': {
                        out.write("&lt;");
                        break;
                    }
                    case '\"': {
                        out.write("&quot;");
                        break;
                    }
                    case '&': {
                        out.write("&amp;");
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    public static String htmlEscape(String text) {
        return HtmlEscapers.htmlEscaper().escape(text);
    }

    private void _writeBodyText(char[] text, int start, int length) throws IOException {
        Writer out = this._out;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u007f') {
                switch (ch) {
                    case '>': {
                        out.write("&gt;");
                        break;
                    }
                    case '<': {
                        out.write("&lt;");
                        break;
                    }
                    case '&': {
                        out.write("&amp;");
                        break;
                    }
                    default: {
                        out.write(ch);
                        break;
                    }
                }
                continue;
            }
            this._writeHexRef(ch);
        }
    }

    private void _writeHexRef(char ch) throws IOException {
        Writer out = this._out;
        out.write("&#x");
        out.write(Integer.toHexString(ch));
        out.write(59);
    }

    private static boolean _isEmptyElement(String name) {
        String[] array = emptyElementArr[name.charAt(0)];
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        HtmlResponseWriter.emptyElementArr[97] = aNames;
        HtmlResponseWriter.emptyElementArr[65] = aNames;
        HtmlResponseWriter.emptyElementArr[98] = bNames;
        HtmlResponseWriter.emptyElementArr[66] = bNames;
        HtmlResponseWriter.emptyElementArr[99] = cNames;
        HtmlResponseWriter.emptyElementArr[67] = cNames;
        HtmlResponseWriter.emptyElementArr[102] = fNames;
        HtmlResponseWriter.emptyElementArr[70] = fNames;
        HtmlResponseWriter.emptyElementArr[104] = hNames;
        HtmlResponseWriter.emptyElementArr[72] = hNames;
        HtmlResponseWriter.emptyElementArr[105] = iNames;
        HtmlResponseWriter.emptyElementArr[73] = iNames;
        HtmlResponseWriter.emptyElementArr[108] = lNames;
        HtmlResponseWriter.emptyElementArr[76] = lNames;
        HtmlResponseWriter.emptyElementArr[109] = mNames;
        HtmlResponseWriter.emptyElementArr[77] = mNames;
        HtmlResponseWriter.emptyElementArr[112] = pNames;
        HtmlResponseWriter.emptyElementArr[80] = pNames;
    }
}

