/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import com.opencsv.CSVReader;
import com.opencsv.CSVReaderBuilder;
import com.opencsv.exceptions.CsvValidationException;
import com.scythebill.birdlist.model.io.ClonedCsvReader;
import com.scythebill.birdlist.model.io.ImportLines;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashSet;
import org.apache.commons.io.input.BOMInputStream;

public class CsvImportLines {
    public static ImportLines fromFile(File file, Charset charset) throws IOException {
        if (file.getName().endsWith(".zip")) {
            LinkedHashSet paths = new LinkedHashSet();
            FileSystems.newFileSystem(file.toPath(), ImmutableMap.of()).getRootDirectories().forEach(root -> {
                try {
                    Files.walk(root, new FileVisitOption[0]).filter(path -> path.toString().endsWith(".csv")).forEach(path -> paths.add(path));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            });
            if (paths.isEmpty()) {
                throw new IOException(".zip file does not contain any .csv files.");
            }
            if (paths.size() > 1) {
                throw new IOException(".zip file contains multiple .csv files.");
            }
            return new OpenCsvImportLines(Files.newInputStream((Path)Iterables.getOnlyElement(paths), new OpenOption[0]), charset);
        }
        return new OpenCsvImportLines(new FileInputStream(file), charset);
    }

    public static ImportLines fromUrl(URL url, Charset charset) throws IOException {
        return new OpenCsvImportLines(url.openStream(), charset);
    }

    public static ImportLines fromReader(Reader reader) throws IOException {
        return new OpenCsvImportLines(reader);
    }

    public static ImportLines fromReader(CSVReader csvReader) {
        return new OpenCsvImportLines(csvReader);
    }

    public static ImportLines fromFileNoMulti(File file, Charset charset) throws IOException {
        ClonedCsvReader reader = new ClonedCsvReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), charset), ',', '\"', '\u0000');
        reader.disableMultiLineReads();
        return new ClonedCsvImportLines(reader);
    }

    public static ImportLines fromFileNoMultiIgnoringQuotesNotFollowedBySeparators(File file, Charset charset) throws IOException {
        ClonedCsvReader reader = new ClonedCsvReader((Reader)new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(file)), charset), ',', '\"', '\u0000');
        reader.disableMultiLineReads();
        reader.ignoreQuotesNotFollowedBySeparator();
        return new ClonedCsvImportLines(reader);
    }

    static class OpenCsvImportLines
    extends AbstractImportLines {
        private final CSVReader csvReader;
        private int lineNumber = 0;

        private OpenCsvImportLines(InputStream stream, Charset charset) throws IOException {
            this.csvReader = OpenCsvImportLines.fromBufferedReader(new InputStreamReader((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(new BufferedInputStream(stream))).get(), charset));
        }

        private OpenCsvImportLines(Reader reader) throws IOException {
            this.csvReader = OpenCsvImportLines.fromBufferedReader(new BufferedReader(reader));
        }

        protected OpenCsvImportLines(CSVReader csvReader) {
            this.csvReader = csvReader;
        }

        @Override
        public void close() throws IOException {
            this.csvReader.close();
        }

        @Override
        protected String[] readNext() throws IOException, CsvValidationException {
            ++this.lineNumber;
            return this.csvReader.readNext();
        }

        @Override
        public int lineNumber() {
            return this.lineNumber;
        }

        private static CSVReader fromBufferedReader(Reader reader) {
            CSVParser parser = new CSVParserBuilder().withSeparator(',').withQuoteChar('\"').withEscapeChar('\u0000').build();
            return new CSVReaderBuilder(reader).withCSVParser(parser).build();
        }
    }

    static class ClonedCsvImportLines
    extends AbstractImportLines {
        private final ClonedCsvReader reader;
        private int lineNumber = 0;

        ClonedCsvImportLines(ClonedCsvReader reader) {
            this.reader = reader;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        protected String[] readNext() throws IOException {
            ++this.lineNumber;
            return this.reader.readNext();
        }

        @Override
        public int lineNumber() {
            return this.lineNumber;
        }
    }

    static abstract class AbstractImportLines
    implements ImportLines {
        private boolean withoutTrimming;

        AbstractImportLines() {
        }

        @Override
        public String[] nextLine() throws IOException {
            String[] next;
            do {
                try {
                    next = this.readNext();
                }
                catch (CsvValidationException e) {
                    throw new IOException("Invalid CSV", e);
                }
                if (next != null) continue;
                return null;
            } while (this.lineIsEmpty(next));
            if ("\"".equals(next[0])) {
                next[0] = "";
            }
            if (next[0].length() > 0 && next[0].charAt(0) == '\ufeff') {
                next[0] = next[0].substring(1);
            }
            return this.trimWhitespace(next);
        }

        @Override
        public ImportLines withoutTrimming() {
            this.withoutTrimming = true;
            return this;
        }

        protected abstract String[] readNext() throws IOException, CsvValidationException;

        private boolean lineIsEmpty(String[] next) {
            for (String value : next) {
                if (value.isEmpty()) continue;
                return false;
            }
            return true;
        }

        private String[] trimWhitespace(String[] next) {
            if (!this.withoutTrimming) {
                for (int i = 0; i < next.length; ++i) {
                    next[i] = CharMatcher.whitespace().trimFrom(next[i]);
                }
            }
            return next;
        }
    }
}

