/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.opencsv.CSVWriterBuilder;
import com.opencsv.ICSVWriter;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.io.ForceExcelCompatibleOutput;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class CsvExportLines
implements ExportLines {
    private final ICSVWriter csvWriter;

    public static ExportLines fromWriter(Writer writer) throws IOException {
        return new CsvExportLines(writer);
    }

    public static ExportLines toFile(File out, Charset charset) throws IOException {
        return CsvExportLines.fromWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(out)), charset));
    }

    private CsvExportLines(Writer writer) throws IOException {
        this.csvWriter = new CSVWriterBuilder(writer).withSeparator(',').withQuoteChar('\"').withEscapeChar('\"').build();
    }

    @Override
    public void close() throws IOException {
        this.csvWriter.close();
    }

    @Override
    public void nextLine(String[] line) throws IOException {
        if (Arrays.asList(line).contains("")) {
            line = (String[])line.clone();
            for (int i = 0; i < line.length; ++i) {
                if (!"".equals(line[i])) continue;
                line[i] = null;
            }
        }
        this.csvWriter.writeNext(line);
    }

    @Override
    public ExportLines useExcelCompatibleCsv() {
        return new ForceExcelCompatibleOutput(this);
    }
}

