/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.io;

import com.opencsv.stream.reader.LineReader;
import com.scythebill.birdlist.model.io.ClonedCsvParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

class ClonedCsvReader
implements Closeable {
    public static final boolean DEFAULT_KEEP_CR = false;
    public static final boolean DEFAULT_VERIFY_READER = true;
    public static final int DEFAULT_SKIP_LINES = 0;
    public static final int READ_AHEAD_LIMIT = 2;
    private ClonedCsvParser parser;
    private int skipLines;
    private BufferedReader br;
    private LineReader lineReader;
    private boolean hasNext = true;
    private boolean linesSkipped;
    private boolean keepCR;
    private boolean verifyReader;
    private boolean disableMultiLineReads;

    public ClonedCsvReader(Reader reader) {
        this(reader, ',', '\"', '\\');
    }

    public ClonedCsvReader(Reader reader, char separator) {
        this(reader, separator, '\"', '\\');
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, '\\', 0, false);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, boolean strictQuotes) {
        this(reader, separator, quotechar, '\\', 0, strictQuotes);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, char escape) {
        this(reader, separator, quotechar, escape, 0, false);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, int line) {
        this(reader, separator, quotechar, '\\', line, false);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, char escape, int line) {
        this(reader, separator, quotechar, escape, line, false);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes) {
        this(reader, separator, quotechar, escape, line, strictQuotes, true);
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace) {
        this(reader, line, new ClonedCsvParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace));
    }

    public ClonedCsvReader(Reader reader, char separator, char quotechar, char escape, int line, boolean strictQuotes, boolean ignoreLeadingWhiteSpace, boolean keepCR) {
        this(reader, line, new ClonedCsvParser(separator, quotechar, escape, strictQuotes, ignoreLeadingWhiteSpace), keepCR, true);
    }

    public ClonedCsvReader(Reader reader, int line, ClonedCsvParser csvParser) {
        this(reader, line, csvParser, false, true);
    }

    public void disableMultiLineReads() {
        this.disableMultiLineReads = true;
    }

    ClonedCsvReader(Reader reader, int line, ClonedCsvParser csvParser, boolean keepCR, boolean verifyReader) {
        this.br = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.lineReader = new LineReader(this.br, keepCR);
        this.skipLines = line;
        this.parser = csvParser;
        this.keepCR = keepCR;
        this.verifyReader = verifyReader;
    }

    public ClonedCsvParser getParser() {
        return this.parser;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public boolean keepCarriageReturns() {
        return this.keepCR;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String[] result = null;
        do {
            String[] r;
            String nextLine = this.getNextLine();
            if (!this.hasNext) {
                return result;
            }
            String[] stringArray = r = this.disableMultiLineReads ? this.parser.parseLine(nextLine) : this.parser.parseLineMulti(nextLine);
            if (r.length <= 0) continue;
            result = result == null ? r : this.combineResultsFromMultipleReads(result, r);
        } while (this.parser.isPending());
        return result;
    }

    private String[] combineResultsFromMultipleReads(String[] buffer, String[] lastRead) {
        String[] t = new String[buffer.length + lastRead.length];
        System.arraycopy(buffer, 0, t, 0, buffer.length);
        System.arraycopy(lastRead, 0, t, buffer.length, lastRead.length);
        return t;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (this.isClosed()) {
            this.hasNext = false;
            return null;
        }
        if (!this.linesSkipped) {
            for (int i = 0; i < this.skipLines; ++i) {
                this.lineReader.readLine();
            }
            this.linesSkipped = true;
        }
        if ((nextLine = this.lineReader.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    private boolean isClosed() {
        if (!this.verifyReader) {
            return false;
        }
        try {
            this.br.mark(2);
            int nextByte = this.br.read();
            this.br.reset();
            return nextByte == -1;
        }
        catch (IOException e) {
            return true;
        }
    }

    @Override
    public void close() throws IOException {
        this.br.close();
    }

    public boolean verifyReader() {
        return this.verifyReader;
    }

    public void ignoreQuotesNotFollowedBySeparator() {
        this.parser.ignoreQuotesNotFollowedBySeparator();
    }
}

