/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.export;

import com.google.common.base.Joiner;
import com.google.common.io.ByteSink;
import com.scythebill.birdlist.model.export.Exports;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.Taxon;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class INaturalistCsvExport {
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral('-').appendMonthOfYear(2).appendLiteral('-').appendDayOfMonth(2).toFormatter();
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).toFormatter();
    private static final long MAX_ROWS = 9999L;
    private static final String[] COLUMN_HEADERS = new String[]{"Taxon name", "Date observed", "Description", "Place name", "Latitude", "Longitude", "Tags", "Geoprivacy"};
    private static final int TOTAL_COLUMN_COUNT = COLUMN_HEADERS.length;
    private static final int COLUMN_TAXON_NAME = 0;
    private static final int COLUMN_DATE = 1;
    private static final int COLUMN_DESCRIPTION = 2;
    private static final int COLUMN_PLACE_NAME = 3;
    private static final int COLUMN_LATITUDE = 4;
    private static final int COLUMN_LONGITUDE = 5;
    private static final int COLUMN_TAGS = 6;
    private static final int COLUMN_GEOPRIVACY = 7;
    private boolean useExcelCompatibleCsv;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSpeciesList(ByteSink outSupplier, Iterator<SightingTaxon.Resolved> taxonIterator, QueryResults queryResults, ReportSet reportSet) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outSupplier.openStream(), StandardCharsets.UTF_8), 10240);
        ExportLines exportLines = CsvExportLines.fromWriter(out);
        if (this.useExcelCompatibleCsv) {
            exportLines = exportLines.useExcelCompatibleCsv();
        }
        try {
            this.writeSpeciesList(exportLines, taxonIterator, queryResults, reportSet);
        }
        finally {
            exportLines.close();
        }
    }

    private static boolean isValidDate(ReadablePartial partial) {
        return partial != null && partial.isSupported(DateTimeFieldType.year()) && partial.isSupported(DateTimeFieldType.monthOfYear()) && partial.isSupported(DateTimeFieldType.dayOfMonth());
    }

    private void writeSpeciesList(ExportLines exportLines, Iterator<SightingTaxon.Resolved> taxonIterator, QueryResults queryResults, ReportSet reportSet) throws IOException {
        exportLines.nextLine(COLUMN_HEADERS);
        int rowCount = 0;
        while (taxonIterator.hasNext()) {
            SightingTaxon.Resolved taxon = taxonIterator.next();
            Collection<Sighting> taxonSightings = queryResults.getAllSightings(taxon);
            for (Sighting sighting : taxonSightings) {
                String[] line = new String[TOTAL_COLUMN_COUNT];
                if (taxon.getLargestTaxonType() == Taxon.Type.group && !taxon.getTaxa().iterator().next().getContents().isEmpty()) {
                    taxon = taxon.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxon.getTaxonomy());
                }
                line[0] = taxon.getFullName();
                ArrayList<String> names = new ArrayList<String>();
                if (sighting.getLocationId() != null) {
                    Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
                    if (location.isPrivate()) continue;
                    Location state = Locations.getAncestorOfType(location, Location.Type.state);
                    Location country = Locations.getAncestorOfType(location, Location.Type.country);
                    Location city = Locations.getAncestorOfType(location, Location.Type.city);
                    Location town = Locations.getAncestorOfType(location, Location.Type.town);
                    names.add(Locations.getGroupedLocationDisplayName(location));
                    if (town != null && town != location) {
                        names.add(town.getDisplayName());
                    }
                    if (city != null && city != location) {
                        names.add(city.getDisplayName());
                    }
                    if (state != null && state != location) {
                        names.add(state.getDisplayName());
                    }
                    if (country != null && country != location) {
                        names.add(country.getDisplayName());
                    }
                    line[3] = Joiner.on(", ").join(names);
                    if (location.getLatLong().isPresent()) {
                        LatLongCoordinates latLong = location.getLatLong().get();
                        line[4] = String.format(Locale.US, "%2.4f", latLong.latitudeAsDouble());
                        line[5] = String.format(Locale.US, "%2.4f", latLong.longitudeAsDouble());
                    }
                }
                if (INaturalistCsvExport.isValidDate(sighting.getStoredDateAsPartial())) {
                    line[1] = DATE_FORMATTER.print(sighting.getStoredDateAsPartial());
                    if (sighting.getStoredTimeAsPartial() != null) {
                        line[1] = line[1] + " " + TIME_FORMATTER.print(sighting.getStoredTimeAsPartial());
                    }
                }
                if (sighting.hasSightingInfo()) {
                    SightingInfo sightingInfo = sighting.getSightingInfo();
                    if (sightingInfo.getDescription() != null) {
                        line[2] = Exports.trimLatLongFromDescription(this.replaceDisallowedCharacters(sightingInfo.getDescription()));
                        LatLongCoordinates latLong = Exports.returnLatLongFromDescription(sightingInfo.getDescription());
                        if (latLong != null) {
                            line[4] = String.format(Locale.US, "%2.4f", latLong.latitudeAsDouble());
                            line[5] = String.format(Locale.US, "%2.4f", latLong.longitudeAsDouble());
                        }
                    }
                    ArrayList<String> tags = new ArrayList<String>();
                    if (sightingInfo.isHeardOnly()) {
                        tags.add("heardonly");
                    }
                    if (sightingInfo.isFemale()) {
                        tags.add("female");
                    }
                    if (sightingInfo.isMale()) {
                        tags.add("male");
                    }
                    if (sightingInfo.isImmature()) {
                        tags.add("immature");
                    }
                    if (sightingInfo.isPhotographed()) {
                        tags.add("photographed");
                    }
                    line[6] = Joiner.on(',').join(tags);
                }
                line[7] = "";
                exportLines.nextLine(line);
            }
            if ((long)rowCount++ < 9999L) continue;
            return;
        }
    }

    private String replaceDisallowedCharacters(String in) {
        return in.replace('\n', ' ').replace('\r', ' ').replace('\"', '\'');
    }

    public void useExcelCompatibleCsv() {
        this.useExcelCompatibleCsv = true;
    }
}

