/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.export;

import com.google.common.base.Joiner;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteSink;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.io.PartialIO;
import com.scythebill.birdlist.model.io.TimeIO;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.query.SightingComparators;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Photo;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.Trip;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.user.User;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class FullReportExport {
    private static final int COLUMN_COMMON_NAME = 0;
    private static final int COLUMN_SCIENTIFIC_NAME = 1;
    private static final int COLUMN_SUBSPECIES = 2;
    private static final int COLUMN_TAXONOMIC_INDEX = 3;
    private static final int COLUMN_DATE = 4;
    private static final int COLUMN_TIME = 5;
    private static final int COLUMN_NUMBER = 6;
    private static final int COLUMN_FEMALE = 7;
    private static final int COLUMN_MALE = 8;
    private static final int COLUMN_IMMATURE = 9;
    private static final int COLUMN_ADULT = 10;
    private static final int COLUMN_HEARD_ONLY = 11;
    private static final int COLUMN_STATUS = 12;
    private static final int COLUMN_BREEDING = 13;
    private static final int COLUMN_PHOTOGRAPHED = 14;
    private static final int COLUMN_PHOTOS = 15;
    private static final int COLUMN_DESCRIPTION = 16;
    private static final int COLUMN_LATITUDE = 17;
    private static final int COLUMN_LONGITUDE = 18;
    private static final int COLUMN_LOCATION_DESCRIPTION = 19;
    private static final int COLUMN_REGION = 20;
    private static final int COLUMN_COUNTRY = 21;
    private static final int COLUMN_STATE = 22;
    private static final int COLUMN_COUNTY = 23;
    private static final int COLUMN_CITY = 24;
    private static final int COLUMN_FIRST_LOCATION = 25;
    private static final int COLUMN_VISIT_OBSERVATION_TYPE = 0;
    private static final ImmutableList<String> HEADER = ImmutableList.of("Common", "Scientific", "Subspecies", "Index", "Date", "Start time", "Number", "Female", "Male", "Immature", "Adult", "Heard only", new String[]{"Status", "Breeding", "Photographed", "Photos", "Description", "Latitude", "Longitude", "Location Description", "Region", "Country", "State", "County", "City"});
    private static final ImmutableList<String> VISIT_INFO_HEADER = ImmutableList.of("Observation type", "Duration", "Distance", "Area", "Party size", "Complete list", "Visit comments", "Visit photos");
    private static final ImmutableList<String> USER_HEADER = ImmutableList.of("Observers", "Observer Names");
    private static final ImmutableList<String> TRIP_HEADER = ImmutableList.of("Trip name", "Trip start date", "Trip start time", "Trip end date", "Trip end time", "Trip notes", "Trip links");
    private static final Joiner LINE_JOINER = Joiner.on(System.lineSeparator());
    private final SightingInfo emptySightingInfo = new SightingInfo();
    private final LoadingCache<ImmutableSet<User>, String> abbreviationCache = CacheBuilder.newBuilder().build(new CacheLoader<ImmutableSet<User>, String>(){

        @Override
        public String load(ImmutableSet<User> users) throws Exception {
            return FullReportExport.toAbbreviations(users);
        }
    });
    private final LoadingCache<ImmutableSet<User>, String> nameCache = CacheBuilder.newBuilder().build(new CacheLoader<ImmutableSet<User>, String>(){

        @Override
        public String load(ImmutableSet<User> users) throws Exception {
            return FullReportExport.toNames(users);
        }
    });
    private final Set<String> exportedTripIds = new HashSet<String>();
    private boolean useExcelCompatibleCsv;

    public void exportReportSet(ByteSink outSupplier, ReportSet reportSet, Taxonomy taxonomy, QueryResults queryResults) throws IOException {
        this.exportExplicitSightings(outSupplier, reportSet, taxonomy, queryResults.getAllSightings());
    }

    public void exportExplicitSightings(ByteSink outSupplier, ReportSet reportSet, Taxonomy taxonomy, Iterable<Sighting> sightings) throws IOException {
        ArrayList<Sighting> sortedSightings = Lists.newArrayList(sightings);
        Collections.sort(sortedSightings, SightingComparators.preferMoreRecent());
        HashSet<VisitInfoKey> visitInfoKeys = new HashSet<VisitInfoKey>();
        int maximumLocationDepth = this.findMaximumLocationDepth(reportSet.getLocations());
        try (ExportLines csvWriter = this.startCsvExport(outSupplier, reportSet, maximumLocationDepth);){
            for (Sighting sighting : sortedSightings) {
                SightingTaxon.Resolved taxon = sighting.getTaxon().resolve(taxonomy);
                String locationId = sighting.getLocationId();
                Location location = locationId == null ? null : reportSet.getLocations().getLocation(locationId);
                VisitInfoKey visitInfoKey = VisitInfoKey.forSighting(sighting);
                VisitInfo visitInfo = null;
                if (visitInfoKey != null && !visitInfoKeys.contains(visitInfoKey)) {
                    visitInfo = reportSet.getVisitInfo(visitInfoKey);
                    visitInfoKeys.add(visitInfoKey);
                }
                this.writeSighting(csvWriter, reportSet, taxon, sighting, taxonomy, location, maximumLocationDepth, visitInfo);
            }
        }
    }

    private ExportLines startCsvExport(ByteSink outSupplier, ReportSet reportSet, int maximumLocationDepth) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outSupplier.openStream(), StandardCharsets.UTF_8), 10240);
        ExportLines exportLines = CsvExportLines.fromWriter(out);
        if (this.useExcelCompatibleCsv) {
            exportLines = exportLines.useExcelCompatibleCsv();
        }
        ArrayList<String> header = Lists.newArrayList(HEADER);
        for (int i = 0; i < maximumLocationDepth; ++i) {
            header.add(String.format("Location %s", i + 1));
        }
        header.addAll(VISIT_INFO_HEADER);
        if (reportSet.getUserSet() != null) {
            header.addAll(USER_HEADER);
        }
        if (reportSet.getTrips() != null && !reportSet.getTrips().allTrips().isEmpty()) {
            header.addAll(TRIP_HEADER);
        }
        exportLines.nextLine(header.toArray(new String[0]));
        return exportLines;
    }

    private void writeSighting(ExportLines csvWriter, ReportSet reportSet, SightingTaxon.Resolved resolved, Sighting sighting, Taxonomy taxonomy, @Nullable Location location, int maximumLocationDepth, VisitInfo visitInfo) throws IOException {
        SightingInfo sightingInfo;
        ArrayList<String> output = Lists.newArrayList();
        if (resolved.getSmallestTaxonType() == Taxon.Type.species) {
            output.add(resolved.hasCommonName() ? resolved.getCommonName() : "");
            output.add(resolved.getFullName());
            output.add("");
        } else {
            SightingTaxon.Resolved group = resolved.getParentOfAtLeastType(Taxon.Type.group).resolveInternal(taxonomy);
            output.add(group.hasCommonName() ? group.getCommonName() : "");
            SightingTaxon.Resolved species = resolved.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxonomy);
            output.add(species.getFullName());
            output.add(resolved.getName());
        }
        if (resolved.getType() == SightingTaxon.Type.SINGLE) {
            output.add("" + resolved.getTaxon().getTaxonomyIndex());
        } else {
            Taxon last = Iterables.getLast(resolved.getTaxa());
            output.add(last.getTaxonomyIndex() + ".5");
        }
        if (sighting.getStoredDateAsPartial() == null) {
            output.add("");
        } else {
            output.add(PartialIO.toString(sighting.getStoredDateAsPartial()));
        }
        if (sighting.getStoredTimeAsPartial() == null) {
            output.add("");
        } else {
            output.add(TimeIO.toString(sighting.getStoredTimeAsPartial()));
        }
        SightingInfo sightingInfo2 = sightingInfo = sighting.hasSightingInfo() ? sighting.getSightingInfo() : this.emptySightingInfo;
        if (sightingInfo.getNumber() != null) {
            output.add(sightingInfo.getNumber().toString());
        } else {
            output.add("");
        }
        output.add(sightingInfo.isFemale() ? "Y" : "");
        output.add(sightingInfo.isMale() ? "Y" : "");
        output.add(sightingInfo.isImmature() ? "Y" : "");
        output.add(sightingInfo.isAdult() ? "Y" : "");
        output.add(sightingInfo.isHeardOnly() ? "Y" : "");
        output.add(sightingInfo.getSightingStatus().getExportText());
        output.add(sightingInfo.getBreedingBirdCode().getId());
        output.add(sightingInfo.isPhotographed() ? "Y" : "");
        ArrayList<String> photos = Lists.newArrayList();
        for (Photo photo : sightingInfo.getPhotos()) {
            photos.add(photo.getUri().toString());
        }
        output.add(LINE_JOINER.join(photos));
        output.add(Strings.nullToEmpty(sightingInfo.getDescription()));
        if (location != null && location.getLatLong().isPresent()) {
            output.add(location.getLatLong().get().latitude());
            output.add(location.getLatLong().get().longitude());
        } else {
            output.add("");
            output.add("");
        }
        if (location != null && location.getDescription() != null) {
            output.add(location.getDescription());
        } else {
            output.add("");
        }
        output.add("");
        output.add("");
        output.add("");
        output.add("");
        output.add("");
        if (location != null) {
            this.appendLocations(output, location);
        }
        while (output.size() < HEADER.size() + maximumLocationDepth) {
            output.add("");
        }
        ImmutableSet<User> users = sightingInfo.getUsers();
        if (visitInfo != null) {
            output.add(visitInfo.observationType().id());
            if (visitInfo.duration().isPresent()) {
                output.add("" + visitInfo.duration().get().getStandardMinutes());
            } else {
                output.add("");
            }
            if (visitInfo.distance().isPresent()) {
                output.add("" + visitInfo.distance().get().kilometers());
            } else {
                output.add("");
            }
            if (visitInfo.area().isPresent()) {
                output.add("" + visitInfo.area().get().hectares());
            } else {
                output.add("");
            }
            if (visitInfo.partySize().isPresent()) {
                output.add("" + visitInfo.partySize().get());
            } else {
                output.add("");
            }
            output.add(visitInfo.completeChecklist() ? "Y" : "");
            if (visitInfo.comments().isPresent()) {
                output.add(visitInfo.comments().get());
            } else {
                output.add("");
            }
            if (!visitInfo.photos().isEmpty()) {
                output.add(visitInfo.photos().stream().map(p -> p.getUri().toString()).collect(Collectors.joining("\n")));
            } else {
                output.add("");
            }
        } else if (!users.isEmpty() || sighting.getTrip() != null) {
            for (String header : VISIT_INFO_HEADER) {
                output.add("");
            }
        }
        if (!users.isEmpty()) {
            output.add(this.abbreviationCache.getUnchecked(users));
            output.add(this.nameCache.getUnchecked(users));
        } else if (reportSet.getUserSet() != null && sighting.getTrip() != null) {
            for (String header : USER_HEADER) {
                output.add("");
            }
        }
        if (sighting.getTrip() != null) {
            Trip trip = sighting.getTrip();
            output.add(Strings.nullToEmpty(trip.name()));
            output.add(PartialIO.toString(trip.startDate()));
            output.add(trip.startTime() == null ? "" : TimeIO.toString(trip.startTime()));
            output.add(PartialIO.toString(trip.endDate()));
            output.add(trip.endTime() == null ? "" : TimeIO.toString(trip.endTime()));
            if (!this.exportedTripIds.contains(sighting.getTrip().id())) {
                output.add(Strings.nullToEmpty(trip.notes()));
            } else {
                output.add("");
            }
            if (!trip.links().isEmpty()) {
                output.add(trip.links().stream().map(l -> l.getUri().toString()).collect(Collectors.joining("\n")));
            }
            this.exportedTripIds.add(trip.id());
        }
        csvWriter.nextLine(output.toArray(new String[0]));
    }

    private boolean maybeSetInFixedColumn(List<String> output, Location location, int columnIndex) {
        if ("".equals(output.get(columnIndex))) {
            output.set(columnIndex, location.getDisplayName());
            return true;
        }
        if (location.getParent() != null && location.getParent().getType() == location.getType() && output.get(columnIndex).equals(location.getParent().getDisplayName())) {
            output.set(columnIndex, location.getDisplayName());
            return true;
        }
        return false;
    }

    private void appendLocations(List<String> output, Location location) {
        if (location.getParent() != null) {
            this.appendLocations(output, location.getParent());
        }
        if (location.getType() != null) {
            switch (location.getType()) {
                case region: {
                    if (!this.maybeSetInFixedColumn(output, location, 20)) break;
                    return;
                }
                case country: {
                    if ("".equals(output.get(21))) {
                        output.set(21, location.getDisplayName());
                        return;
                    }
                    if (!location.isBuiltInLocation() || !location.getParent().isBuiltInLocation() || location.getParent().getType() != Location.Type.country || !"".equals(output.get(22))) break;
                    output.set(22, location.getDisplayName());
                    return;
                }
                case state: {
                    if (!"".equals(output.get(22))) break;
                    output.set(22, location.getDisplayName());
                    return;
                }
                case county: {
                    if (!"".equals(output.get(23))) break;
                    output.set(23, location.getDisplayName());
                    return;
                }
                case city: 
                case town: {
                    if (!"".equals(output.get(24))) break;
                    output.set(24, location.getDisplayName());
                    return;
                }
            }
        }
        output.add(location.getDisplayName());
    }

    private int findMaximumLocationDepth(LocationSet locations) {
        int maxDepth = 0;
        for (Location location : locations.rootLocations()) {
            maxDepth = Math.max(maxDepth, this.findMaximumLocationDepth(location, 0, false, false, false, false));
        }
        return maxDepth;
    }

    private int findMaximumLocationDepth(Location location, int currentDepth, boolean foundRegion, boolean foundCountry, boolean foundState, boolean foundCounty) {
        if (location.getType() != null) {
            switch (location.getType()) {
                case region: {
                    if (!foundRegion) {
                        foundRegion = true;
                        break;
                    }
                    ++currentDepth;
                    break;
                }
                case country: {
                    if (!foundCountry) {
                        foundCountry = true;
                        break;
                    }
                    ++currentDepth;
                    break;
                }
                case state: {
                    if (!foundState) {
                        foundState = true;
                        break;
                    }
                    ++currentDepth;
                    break;
                }
                case county: {
                    if (!foundCounty) {
                        foundCounty = true;
                        break;
                    }
                    ++currentDepth;
                    break;
                }
                default: {
                    ++currentDepth;
                    break;
                }
            }
        } else {
            ++currentDepth;
        }
        int maxDepth = currentDepth;
        for (Location child : location.contents()) {
            maxDepth = Math.max(maxDepth, this.findMaximumLocationDepth(child, currentDepth, foundRegion, foundCountry, foundState, foundCounty));
        }
        return maxDepth;
    }

    private static String toAbbreviations(ImmutableSet<User> users) {
        return users.stream().map(User::abbreviation).filter(Predicates.notNull()).collect(Collectors.joining(","));
    }

    private static String toNames(ImmutableSet<User> users) {
        return users.stream().map(User::name).filter(Predicates.notNull()).collect(Collectors.joining("\n"));
    }

    public void useExcelCompatibleCsv() {
        this.useExcelCompatibleCsv = true;
    }
}

