/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.export;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import java.util.List;

public class Exports {
    private static final CharMatcher LAT_LONG_CHARS = CharMatcher.anyOf("-.0123456789,");
    private static final CharMatcher NOT_LAT_LONG_CHARS = LAT_LONG_CHARS.negate().or(CharMatcher.whitespace());

    private Exports() {
    }

    public static String trimLatLongFromDescription(String in) {
        int endOfLatLong;
        int lastLongStart;
        while ((lastLongStart = ((String)in).lastIndexOf("LL:")) >= 0 && (endOfLatLong = NOT_LAT_LONG_CHARS.indexIn((CharSequence)in, lastLongStart + 3)) != lastLongStart + 3) {
            in = endOfLatLong < 0 ? ((String)in).substring(0, lastLongStart) : ((String)in).substring(0, lastLongStart) + ((String)in).substring(endOfLatLong);
            in = CharMatcher.whitespace().trimFrom((CharSequence)in);
        }
        return in;
    }

    public static LatLongCoordinates returnLatLongFromDescription(String in) {
        if (in == null) {
            return null;
        }
        int lastLongStart = in.lastIndexOf("LL:");
        if (lastLongStart < 0) {
            return null;
        }
        String latLong = in.substring(lastLongStart + 3);
        if (!LAT_LONG_CHARS.matchesAllOf(latLong)) {
            return null;
        }
        List<String> split = Splitter.on(',').splitToList(latLong);
        if (split.size() != 2) {
            return null;
        }
        try {
            return LatLongCoordinates.withLatAndLong(split.get(0), split.get(1));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

