/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.export;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.io.ProgressOutputStream;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.stream.Collectors;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class EBirdCsvExport {
    private static final DateTimeFormatter EBIRD_DATE_FORMATTER = new DateTimeFormatterBuilder().appendMonthOfYear(1).appendLiteral('/').appendDayOfMonth(1).appendLiteral('/').appendYear(4, 4).toFormatter();
    private static final DateTimeFormatter EBIRD_TIME_FORMATTER = new DateTimeFormatterBuilder().appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).toFormatter();
    private static final long MAX_FILE_SIZE = 921600L;
    public static final int COLUMN_COMMON_NAME = 0;
    public static final int COLUMN_GENUS = 1;
    public static final int COLUMN_SPECIES = 2;
    public static final int COLUMN_SPECIES_COUNT = 3;
    public static final int COLUMN_SPECIES_COMMENTS = 4;
    public static final int COLUMN_LOCATION_NAME = 5;
    public static final int COLUMN_LATITUDE = 6;
    public static final int COLUMN_LONGITUDE = 7;
    public static final int COLUMN_OBSERVATION_DATE = 8;
    public static final int COLUMN_START_TIME = 9;
    public static final int COLUMN_STATE = 10;
    public static final int COLUMN_COUNTRY = 11;
    public static final int COLUMN_PROTOCOL = 12;
    public static final int COLUMN_NUMBER_OF_OBSERVERS = 13;
    public static final int COLUMN_DURATION = 14;
    public static final int COLUMN_ALL_OBSERVATIONS_REPORTED = 15;
    public static final int COLUMN_DISTANCE_COVERED = 16;
    public static final int COLUMN_AREA_COVERED = 17;
    public static final int COLUMN_CHECKLIST_COMMENTS = 18;
    private static final int TOTAL_COLUMN_COUNT = 19;
    private static final ImmutableMap<VisitInfo.ObservationType, VisitInfo.ObservationType> UNSUPPORTED_OBSERVATION_TYPES = ImmutableMap.of(VisitInfo.ObservationType.PELAGIC_PROTOCOL, VisitInfo.ObservationType.TRAVELING, VisitInfo.ObservationType.BANDING, VisitInfo.ObservationType.HISTORICAL, VisitInfo.ObservationType.NOCTURNAL_FLIGHT_CALL_COUNT, VisitInfo.ObservationType.STATIONARY, VisitInfo.ObservationType.NOCTURNAL_BIRDING, VisitInfo.ObservationType.HISTORICAL);
    private final Taxonomy clements;
    private final ImmutableMap<Taxon, Taxon> nonCanonicalTaxa;
    private static final CharMatcher LAT_LONG_CHARS = CharMatcher.anyOf("-.0123456789,");
    private static final CharMatcher NOT_LAT_LONG_CHARS = LAT_LONG_CHARS.negate().or(CharMatcher.whitespace());

    public EBirdCsvExport(Taxonomy clements) {
        this.clements = clements;
        this.nonCanonicalTaxa = ImmutableMap.of();
    }

    public void writeSpeciesList(ByteSink outSupplier, Iterator<Sighting> sightingsIterator, QueryResults queryResults, ReportSet reportSet) throws IOException {
        ProgressOutputStream progress = new ProgressOutputStream(outSupplier.openStream());
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)progress, StandardCharsets.UTF_8), 10240);
        try (ExportLines exportLines = CsvExportLines.fromWriter(out);){
            this.writeSpeciesList(exportLines, sightingsIterator, queryResults, reportSet, progress);
        }
    }

    public static boolean isAcceptableEBirdRecord(Sighting sighting, ReportSet reportSet) {
        if (sighting.getLocationId() == null) {
            return false;
        }
        Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
        if (!EBirdCsvExport.isAcceptableLocation(location)) {
            return false;
        }
        if (location.isPrivate()) {
            return false;
        }
        return EBirdCsvExport.isAcceptableRecord(sighting);
    }

    public static boolean isListBuildingSighting(Sighting sighting, ReportSet reportSet) {
        return EBirdCsvExport.isListBuildingDate(sighting.getSingleDateAsPartial());
    }

    private static boolean isListBuildingDate(ReadablePartial partial) {
        return partial == null || !partial.isSupported(DateTimeFieldType.year()) || !partial.isSupported(DateTimeFieldType.monthOfYear()) || !partial.isSupported(DateTimeFieldType.dayOfMonth());
    }

    private static boolean isAcceptableLocation(Location location) {
        return !location.isBuiltInLocation() || location.getType() != Location.Type.region;
    }

    private static boolean isAcceptableRecord(Sighting sighting) {
        SightingInfo sightingInfo;
        return sighting.getSightingInfo() == null || (sightingInfo = sighting.getSightingInfo()).getSightingStatus() != SightingInfo.SightingStatus.RECORD_NOT_ACCEPTED && sightingInfo.getSightingStatus() != SightingInfo.SightingStatus.ID_UNCERTAIN;
    }

    private void writeSpeciesList(ExportLines exportLines, Iterator<Sighting> sightingsIterator, QueryResults queryResults, ReportSet reportSet, ProgressOutputStream progress) throws IOException {
        while (sightingsIterator.hasNext()) {
            VisitInfoKey visitInfoKey;
            VisitInfo visitInfo;
            ReadablePartial date;
            String ebirdCode;
            Sighting sighting = sightingsIterator.next();
            SightingTaxon.Resolved nonCanonicalTaxon = sighting.getTaxon().resolve(this.clements);
            if (nonCanonicalTaxon.getSmallestTaxonType() == Taxon.Type.subspecies) {
                nonCanonicalTaxon = nonCanonicalTaxon.getParentOfAtLeastType(Taxon.Type.group).resolve(this.clements);
            }
            SightingTaxon.Resolved canonicalTaxon = this.canonicalizeForEBird(nonCanonicalTaxon);
            boolean needsLocationReconciliation = this.needsLocationReconciliation(canonicalTaxon);
            if (!EBirdCsvExport.isAcceptableEBirdRecord(sighting, reportSet)) continue;
            Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
            Location state = EBirdCsvExport.getAncestorOfTypeWithEbirdCode(location, Location.Type.state);
            Location country = EBirdCsvExport.getAncestorOfTypeWithEbirdCode(location, Location.Type.country);
            SightingTaxon.Resolved taxonForLine = needsLocationReconciliation ? this.canonicalizeForLocation(canonicalTaxon, state) : canonicalTaxon;
            String[] line = new String[19];
            line[0] = taxonForLine.getCommonName();
            if (sighting.getTaxon().getType() == SightingTaxon.Type.HYBRID) {
                line[0] = line[0] + " (hybrid)";
            }
            if (taxonForLine.getType() == SightingTaxon.Type.SINGLE || taxonForLine.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                Taxon singleTaxon = taxonForLine.getTaxon();
                Taxon species = TaxonUtils.getParentOfType(singleTaxon, Taxon.Type.species);
                line[2] = singleTaxon.getType() == Taxon.Type.group ? species.getName() + " " + singleTaxon.getName() : species.getName();
                Taxon genus = TaxonUtils.getParentOfType(singleTaxon, Taxon.Type.genus);
                line[1] = genus.getName();
            }
            line[5] = Locations.getGroupedLocationModelName(location);
            if (location.getLatLong().isPresent()) {
                LatLongCoordinates latLong = location.getLatLong().get();
                line[6] = latLong.latitudeAsCanonicalString();
                line[7] = latLong.longitudeAsCanonicalString();
            }
            if (state != null && state.getEbirdCode() != null) {
                ebirdCode = state.getEbirdCode();
                if (ebirdCode.contains("-")) {
                    int indexOfHyphen = ebirdCode.indexOf(45);
                    line[11] = ebirdCode.substring(0, indexOfHyphen);
                    line[10] = ebirdCode.substring(indexOfHyphen + 1);
                } else {
                    line[10] = ebirdCode;
                }
            }
            if (country != null && country.getEbirdCode() != null) {
                ebirdCode = country.getEbirdCode();
                if (ebirdCode.contains("-")) {
                    int indexOfHyphen = ebirdCode.indexOf(45);
                    line[11] = MoreObjects.firstNonNull(line[11], ebirdCode.substring(0, indexOfHyphen));
                    String stateHalfOfCountry = ebirdCode.substring(indexOfHyphen + 1);
                    if (stateHalfOfCountry.length() <= 3) {
                        line[10] = MoreObjects.firstNonNull(line[10], stateHalfOfCountry);
                    }
                } else {
                    line[11] = MoreObjects.firstNonNull(line[11], ebirdCode);
                }
            }
            if (EBirdCsvExport.isListBuildingDate(date = sighting.getSingleDateAsPartial())) {
                line[8] = "1/1/1900";
                line[9] = "";
            } else {
                line[8] = EBIRD_DATE_FORMATTER.print(date);
                if (sighting.getStoredTimeAsPartial() != null) {
                    line[9] = EBIRD_TIME_FORMATTER.print(sighting.getStoredTimeAsPartial());
                }
            }
            SightingInfo sightingInfo = sighting.getSightingInfo();
            if (sightingInfo != null) {
                line[3] = sightingInfo.getNumber() != null ? Integer.toString(sightingInfo.getNumber().getNumber()) : "X";
                if (sightingInfo.getDescription() != null) {
                    line[4] = this.trimLatLong(this.replaceDisallowedCharacters(sightingInfo.getDescription()));
                }
            }
            VisitInfo visitInfo2 = visitInfo = (visitInfoKey = VisitInfoKey.forSighting(sighting)) == null ? null : reportSet.getVisitInfo(visitInfoKey);
            if (visitInfo != null) {
                long minutes;
                VisitInfo.ObservationType observationType = visitInfo.observationType();
                if (UNSUPPORTED_OBSERVATION_TYPES.containsKey((Object)observationType)) {
                    observationType = UNSUPPORTED_OBSERVATION_TYPES.get((Object)observationType);
                }
                if (sighting.getStoredTimeAsPartial() == null && observationType.getRequiredFields().contains((Object)VisitInfo.VisitField.START_TIME)) {
                    observationType = VisitInfo.ObservationType.HISTORICAL;
                }
                line[12] = observationType.eBirdId();
                String string = line[15] = visitInfo.completeChecklist() ? "Y" : "N";
                if (visitInfo.area().isPresent()) {
                    line[17] = Float.toString(visitInfo.area().get().acres());
                }
                if (visitInfo.comments().isPresent()) {
                    line[18] = this.replaceDisallowedCharacters(visitInfo.comments().get());
                }
                if (visitInfo.distance().isPresent()) {
                    line[16] = Float.toString(visitInfo.distance().get().miles());
                }
                if (visitInfo.duration().isPresent() && (minutes = visitInfo.duration().get().getStandardMinutes()) > 0L) {
                    line[14] = Long.toString(minutes);
                }
                if (visitInfo.partySize().isPresent()) {
                    line[13] = Integer.toString(visitInfo.partySize().get());
                }
            } else {
                line[15] = "N";
                line[12] = "Incidental";
            }
            if (EBirdCsvExport.isListBuildingSighting(sighting, reportSet)) {
                line[12] = "Incidental";
                line[18] = Strings.isNullOrEmpty(line[18]) ? "life-list building checklist" : "life-list building checklist. " + line[18];
            }
            exportLines.nextLine(line);
            if (progress.getBytesWritten() <= 921600L) continue;
            return;
        }
    }

    private boolean needsLocationReconciliation(SightingTaxon.Resolved resolved) {
        return false;
    }

    private SightingTaxon.Resolved canonicalizeForLocation(SightingTaxon.Resolved resolved, Location state) {
        throw new IllegalStateException("Not expecting location resolution for " + resolved);
    }

    private SightingTaxon.Resolved canonicalizeForEBird(SightingTaxon.Resolved resolved) {
        boolean containsNonCanonicalTaxon = false;
        for (Taxon taxon2 : resolved.getTaxa()) {
            if (!this.nonCanonicalTaxa.containsKey(taxon2)) continue;
            containsNonCanonicalTaxon = true;
            break;
        }
        if (!containsNonCanonicalTaxon) {
            return resolved;
        }
        LinkedHashSet canonicalTaxa = resolved.getTaxa().stream().map(taxon -> this.nonCanonicalTaxa.getOrDefault(taxon, (Taxon)taxon)).collect(Collectors.toCollection(LinkedHashSet::new));
        return SightingTaxons.newPossiblySpResolved(canonicalTaxa);
    }

    private static Location getAncestorOfTypeWithEbirdCode(Location location, Location.Type type) {
        while ((location.getType() != type || location.getEbirdCode() == null) && (location = location.getParent()) != null) {
        }
        return location;
    }

    private String replaceDisallowedCharacters(String in) {
        return in.replace('\n', ' ').replace('\r', ' ').replace('\"', '\'');
    }

    private String trimLatLong(String in) {
        int endOfLatLong;
        int lastLongStart;
        while ((lastLongStart = ((String)in).lastIndexOf("LL:")) >= 0 && (endOfLatLong = NOT_LAT_LONG_CHARS.indexIn((CharSequence)in, lastLongStart + 3)) != lastLongStart + 3) {
            in = endOfLatLong < 0 ? ((String)in).substring(0, lastLongStart) : ((String)in).substring(0, lastLongStart) + ((String)in).substring(endOfLatLong);
            in = CharMatcher.whitespace().trimFrom((CharSequence)in);
        }
        return in;
    }
}

