/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.export;

import com.google.common.io.ByteSink;
import com.scythebill.birdlist.model.export.Exports;
import com.scythebill.birdlist.model.io.CsvExportLines;
import com.scythebill.birdlist.model.io.ExportLines;
import com.scythebill.birdlist.model.query.QueryResults;
import com.scythebill.birdlist.model.sighting.ApproximateNumber;
import com.scythebill.birdlist.model.sighting.LatLongCoordinates;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.Sighting;
import com.scythebill.birdlist.model.sighting.SightingInfo;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.VisitInfo;
import com.scythebill.birdlist.model.sighting.VisitInfoKey;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.taxa.names.NamesPreferences;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class BirdTrackCsvExport {
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendDayOfMonth(2).appendLiteral('-').appendMonthOfYear(2).appendLiteral('-').appendYear(4, 4).toFormatter();
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).toFormatter();
    private static final long MAX_ROWS = 15000L;
    private static final String[] COLUMN_HEADERS = new String[]{"Species", "Date", "Start", "End", "Comments", "Where", "Latitude", "Longitude", "Count", "Breeding", "Activity", "Complete_List", "Visit_Comments"};
    private static final int TOTAL_COLUMN_COUNT = COLUMN_HEADERS.length;
    private static final int COLUMN_TAXON_NAME = 0;
    private static final int COLUMN_DATE = 1;
    private static final int COLUMN_START = 2;
    private static final int COLUMN_END = 3;
    private static final int COLUMN_DESCRIPTION = 4;
    private static final int COLUMN_PLACE_NAME = 5;
    private static final int COLUMN_LATITUDE = 6;
    private static final int COLUMN_LONGITUDE = 7;
    private static final int COLUMN_COUNT = 8;
    private static final int COLUMN_BREEDING = 9;
    private static final int COLUMN_ACTIVITY = 10;
    private static final int COLUMN_COMPLETE_LIST = 11;
    private static final int COLUMN_VISIT_COMMENTS = 12;
    private final NamesPreferences namesPreferences;
    private boolean useExcelCompatibleCsv;

    public BirdTrackCsvExport(NamesPreferences namesPreferences) {
        this.namesPreferences = namesPreferences;
    }

    public static boolean isAcceptableSighting(ReportSet reportSet, Sighting sighting) {
        if (VisitInfoKey.forSighting(sighting) == null) {
            return false;
        }
        if (!BirdTrackCsvExport.isValidDate(sighting.getStoredDateAsPartial())) {
            return false;
        }
        if (sighting.getLocationId() == null) {
            return false;
        }
        Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
        if (!location.getLatLong().isPresent()) {
            return false;
        }
        return !location.isPrivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSpeciesList(ByteSink outSupplier, QueryResults queryResults, Iterator<Sighting> sightingIterator, Taxonomy taxonomy, ReportSet reportSet) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outSupplier.openStream(), StandardCharsets.UTF_8), 10240);
        ExportLines exportLines = CsvExportLines.fromWriter(out);
        if (this.useExcelCompatibleCsv) {
            exportLines = exportLines.useExcelCompatibleCsv();
        }
        try {
            String savedLocale = this.namesPreferences.locale;
            try {
                this.namesPreferences.locale = NamesPreferences.AvailableIocLocale.BRITISH.code();
                this.writeSpeciesList(exportLines, sightingIterator, taxonomy, reportSet);
            }
            finally {
                this.namesPreferences.locale = savedLocale;
            }
        }
        finally {
            exportLines.close();
        }
    }

    private void writeSpeciesList(ExportLines exportLines, Iterator<Sighting> sightingIterator, Taxonomy taxonomy, ReportSet reportSet) throws IOException {
        exportLines.nextLine(COLUMN_HEADERS);
        int rowCount = 0;
        while (sightingIterator.hasNext()) {
            VisitInfo visitInfo;
            Sighting sighting = sightingIterator.next();
            String[] line = new String[TOTAL_COLUMN_COUNT];
            SightingTaxon.Resolved taxon = sighting.getTaxon().resolve(taxonomy);
            if (taxon.getSmallestTaxonType() == Taxon.Type.species) {
                line[0] = taxon.getCommonName();
            } else {
                SightingTaxon.Resolved species = taxon.getParentOfAtLeastType(Taxon.Type.species).resolveInternal(taxon.getTaxonomy());
                line[0] = taxon.getTaxa().size() > 1 ? species.getCommonName() : (taxon.getTaxon().getStatus() == Species.Status.DO || taxon.getTaxon().getStatus() == Species.Status.IN ? species.getCommonName() : String.format("%s (%s)", species.getCommonName(), taxon.getTaxon().getName()));
            }
            if (sighting.getLocationId() != null) {
                Location location = reportSet.getLocations().getLocation(sighting.getLocationId());
                line[5] = location.getDisplayName();
                LatLongCoordinates latLong = null;
                if (sighting.hasSightingInfo()) {
                    latLong = Exports.returnLatLongFromDescription(sighting.getSightingInfo().getDescription());
                }
                if (latLong == null && location.getLatLong().isPresent()) {
                    latLong = location.getLatLong().get();
                }
                if (latLong != null) {
                    line[6] = String.format(Locale.US, "%2.4f", latLong.latitudeAsDouble());
                    line[7] = String.format(Locale.US, "%2.4f", latLong.longitudeAsDouble());
                }
            }
            if (BirdTrackCsvExport.isValidDate(sighting.getStoredDateAsPartial())) {
                line[1] = DATE_FORMATTER.print(sighting.getStoredDateAsPartial());
                if (sighting.getStoredTimeAsPartial() != null) {
                    LocalTime timeAsPartial = sighting.getStoredTimeAsPartial();
                    timeAsPartial = timeAsPartial.minusMinutes(timeAsPartial.getMinuteOfHour() % 5);
                    line[2] = TIME_FORMATTER.print(timeAsPartial);
                }
            }
            if (sighting.hasSightingInfo()) {
                SightingInfo sightingInfo = sighting.getSightingInfo();
                if (sightingInfo.getDescription() != null) {
                    line[4] = StringUtils.abbreviate(Exports.trimLatLongFromDescription(sightingInfo.getDescription()), 1000);
                }
                if (sightingInfo.getNumber() != null) {
                    ApproximateNumber number = sightingInfo.getNumber();
                    String numberString = number.toString();
                    line[8] = number.isExact() ? numberString : (numberString.startsWith("+") || numberString.startsWith(">") ? "+" + number.getNumber() : "c" + number.getNumber());
                }
                if (sightingInfo.getBreedingBirdCode() != null) {
                    line[9] = sightingInfo.getBreedingBirdCode().getBirdTrackId();
                }
                switch (sightingInfo.getSightingStatus()) {
                    case DEAD: {
                        line[10] = "9,,";
                        break;
                    }
                    case INTRODUCED_NOT_ESTABLISHED: {
                        line[10] = "10,,";
                        break;
                    }
                    case ID_UNCERTAIN: {
                        line[10] = "11,,";
                        break;
                    }
                }
            }
            if ((visitInfo = reportSet.getVisitInfo(VisitInfoKey.forSighting(sighting))) != null) {
                if (visitInfo.duration().isPresent() && sighting.getStoredTimeAsPartial() != null) {
                    LocalTime endTime = sighting.getStoredTimeAsPartial().plus(visitInfo.duration().get().toPeriod(sighting.getStoredTimeAsPartial().getChronology()));
                    endTime = endTime.minusMinutes(endTime.getMinuteOfHour() % 5);
                    line[3] = TIME_FORMATTER.print(endTime);
                }
                if (visitInfo.completeChecklist()) {
                    line[11] = "Y";
                }
                if (visitInfo.comments().isPresent()) {
                    line[12] = StringUtils.abbreviate(visitInfo.comments().get(), 1000);
                }
            }
            exportLines.nextLine(line);
            if ((long)rowCount++ < 15000L) continue;
            return;
        }
    }

    private static boolean isValidDate(ReadablePartial partial) {
        return partial != null && partial.isSupported(DateTimeFieldType.year()) && partial.isSupported(DateTimeFieldType.monthOfYear()) && partial.isSupported(DateTimeFieldType.dayOfMonth());
    }

    public void useExcelCompatibleCsv() {
        this.useExcelCompatibleCsv = true;
    }
}

