/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import com.google.common.io.Resources;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.ExtendedTaxonomyChecklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.LocationSet;
import com.scythebill.birdlist.model.sighting.Locations;
import com.scythebill.birdlist.model.sighting.PredefinedLocations;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.taxa.MappedTaxonomy;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class TransposedChecklists {
    private static final String NATIVE = "native";
    private static final TransposedChecklists instance = new TransposedChecklists();
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private final LoadingCache<String, TransposedChecklist> transposedChecklistCache = CacheBuilder.newBuilder().build(new CacheLoader<String, TransposedChecklist>(){

        @Override
        public TransposedChecklist load(String filename) throws Exception {
            return TransposedChecklists.this.getTransposedChecklist(filename);
        }
    });
    private final ImmutableSet<Checklist.Status> ALL_STATUSES = ImmutableSet.copyOf(Checklist.Status.values());

    private TransposedChecklists() {
    }

    public static TransposedChecklists instance() {
        return instance;
    }

    public TransposedChecklist getTransposedChecklist(ReportSet reportSet, Taxonomy taxonomy) {
        if (taxonomy.isBuiltIn()) {
            String transposeFileName = taxonomy instanceof MappedTaxonomy ? "ioc.transpose" : "clements.transpose";
            return this.transposedChecklistCache.getUnchecked(transposeFileName);
        }
        ExtendedTaxonomyChecklists checklists = reportSet.getExtendedTaxonomyChecklist(taxonomy.getId());
        if (checklists == null || checklists.getChecklists().isEmpty()) {
            return null;
        }
        return checklists.getTransposedChecklist();
    }

    public boolean hasTransposedChecklistEntry(ReportSet reportSet, Taxon taxon) {
        if (taxon.getType() != Taxon.Type.species) {
            return false;
        }
        TransposedChecklist transposedChecklist = TransposedChecklists.instance().getTransposedChecklist(reportSet, taxon.getTaxonomy());
        if (transposedChecklist == null) {
            return false;
        }
        return !Iterables.isEmpty(transposedChecklist.locationsWithStatuses(taxon, this.ALL_STATUSES));
    }

    private TransposedChecklist getTransposedChecklist(String filename) {
        try {
            final Table<String, String, List<String>> loaded = this.loadTranspose(filename);
            return new TransposedChecklist(){

                @Override
                public Iterable<String> locationsWithStatuses(Taxon taxon, ImmutableSet<Checklist.Status> statusSet) {
                    return this.locationsWithStatuses(taxon.getId(), statusSet);
                }

                @Override
                public Iterable<String> locationsWithStatuses(String speciesId, ImmutableSet<Checklist.Status> statusSet) {
                    ArrayList<List> locationsListList = Lists.newArrayList();
                    for (Checklist.Status status : statusSet) {
                        String statusString = status == Checklist.Status.NATIVE ? TransposedChecklists.NATIVE : status.text();
                        List list = (List)loaded.get(speciesId, statusString);
                        if (list == null) continue;
                        locationsListList.add(list);
                    }
                    return Iterables.concat(locationsListList);
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table<String, String, List<String>> loadTranspose(String transposeFileName) throws IOException {
        HashBasedTable<String, String, List<String>> speciesStatusCountriesTable = HashBasedTable.create(11000, 3);
        URL url = Resources.getResource(this.getClass(), transposeFileName);
        InputStream stream = url.openStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                String status;
                String species;
                int equalsIndex = line.indexOf(61);
                if (equalsIndex < 0) continue;
                String start = line.substring(0, equalsIndex);
                int slashIndex = start.indexOf(47);
                if (slashIndex < 0) {
                    species = start;
                    status = NATIVE;
                } else {
                    species = start.substring(0, slashIndex);
                    status = start.substring(slashIndex + 1);
                }
                String end = line.substring(equalsIndex + 1);
                List<String> countries = COMMA_SPLITTER.splitToList(end);
                speciesStatusCountriesTable.put(species, status, countries);
            }
            HashBasedTable<String, String, List<String>> hashBasedTable = speciesStatusCountriesTable;
            return hashBasedTable;
        }
    }

    public static Location getAssumedLocation(SightingTaxon.Resolved resolved, LocationSet locations, PredefinedLocations predefinedLocations, TransposedChecklist transposedChecklist) {
        String endemicLocation = null;
        for (Taxon taxon : resolved.getTaxa()) {
            Taxon species = TaxonUtils.getParentOfAtLeastType(taxon, Taxon.Type.species);
            Iterable<String> endemicLocations = transposedChecklist.locationsWithStatuses(species, ImmutableSet.of(Checklist.Status.ENDEMIC));
            if (Iterables.isEmpty(endemicLocations)) {
                endemicLocation = null;
                break;
            }
            String first = endemicLocations.iterator().next();
            if (endemicLocation != null && !first.equals(endemicLocation)) {
                endemicLocation = null;
                break;
            }
            endemicLocation = first;
        }
        if (endemicLocation == null) {
            return null;
        }
        if ("ID-Asia".equals(endemicLocation)) {
            return TransposedChecklists.getLocationWithParent(locations, "ID", "Asia");
        }
        if ("ID-Australasia".equals(endemicLocation)) {
            return TransposedChecklists.getLocationWithParent(locations, "ID", "Australasia");
        }
        if ("RU-Asia".equals(endemicLocation)) {
            return TransposedChecklists.getLocationWithParent(locations, "RU", "Asia");
        }
        return Locations.getLocationByCodePossiblyCreating(locations, predefinedLocations, endemicLocation);
    }

    private static Location getLocationWithParent(LocationSet locations, String countryCode, String parent) {
        for (Location location : locations.getLocationsByCode("ID")) {
            if (!location.getParent().getModelName().equals(parent)) continue;
            return location;
        }
        return null;
    }
}

