/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.Checklists;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklists;
import com.scythebill.birdlist.model.query.SyntheticLocation;
import com.scythebill.birdlist.model.sighting.Location;
import com.scythebill.birdlist.model.sighting.ReportSet;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.TaxonUtils;
import com.scythebill.birdlist.model.taxa.TaxonVisitor;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Singleton
public class TransposedChecklistSynthesizer {
    private static ImmutableMultimap<String, String> EXCLUSIONS = TransposedChecklistSynthesizer.buildExclusions();
    private final LoadingCache<CacheKey, Checklist> cache = CacheBuilder.newBuilder().maximumSize(10L).build(new CacheLoader<CacheKey, Checklist>(){

        @Override
        public Checklist load(CacheKey key) throws Exception {
            return TransposedChecklistSynthesizer.this.createChecklist(null, key.locationCodes, key.taxonomy);
        }
    });
    private static final ImmutableMap<String, ImmutableSet<String>> SUPPORTED_REGIONS_WITH_EXCLUSIONS = ImmutableMap.builder().put("Europe", ImmutableSet.of("TR")).put("Asia", ImmutableSet.of()).put("Eurasia", ImmutableSet.of()).put("Africa", ImmutableSet.of()).put("Australasia", ImmutableSet.of()).put("South Polar Region", ImmutableSet.of()).put("Central America", ImmutableSet.of()).put("North America", ImmutableSet.of()).put("South America", ImmutableSet.of()).put("West Indies", ImmutableSet.of()).put("Indian Ocean", ImmutableSet.of()).put("Pacific Ocean", ImmutableSet.of()).put("Atlantic Ocean", ImmutableSet.of()).put("Arctic Ocean", ImmutableSet.of()).build();
    private static final ImmutableMultimap<String, String> SYNTHETIC_US_CHECKLISTS = ImmutableMultimap.builder().putAll("West Indies", "PR", "VI").putAll("Pacific Ocean", (String[])new String[]{"US-HI", "GU", "MP", "AS"}).build();
    private static final ImmutableMultimap<String, String> SYNTHETIC_CHECKLISTS = ImmutableMultimap.builder().putAll("GB", "GB-ENG", "GB-NIR", "GB-SCT", "GB-WLS").putAll("SH", (String[])new String[]{"SH-AC", "SH-SH", "SH-TA"}).build();

    @Inject
    TransposedChecklistSynthesizer() {
    }

    public Checklist synthesizeChecklist(ReportSet reportSet, Taxonomy taxonomy, Iterable<Location> locations) {
        if (!taxonomy.isBuiltIn()) {
            return null;
        }
        ImmutableSet.Builder allChecklistCodes = ImmutableSet.builder();
        for (Location location : locations) {
            Collection<String> checklistCodes = this.getTransposedChecklistLocations(location);
            if (checklistCodes != null) {
                allChecklistCodes.addAll(checklistCodes);
                continue;
            }
            if ("US".equals(location.getEbirdCode()) && !"North America".equals(location.getParent().getModelName()) || "BQ".equals(location.getEbirdCode()) && !"West Indies".equals(location.getParent().getModelName())) {
                for (Location child : location.contents()) {
                    String checklistCode = Checklists.getChecklistLocationCode(child);
                    if (checklistCode == null) continue;
                    allChecklistCodes.add(checklistCode);
                }
                continue;
            }
            String checklistLocationCode = Checklists.getChecklistLocationCode(location);
            if (checklistLocationCode != null) {
                allChecklistCodes.add(checklistLocationCode);
                continue;
            }
            return null;
        }
        return this.synthesizeChecklistInternal(reportSet, taxonomy, allChecklistCodes.build());
    }

    public Collection<String> getTransposedChecklistLocations(Location location) {
        Collection<String> syntheticLocationUnion;
        if (location instanceof SyntheticLocation && (syntheticLocationUnion = ((SyntheticLocation)location).syntheticChecklistUnion()) != null) {
            return syntheticLocationUnion;
        }
        if (location.isBuiltInLocation() && location.getType() == Location.Type.region && SUPPORTED_REGIONS_WITH_EXCLUSIONS.containsKey(location.getModelName())) {
            AbstractCollection checklistCodes = Checklists.gatherCountryChecklistCodes(location);
            ImmutableSet<String> exclusions = SUPPORTED_REGIONS_WITH_EXCLUSIONS.get(location.getModelName());
            if (!exclusions.isEmpty()) {
                checklistCodes = Sets.difference(checklistCodes, exclusions);
            }
            return checklistCodes;
        }
        if ("US".equals(location.getEbirdCode()) && SYNTHETIC_US_CHECKLISTS.containsKey(location.getParent().getModelName())) {
            return SYNTHETIC_US_CHECKLISTS.get((Object)location.getParent().getModelName());
        }
        if ("BQ".equals(location.getEbirdCode())) {
            if ("South America".equals(location.getParent().getModelName())) {
                return ImmutableSet.of("AW", "BQ-BO", "CW");
            }
            return ImmutableSet.of("BQ");
        }
        String locationCode = Checklists.getChecklistLocationCode(location);
        if (SYNTHETIC_CHECKLISTS.containsKey(locationCode)) {
            return SYNTHETIC_CHECKLISTS.get((Object)locationCode);
        }
        return null;
    }

    public Checklist synthesizeChecklistInternal(final ReportSet reportSet, Iterable<String> locationCodes) {
        final ImmutableSet<String> copiedLocationCodes = ImmutableSet.copyOf(locationCodes);
        return new Checklist(){
            private Map<Taxonomy, Checklist> synthesizedChecklists = new HashMap<Taxonomy, Checklist>();

            private Checklist getChecklist(Taxonomy taxonomy) {
                return this.synthesizedChecklists.computeIfAbsent(taxonomy, t -> TransposedChecklistSynthesizer.this.synthesizeChecklistInternal(reportSet, (Taxonomy)t, copiedLocationCodes));
            }

            @Override
            public boolean isBuiltIn() {
                return true;
            }

            @Override
            public boolean includesTaxon(Taxon taxon, Set<Checklist.Status> excludingStatus) {
                Checklist checklist = this.getChecklist(taxon.getTaxonomy());
                return checklist.includesTaxon(taxon, excludingStatus);
            }

            @Override
            public boolean includesTaxon(Taxon taxon) {
                Checklist checklist = this.getChecklist(taxon.getTaxonomy());
                return checklist.includesTaxon(taxon);
            }

            @Override
            public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy, Checklist.Status status) {
                Checklist checklist = this.getChecklist(taxonomy);
                return checklist.getTaxa(taxonomy, status);
            }

            @Override
            public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy) {
                Checklist checklist = this.getChecklist(taxonomy);
                return checklist.getTaxa(taxonomy);
            }

            @Override
            public Checklist.Status getStatus(Taxonomy taxonomy, SightingTaxon taxon) {
                Checklist checklist = this.getChecklist(taxonomy);
                return checklist.getStatus(taxonomy, taxon);
            }

            @Override
            public boolean isSynthetic() {
                return true;
            }
        };
    }

    Checklist synthesizeChecklistInternal(ReportSet reportSet, Taxonomy taxonomy, Iterable<String> locationCodes) {
        if (!taxonomy.isBuiltIn()) {
            return this.createChecklist(reportSet, ImmutableSet.copyOf(locationCodes), taxonomy);
        }
        return this.cache.getUnchecked(new CacheKey(locationCodes, taxonomy));
    }

    private Checklist createChecklist(ReportSet reportSet, final ImmutableSet<String> locationCodes, final Taxonomy taxonomy) {
        Preconditions.checkArgument(reportSet != null || taxonomy.isBuiltIn());
        final TransposedChecklist transposed = TransposedChecklists.instance().getTransposedChecklist(reportSet, taxonomy);
        final HashMap builder = Maps.newHashMap();
        ImmutableSet.Builder exclusionBuilder = ImmutableSet.builder();
        for (String locationCode : locationCodes) {
            exclusionBuilder.addAll((Iterable)EXCLUSIONS.get((Object)locationCode));
        }
        ImmutableCollection currentExclusions = exclusionBuilder.build();
        TaxonUtils.visitTaxa(taxonomy.getRoot(), new TaxonVisitor(){
            final /* synthetic */ ImmutableSet val$currentExclusions;
            {
                this.val$currentExclusions = immutableSet2;
            }

            @Override
            public boolean visitTaxon(Taxon taxon) {
                if (taxon.getType() == Taxon.Type.species) {
                    SightingTaxon sightingTaxon = SightingTaxons.newSightingTaxon(taxon.getId());
                    for (String locationId : transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.EXTINCT))) {
                        if (!locationCodes.contains(locationId)) continue;
                        builder.put(SightingTaxons.newSightingTaxon(taxon.getId()), Checklist.Status.EXTINCT);
                        break;
                    }
                    for (String locationId : transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.RARITY_FROM_INTRODUCED))) {
                        if (!locationCodes.contains(locationId)) continue;
                        builder.put(sightingTaxon, Checklist.Status.RARITY_FROM_INTRODUCED);
                        break;
                    }
                    for (String locationId : transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.RARITY))) {
                        if (!locationCodes.contains(locationId)) continue;
                        builder.put(sightingTaxon, Checklist.Status.RARITY);
                        break;
                    }
                    for (String locationId : transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.INTRODUCED))) {
                        if (!locationCodes.contains(locationId)) continue;
                        builder.put(sightingTaxon, Checklist.Status.INTRODUCED);
                        break;
                    }
                    boolean alreadyEndemic = false;
                    Iterable<String> endemicLocations = transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.ENDEMIC));
                    if (!Iterables.isEmpty(endemicLocations)) {
                        boolean allEndemicLocationsIncluded = true;
                        for (String endemicLocation : endemicLocations) {
                            if (locationCodes.contains(endemicLocation)) continue;
                            allEndemicLocationsIncluded = false;
                            break;
                        }
                        if (allEndemicLocationsIncluded) {
                            alreadyEndemic = true;
                            builder.put(sightingTaxon, Checklist.Status.ENDEMIC);
                        }
                    }
                    if (!alreadyEndemic) {
                        boolean oneNativeInLocations = false;
                        boolean oneNativeNotInLocations = false;
                        for (String locationId : transposed.locationsWithStatuses(taxon, ImmutableSet.of(Checklist.Status.NATIVE, Checklist.Status.ENDEMIC))) {
                            if (locationCodes.contains(locationId)) {
                                builder.put(sightingTaxon, Checklist.Status.NATIVE);
                                oneNativeInLocations = true;
                            } else if (!this.val$currentExclusions.contains(locationId)) {
                                oneNativeNotInLocations = true;
                            }
                            if (!oneNativeInLocations || !oneNativeNotInLocations) continue;
                            break;
                        }
                        if (oneNativeInLocations && !oneNativeNotInLocations) {
                            builder.put(sightingTaxon, Checklist.Status.ENDEMIC);
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        final ImmutableMap map = ImmutableMap.copyOf(builder);
        return new Checklist(){

            @Override
            public ImmutableSet<SightingTaxon> getTaxa(Taxonomy checklistTaxonomy) {
                Preconditions.checkArgument(taxonomy == checklistTaxonomy);
                return map.keySet();
            }

            @Override
            public ImmutableSet<SightingTaxon> getTaxa(Taxonomy checklistTaxonomy, final Checklist.Status status) {
                Preconditions.checkArgument(taxonomy == checklistTaxonomy);
                return FluentIterable.from(this.getTaxa(checklistTaxonomy)).filter(new Predicate<SightingTaxon>(){

                    @Override
                    public boolean apply(SightingTaxon taxon) {
                        return map.get(taxon) == status;
                    }
                }).toSet();
            }

            @Override
            public Checklist.Status getStatus(Taxonomy checklistTaxonomy, SightingTaxon taxon) {
                Preconditions.checkArgument(taxonomy == checklistTaxonomy);
                if (taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
                    taxon = SightingTaxons.newSightingTaxon(taxon.getId());
                }
                return (Checklist.Status)((Object)map.get(taxon));
            }

            @Override
            public boolean includesTaxon(Taxon taxon) {
                Preconditions.checkArgument(taxonomy == taxon.getTaxonomy());
                return map.containsKey(SightingTaxons.newSightingTaxon(taxon.getId()));
            }

            @Override
            public boolean includesTaxon(Taxon taxon, Set<Checklist.Status> excludingStatus) {
                Preconditions.checkArgument(taxonomy == taxon.getTaxonomy());
                Checklist.Status status = (Checklist.Status)((Object)map.get(SightingTaxons.newSightingTaxon(taxon.getId())));
                if (status == null) {
                    return false;
                }
                return !excludingStatus.contains((Object)status);
            }

            @Override
            public boolean isBuiltIn() {
                return true;
            }

            @Override
            public boolean isSynthetic() {
                return true;
            }
        };
    }

    private static ImmutableMultimap<String, String> buildExclusions() {
        ImmutableSet<String> states = ImmutableSet.of("CA-AB", "CA-BC", "CA-MB", "CA-NB", "CA-NL", "CA-NT", new String[]{"CA-NS", "CA-NU", "CA-ON", "CA-PE", "CA-QC", "CA-SK", "CA-YT", "US-AL", "US-AK", "US-AZ", "US-AR", "US-CA", "US-CO", "US-CT", "US-DE", "US-DC", "US-FL", "US-GA", "US-ID", "US-IL", "US-IN", "US-IA", "US-KS", "US-KY", "US-LA", "US-ME", "US-MD", "US-MA", "US-MI", "US-MN", "US-MS", "US-MO", "US-MT", "US-NE", "US-NV", "US-NH", "US-NJ", "US-NM", "US-NY", "US-NC", "US-ND", "US-OH", "US-OK", "US-OR", "US-PA", "US-RI", "US-SC", "US-SD", "US-TN", "US-TX", "US-UT", "US-VT", "US-VA", "US-WA", "US-WV", "US-WI", "US-WY", "AU-ACT", "AU-NSW", "AU-NT", "AU-QLD", "AU-SA", "AU-TAS", "AU-VIC", "AU-WA", "ID-JW", "ID-KA", "ID-MA", "ID-NU", "ID-IJ", "ID-SL", "ID-SM", "FI-01", "PG-NSA"});
        ImmutableMap<String, String> INDONESIA_AUSTRALASIA_STATE_TO_COUNTRY = ImmutableMap.of("ID-IJ", "ID-Australasia", "ID-MA", "ID-Australasia");
        ImmutableMultimap.Builder<String, String> builder = ImmutableMultimap.builder();
        for (String state : states) {
            String country = state.substring(0, 2);
            if (country.equals("ID")) {
                country = INDONESIA_AUSTRALASIA_STATE_TO_COUNTRY.getOrDefault(state, "ID-Asia");
            }
            builder.put(state, country);
            builder.put(country, state);
        }
        return builder.build();
    }

    static final class CacheKey {
        final ImmutableSet<String> locationCodes;
        final Taxonomy taxonomy;
        private final int hash;

        CacheKey(Iterable<String> locationCodes, Taxonomy taxonomy) {
            Preconditions.checkArgument(taxonomy.isBuiltIn(), "Only built-in taxonomies can be cached");
            this.locationCodes = ImmutableSet.copyOf(locationCodes);
            this.taxonomy = taxonomy;
            this.hash = Objects.hashCode(this.locationCodes, taxonomy.getId());
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return that.taxonomy == this.taxonomy && that.locationCodes.equals(this.locationCodes);
        }
    }
}

