/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import java.util.Map;

final class SplitChecklist {
    private final ImmutableMap<SightingTaxon, Checklist.Status> taxa;

    SplitChecklist(Map<SightingTaxon, Checklist.Status> taxa) {
        this.taxa = ImmutableMap.copyOf(taxa);
    }

    ImmutableSet<SightingTaxon> getTaxa() {
        return this.taxa.keySet();
    }

    Checklist.Status getStatus(SightingTaxon taxon) {
        if (taxon.getType() == SightingTaxon.Type.SINGLE_WITH_SECONDARY_SUBSPECIES) {
            taxon = SightingTaxons.newSightingTaxon(taxon.getId());
        }
        return this.taxa.get(taxon);
    }

    public ImmutableSet<SightingTaxon> getTaxa(Checklist.Status status) {
        return ImmutableSet.copyOf(Maps.filterValues(this.taxa, Predicates.equalTo(status)).keySet());
    }
}

