/*
 * Decompiled with CFR 0.152.
 */
package com.scythebill.birdlist.model.checklist;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.scythebill.birdlist.model.checklist.Checklist;
import com.scythebill.birdlist.model.checklist.TransposedChecklist;
import com.scythebill.birdlist.model.sighting.SightingTaxon;
import com.scythebill.birdlist.model.sighting.SightingTaxons;
import com.scythebill.birdlist.model.taxa.Species;
import com.scythebill.birdlist.model.taxa.Taxon;
import com.scythebill.birdlist.model.taxa.Taxonomy;
import com.scythebill.birdlist.model.xml.ExtendedTaxonomyParsing;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ExtendedTaxonomyChecklists {
    private final ImmutableMap<String, Checklist> checklists;
    private final TransposedChecklist transposedChecklist;

    private ExtendedTaxonomyChecklists(Map<String, Checklist> checklists, TransposedChecklist transposedChecklist) {
        this.checklists = ImmutableMap.copyOf(checklists);
        this.transposedChecklist = transposedChecklist;
    }

    public ImmutableMap<String, Checklist> getChecklists() {
        return this.checklists;
    }

    public TransposedChecklist getTransposedChecklist() {
        return this.transposedChecklist;
    }

    static class ExtendedTaxonomyChecklist
    implements Checklist {
        private final ImmutableMap<SightingTaxon, Checklist.Status> taxa;

        public ExtendedTaxonomyChecklist(Map<SightingTaxon, Checklist.Status> taxa) {
            this.taxa = ImmutableMap.copyOf(taxa);
        }

        @Override
        public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy) {
            return this.taxa.keySet();
        }

        @Override
        public ImmutableSet<SightingTaxon> getTaxa(Taxonomy taxonomy, Checklist.Status status) {
            return this.taxa.entrySet().stream().filter(e -> e.getValue() == status).map(Map.Entry::getKey).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public Checklist.Status getStatus(Taxonomy taxonomy, SightingTaxon taxon) {
            return this.taxa.get(taxon);
        }

        @Override
        public boolean includesTaxon(Taxon taxon) {
            return this.taxa.containsKey(SightingTaxons.newSightingTaxon(taxon.getId()));
        }

        @Override
        public boolean includesTaxon(Taxon taxon, Set<Checklist.Status> excludingStatus) {
            Checklist.Status status = this.taxa.get(SightingTaxons.newSightingTaxon(taxon.getId()));
            if (status == null) {
                return false;
            }
            return !excludingStatus.contains((Object)status);
        }

        @Override
        public boolean isBuiltIn() {
            return true;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }
    }

    static class ExtendedTaxonomyTransposedChecklist
    implements TransposedChecklist {
        private final ImmutableTable<SightingTaxon, String, Checklist.Status> transposed;

        ExtendedTaxonomyTransposedChecklist(Table<SightingTaxon, String, Checklist.Status> transposed) {
            this.transposed = ImmutableTable.copyOf(transposed);
        }

        @Override
        public Iterable<String> locationsWithStatuses(Taxon species, ImmutableSet<Checklist.Status> statusSet) {
            SightingTaxon taxon = SightingTaxons.newSightingTaxon(species.getId());
            if (!this.transposed.containsRow(taxon)) {
                return ImmutableSet.of();
            }
            return ((ImmutableMap)this.transposed.row((Object)taxon)).keySet().stream().filter(locationId -> statusSet.contains(this.transposed.get(taxon, locationId))).collect(ImmutableSet.toImmutableSet());
        }

        @Override
        public Iterable<String> locationsWithStatuses(String speciesId, ImmutableSet<Checklist.Status> statusSet) {
            SightingTaxon taxon = SightingTaxons.newSightingTaxon(speciesId);
            if (!this.transposed.containsRow(taxon)) {
                return ImmutableSet.of();
            }
            return ((ImmutableMap)this.transposed.row((Object)taxon)).keySet().stream().filter(locationId -> statusSet.contains(this.transposed.get(taxon, locationId))).collect(ImmutableSet.toImmutableSet());
        }
    }

    public static class Builder {
        private final Table<String, SightingTaxon, Checklist.Status> table = HashBasedTable.create();
        private final Table<SightingTaxon, String, Checklist.Status> transposed = HashBasedTable.create();

        public void addEntries(SightingTaxon taxon, Species.Status status, Collection<String> checklistIdsWithStatus) {
            boolean extinct = status == Species.Status.EX || status == Species.Status.EW;
            block8: for (String checklistIdWithStatus : checklistIdsWithStatus) {
                ExtendedTaxonomyParsing.LocationAndStatus locationAndStatus = ExtendedTaxonomyParsing.locationAndStatus(checklistIdWithStatus);
                Checklist.Status checklistStatus = locationAndStatus.status();
                if (extinct) {
                    checklistStatus = Checklist.Status.EXTINCT;
                } else if (checklistStatus == Checklist.Status.NATIVE && checklistIdsWithStatus.size() == 1) {
                    checklistStatus = Checklist.Status.ENDEMIC;
                }
                switch (locationAndStatus.locationCode()) {
                    case "ID": {
                        this.table.put("ID-Asia", taxon, checklistStatus);
                        this.table.put("ID-Australasia", taxon, checklistStatus);
                        this.transposed.put(taxon, "ID-Asia", checklistStatus);
                        this.transposed.put(taxon, "ID-Australasia", checklistStatus);
                        continue block8;
                    }
                    case "RU": {
                        this.transposed.put(taxon, "RU-Europe", checklistStatus);
                        this.transposed.put(taxon, "RU-Asia", checklistStatus);
                        this.table.put("RU-Europe", taxon, checklistStatus);
                        this.table.put("RU-Asia", taxon, checklistStatus);
                        continue block8;
                    }
                }
                this.table.put(locationAndStatus.locationCode(), taxon, checklistStatus);
                this.transposed.put(taxon, locationAndStatus.locationCode(), checklistStatus);
            }
        }

        public ExtendedTaxonomyChecklists build() {
            ImmutableMap.Builder<String, ExtendedTaxonomyChecklist> mapBuilder = ImmutableMap.builder();
            for (String checklistId : this.table.rowKeySet()) {
                mapBuilder.put(checklistId, new ExtendedTaxonomyChecklist(this.table.row(checklistId)));
            }
            return new ExtendedTaxonomyChecklists(mapBuilder.build(), new ExtendedTaxonomyTransposedChecklist(this.transposed));
        }
    }
}

